<!--page load auto select first category ad service script start-->
<script>
  let user_currency = "<?= $currency_symbol ?>";
</script>

<script>
  document.addEventListener("DOMContentLoaded", function() {
    const categorySelect = $('#app');
    const serviceSelect = $('#service_id');

    // ЁЯФ╣ Step 1: Auto select first category
    const firstOption = categorySelect.find('option:not([value=""])').first();
    if (firstOption.length) {
      const firstCategoryId = firstOption.val();

      // Trigger change (роЗродройро╛ро▓рпН service load AJAX run роЖроХрпБроорпН)
      categorySelect.val(firstCategoryId).trigger('change.select2').trigger('change');
    }

    // ЁЯФ╣ Step 2: Service auto select once services are loaded
    // Since AJAX takes a few milliseconds, we use an observer or interval
    const observer = new MutationObserver(() => {
      const firstService = serviceSelect.find('option:not([value=""])').first();
      if (firstService.length && !serviceSelect.val()) {
        const firstServiceId = firstService.val();
        serviceSelect.val(firstServiceId).trigger('change.select2').trigger('change');
      }
    });

    // Observe the <select> for changes (new options added)
    observer.observe(serviceSelect[0], {
      childList: true
    });
  });
</script>

<!--page load auto select first category ad service script end-->



<script>
  // url sarvice get



  $(document).ready(function() {
    // Get params from URL
    const urlParams = new URLSearchParams(window.location.search);
    const categoryId = urlParams.get('c'); // category ID
    const serviceId = urlParams.get('s'); // service ID

    if (categoryId) {
      // If category is different from last stored one
      const lastCategoryId = sessionStorage.getItem('catid');
      if (lastCategoryId != categoryId) {
        $('#app').val(categoryId).trigger('change');
        sessionStorage.setItem('catid', categoryId);
      }
    }

    if (serviceId) {
      // Check every 300ms until service options are loaded
      const checkServiceLoaded = setInterval(() => {
        const optionExists = $(`#service_id option[value="${serviceId}"]`).length > 0;
        if (optionExists) {
          $('#service_id').val(serviceId).trigger('change');
          clearInterval(checkServiceLoaded);
        }
      }, 300);

      // Also set hidden input if you have one
      $('#serviceIdInput').val(serviceId);
    }

    // Cleanup UI
    $('#searchResult').empty().removeClass('add-css');
  });
</script>

<script>
  //sarvice sarch script
  $('#serviceSearch').on('keyup', function() {
    const query = $(this).val();
    if (query.length > 1) {
      $.ajax({
        url: 'public/ajx/sarch.php',
        type: 'POST',
        dataType: 'json',
        data: {
          search: query
        },
        success: function(response) {
          if (response.status === 'success' && response.data.length > 0) {


            // need sarch service kku ctacry srvice slct panne 
            let categoryId = response.category || ''; // fallback роТро░рпБ роХро╛ро▓ро┐ропро╛рой string

            if (categoryId) {
              sessionStorage.setItem('catid', categoryId);
            }



     let html = '';
              response.data.forEach(service => {
                html += `<div class="result-item"
        data-id="${service.service_id}"
        data-name="${service.service_name}"
        data-cat="${service.category_id}"> <span class="service-badge">${service.service_id}</span> 
        ${service.service_name} ~ ${user_currency} - ${service.converted_price}
    </div>
    <hr style="margin: 5px 0;">`; // ✅ <hr> correctly inside html string
              });

              $('#searchResult').html(html);







          } else {
            $('#searchResult').html('<div>No services found</div>');
          }
        },
        error: function() {
          $('#searchResult').html('<div>Error fetching services</div>');
        }
      });
    } else {
      $('#searchResult').html('');



    }
  });

  // Click on service result
  $(document).on('click', '.result-item', function() {
    const categoryId = $(this).data('cat');
    const serviceId = $(this).data('id');
    const serviceName = $(this).data('name');

    // Set the category and trigger change
    // $('#neworder_category').val(categoryId).trigger('change');

    // slct ctacary alradi sese sesen save rtun clik onley change service 
    const categoryId_last = sessionStorage.getItem('catid');

    if (categoryId_last != categoryId) {
      $('#app').val(categoryId).trigger('change');
      sessionStorage.setItem('catid', categoryId);
    }




    // Wait for services to load before setting service dropdown
    // Check every 300ms if service option loaded
    const checkServiceLoaded = setInterval(() => {
      const optionExists = $(`#service_id option[value="${serviceId}"]`).length > 0;
      if (optionExists) {
        $('#service_id').val(serviceId).trigger('change');
        clearInterval(checkServiceLoaded);
      }
    }, 300);

    // Set only serviceId input field
    $('#serviceIdInput').val(serviceId);

    // Clear the search result box
    $('#searchResult').empty();




  });
</script>






<!-- fiter btn script start -->
<script>
  function filterStarted(filterName, btn) {
    const categorySelect = $('#app');
    const serviceSelect = $('#service_id');
    const matchText = filterName.toLowerCase().trim();
    categorySelect.empty();
    categorySelect.append(`<option value="">-- Select Category --</option>`);


    serviceSelect.empty();
    serviceSelect.append(`<option value="">-- Select Service --</option>`);

    const allCategories = <?= json_encode($categories); ?>;

    allCategories.forEach(cat => {
      const catNameLower = cat.name.toLowerCase();
      if (matchText === 'everything' || matchText === '' || catNameLower.includes(matchText)) {
        categorySelect.append(`<option value="${cat.id}">${cat.name}</option>`);
      }
    });

    categorySelect.trigger('change.select2');

    // Remove active from all buttons
    document.querySelectorAll('.btn-cat').forEach(b => b.classList.remove('active'));

    // Add active to clicked button
    btn.classList.add('active');







    // uto select first category from filter result
    const firstOption = categorySelect.find('option:not([value=""])').first();
    if (firstOption.length) {
      const firstCategoryId = firstOption.val();
      categorySelect.val(firstCategoryId).trigger('change.select2').trigger('change');
    }

    // uto select first service after it's loaded
    const observer = new MutationObserver(() => {
      const firstService = serviceSelect.find('option:not([value=""])').first();
      if (firstService.length && !serviceSelect.val()) {
        const firstServiceId = firstService.val();
        serviceSelect.val(firstServiceId).trigger('change.select2').trigger('change');
      }
    });







  }
</script>

<!-- filter btn script end -->


<script>
  $('#service_id').on('change', function() {
    var selectedText = $('#service_id option:selected').text().toLowerCase();

    if (selectedText.includes('custom')) {
      $('#commentBox').show();
      $('#quantity').prop('disabled', true);
    } else {
      $('#commentBox').hide();
      $('#quantity').prop('disabled', false);
      $('#quantity').val('');
    }
  });



  $('#comments').on('input', function() {
    var lines = $(this).val().split('\n');
    var nonEmptyLines = lines.filter(function(line) {
      return line.trim() !== '';
    });

    var lineCount = nonEmptyLines.length;
    $('#quantity').val(lineCount).trigger('input'); // ЁЯФБ Trigger price calculation
  });
</script>






<script>
  $(document).ready(function() {
    $('#service_id').select2({
      placeholder: "-- Select Service --",
      allowClear: true,
      width: '100%',

      templateResult: function(data) {
        if (!data.id) return data.text; // placeholder
        // Only ID in green badge, service name normal
        return $('<span><span class="badge service-badge me-2">' + data.id + '</span>' + data.text + '</span>');
      },
      templateSelection: function(data) {
        if (!data.id) return data.text;
        return $('<span><span class="badge service-badge me-2">' + data.id + '</span>' + data.text + '</span>');
      },
      escapeMarkup: function(markup) {
        return markup;
      }


    });
  });
</script>
<!-- Custom CSS -->
<style>
  /* Single selection style - upgraded */
  .select2-container--default .select2-selection--single {
    height: 52px;
    padding: 10px 16px;
    border-radius: 16px;
    /* more rounded */
    border: 1px solid #ced4da;
    background: linear-gradient(135deg, #ffffff, #f0f4ff);
    /* subtle gradient */
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    font-size: 16px;
    transition: all 0.4s ease;
  }

  /* Focus effect - glow */
  .select2-container--default.select2-container--focus .select2-selection--single {
    border-color: #0a58ca;
    box-shadow: 0 0 12px rgba(10, 88, 202, 0.35);
    /* glowing effect */
  }



  /* Placeholder */
  .select2-container--default .select2-selection--single .select2-selection__placeholder {
    color: #6c757d;

  }

  /* Arrow icon - rotation on open */
  .select2-container--default .select2-selection--single .select2-selection__arrow b {
    border-color: #0a58ca transparent transparent transparent;
    transition: transform 0.3s ease;
  }

  .select2-container--open .select2-selection__arrow b {
    transform: rotate(180deg);
  }

  /* Dropdown options - gradient hover + subtle shadow */
  .select2-container--default .select2-results__option {
    padding: 12px 18px;
    border-radius: 10px;
    margin: 3px 0;

  }

  .select2-container--default .select2-results__option--highlighted {
    background: linear-gradient(135deg, #0a58ca, #0d6efd);
    color: #fff;
    font-weight: 600;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);

  }

  /* Firefox scrollbar */
  .select2-container--default .select2-results__options {
    scrollbar-width: thin;
    /* thin, auto, none */
    scrollbar-color: #0a58ca #e9ecef;
    /* thumb color, track color */
  }

  /* Webkit scrollbar (Chrome, Edge, Safari) */
  .select2-container--default .select2-results__options::-webkit-scrollbar {
    width: 8px;

  }

  .select2-container--default .select2-results__options::-webkit-scrollbar-thumb {
    background: linear-gradient(180deg, #0a58ca, #0d6efd);
    border-radius: 4px;
  }

  .select2-container--default .select2-results__options::-webkit-scrollbar-track {
    background: #e9ecef;
    border-radius: 4px;
  }


  .select2-container--default .select2-results__options::-webkit-scrollbar-thumb {
    background: linear-gradient(180deg, #0a58ca, #0d6efd);
    border-radius: 4px;
  }
</style>

<script>
  $(document).ready(function() {
    $('#app').select2({
      placeholder: "-- Select Category --",
      allowClear: true,
      width: '100%'
    });
  });
</script>



<script>
  $('form').on('submit', function(e) {
    let price = $('#price').val();
    let qty = parseInt($('#quantity').val());
    let selectedOption = $('#service_id option:selected');
    let min = parseInt(selectedOption.data('min')) || 1;
    let max = parseInt(selectedOption.data('max')) || 100000;

    // тЬЕ Step 1: Price box роХро╛ро▓ро┐ропро╛ роЗро░рпБроХрпНроХро╛? роЕро▓рпНро▓родрпБ 0/NaN роЖ роЗро░рпБроХрпНроХро╛?
    if (price === '' || parseFloat(price) <= 0 || isNaN(parseFloat(price))) {
      e.preventDefault();
      Swal.fire({
        icon: 'warning',
        title: 'Attention!',
        text: `Please select a valid service and quantity  to calculate the price.`,
        confirmButtonText: 'OK'
      });
      return;
    }

    // тЬЕ Step 2: Quantity min/max range-роХрпНроХрпБро│рпН роЗро░рпБроХрпНроХро╛?
    if (isNaN(qty) || qty < min || qty > max) {
      e.preventDefault();
      Swal.fire({
        icon: 'warning',
        title: 'Invalid Quantity',
        text: `Please enter a quantity between ${min} and ${max}.`,
        confirmButtonText: 'OK'
      });
      return;
    }
  });











  $('#app').on('change', function() {
    let app = $(this).val();
    $('#service_id').html('<option>Loading...</option>');

    $.get('api/get_services.php?app=' + app, function(data) {
      const services = JSON.parse(data);
      let options = '<option value="">Select Service</option>';
      services.forEach(s => {
        options += `<option value="${s.id}" 
                    data-price="${s.price}" 
                    data-converted_price_user_currency="${s.converted_price_user_currency}"
                    data-description="${s.description}" 
                    data-min="${s.min_quantity}" 
                    data-max="${s.max_quantity}">
   ${s.service_name} ~ ${user_currency} - ${s.converted_price_user_currency}
</option>`;

      });
      $('#service_id').html(options);
    });
  });



  $('#service_id').on('change', function() {
    let option = $(this).find('option:selected');
    let desc = option.data('description');
    $('#service_description').text(desc || '');
    $('#price').val('');





    // тнРя╕П New: Show description box only if description is available

    $(document).ready(function() {
      let option = $('#service_id').find('option:selected');
      let desc = option.data('description') || '';

      let formatted = desc.replace(/\n/g, "<br>");


      $('#service_description').html(formatted);

      if (desc.trim() !== '') {
        $('#descriptionBox').show();
      } else {
        $('#descriptionBox').hide();
      }
    });



    // тнРя╕П New: Set min and max on quantity input
    let min = option.data('min') || 1;
    let max = option.data('max') || 100000;


    // тЬЕ Show quantity range
    $('#qty-range').text(`(Min: ${min}, Max: ${max})`);
  });

  $('#quantity').on('input', function() {

    let qty = parseInt($(this).val()) || 0;

    // User currency price
    let priceUser = parseFloat($('#service_id option:selected').data('converted_price_user_currency')) || 0;
    let totalUser = qty * (priceUser / 1000);
    $('#converted_price_user_currency').val(totalUser);

    // LKR price
    let priceLKR = parseFloat($('#service_id option:selected').data('price')) || 0;
    let totalLKR = qty * (priceLKR / 1000);
    $('#price').val(totalLKR.toFixed(2));


  });
</script>