<?php
include 'config/db.php';
include 'public/session.php';
include 'public/include/titlemg.php';
include 'public/include/email_verify.php';




// Fetch referral commission and status from referel table (assuming only 1 row)
$referelComisen = null;
$refrelStatus = null;

$refSql = "SELECT referel_comisen, refrel_status FROM referel LIMIT 1";
$refResult = $connect->query($refSql);
if ($refRow = $refResult->fetch_assoc()) {
  $referelComisen = $refRow['referel_comisen'];
  $refrelStatus = $refRow['refrel_status'];
}


// Refer History fanction

$name = $_SESSION['name'];

// Fetch referral commission records
$stmt = $connect->prepare("SELECT referred_username, amount, created_at, id FROM referral_commissions WHERE refer_username = ? ORDER BY created_at DESC");
$stmt->bind_param("s", $name);
$stmt->execute();
$result_history = $stmt->get_result();





$userId = $_SESSION['id'];

// Fetch refer code from DB
$sql = "SELECT refer FROM users2 WHERE id = ?";
$stmt = mysqli_prepare($connect, $sql);
mysqli_stmt_bind_param($stmt, "i", $userId);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if ($user = mysqli_fetch_assoc($result)) {
  $referCode = $user['refer'];
} else {
  $referCode = null;
}

// Build full referral URL
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$domain = $_SERVER['HTTP_HOST'];
$referralLink = $protocol . $domain . "/public/refr?code=" . urlencode($referCode);
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />




  <title>Referral System | <?= htmlspecialchars($sitename) ?> | Earn Rewards by Inviting Friends</title>

<meta name="description" content="Join the <?= htmlspecialchars($sitename) ?> referral system and earn bonuses for every user you invite. Get rewarded for helping others grow on Instagram, TikTok, and YouTube.">
<meta name="keywords" content="referral system, earn rewards, invite friends, smm panel sri lanka, affiliate program, social media marketing, rootsmm, rootmasterlk">

<meta name="robots" content="index, follow">
<meta name="author" content="<?= htmlspecialchars($sitename) ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Open Graph / Facebook / Instagram -->
<meta property="og:title" content="Referral System | <?= htmlspecialchars($sitename) ?>">
<meta property="og:description" content="Invite friends to <?= htmlspecialchars($sitename) ?> and earn referral rewards. Help others boost their Instagram, TikTok, and YouTube accounts.">
<meta property="og:type" content="website">
<meta property="og:url" content="https://rootmasterlk.store/referral">
<meta property="og:image" content="<?= htmlspecialchars($site_image) ?>">
<meta property="og:site_name" content="<?= htmlspecialchars($sitename) ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Referral System | <?= htmlspecialchars($sitename) ?>">
<meta name="twitter:description" content="Earn rewards with <?= htmlspecialchars($sitename) ?> by inviting friends to our trusted SMM panel. Grow together on Instagram, TikTok & YouTube.">
<meta name="twitter:image" content="<?= htmlspecialchars($site_image) ?>">

<!-- Canonical -->
<link rel="canonical" href="https://rootmasterlk.store/referral">

<!-- JSON-LD Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "name": "Referral System - <?= htmlspecialchars($sitename) ?>",
  "url": "https://rootmasterlk.store/referral",
  "description": "Refer your friends to <?= htmlspecialchars($sitename) ?> and earn commission for each new signup or purchase they make on our SMM panel.",
  "publisher": {
    "@type": "Organization",
    "name": "<?= htmlspecialchars($sitename) ?>",
    "logo": "<?= htmlspecialchars($site_image) ?>"
  }
}
</script>



  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      background: #f5f4fa;
      font-family: 'Poppins', sans-serif;
    }

    .card {
      border: none;
      border-radius: 15px;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
      transition: 0.3s;
    }

    .card:hover {
      transform: translateY(-3px);
    }

    .bg-custome {
      background: linear-gradient(135deg, #6c63ff, #3f3fff);
      color: #fff;
    }

    .btn-copy {
      border-radius: 25px;
      font-weight: 600;
      transition: 0.3s;
    }

    .btn-copy:hover {
      background-color: #3f3fff;
      color: #fff;
    }

    .badge {
      font-size: 0.9rem;
      border-radius: 20px;
      padding: 8px 12px;
    }

    table th {
      background-color: #6c63ff;
      color: #fff;
      text-transform: uppercase;
    }

    table td {
      vertical-align: middle;
    }

    #copyAlert {
      font-weight: 600;
      animation: fadeInOut 2s ease-in-out;
    }

    @keyframes fadeInOut {
      0% {
        opacity: 0;
      }

      20% {
        opacity: 1;
      }

      80% {
        opacity: 1;
      }

      100% {
        opacity: 0;
      }
    }

    @media (max-width: 768px) {
      .card {
        margin-bottom: 20px;
      }
    }
  </style>
</head>

<body>
  <?php include 'public/include/header.php'; ?>

  <div class="container mt-5">
    <div class="row g-4">

      <!-- 🔗 Referral Link -->
      <div class="col-md-6">
        <div class="card bg-custome p-4">
          <div class="text-center">
            <h4 class="fw-bold mb-3"><i class="bi bi-link-45deg me-1"></i> Your Referral Link</h4>

            <?php if ($referCode): ?>
              <div class="input-group mb-3">
                <input type="text" id="referralLink" class="form-control text-center"
                  value="<?= htmlspecialchars($referralLink) ?>" readonly>
                <button class="btn btn-light btn-copy" onclick="copyReferralLink()">
                  <i class="bi bi-clipboard-check-fill me-1"></i> Copy
                </button>
              </div>
              <div id="copyAlert" class="text-success small" style="display:none;">✅ Link copied successfully!</div>
            <?php else: ?>
              <p class="text-warning">Referral code not found.</p>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- 📊 Referral Details -->
      <div class="col-md-6">
        <div class="card bg-custome p-4">
          <div>
            <h4 class="fw-bold mb-3"><i class="bi bi-bar-chart-fill me-1"></i> Referral Details</h4>
            <p><strong><i class="bi bi-percent me-1"></i>Commission:</strong>
              <?= $referelComisen !== null ? "<span class='badge bg-light text-dark fw-semibold'>{$referelComisen}%</span>" : "Not set" ?>
            </p>

            <p><strong><i class="bi bi-toggle-on me-1"></i>Status:</strong>
              <?php if ($refrelStatus === null): ?>
                <span class="badge bg-secondary">Not set</span>
              <?php elseif ($refrelStatus == 1): ?>
                <span class="badge bg-success"><i class="bi bi-check-circle-fill me-1"></i> Active</span>
              <?php else: ?>
                <span class="badge bg-danger"><i class="bi bi-x-circle-fill me-1"></i> Inactive</span>
              <?php endif; ?>
            </p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- 🧾 Referral History -->
  <div class="container py-5">
    <div class="card p-4">
      <div class="card-header text-center bg-primary text-white fw-bold rounded mb-3">
        <h5 class="mb-0"><i class="bi bi-cash-coin me-1"></i> Referral Commission History</h5>
      </div>
      <div class="card-body">
        <div class="table-responsive">
          <table class="table table-bordered table-hover text-center align-middle">
            <thead>
              <tr>
                <th>#</th>
                <th>Referred User</th>
                <th>Commission ~ <?= $currency_symbol ?></th>
                <th>Date</th>
              </tr>
            </thead>
            <tbody>
              <?php if ($result_history && $result_history->num_rows > 0): ?>
                <?php while ($row = $result_history->fetch_assoc()): ?>
                  <tr>
                    <td><?= $row['id'] ?></td>
                    <td><i class="bi bi-person-circle me-1 text-primary"></i><?= htmlspecialchars($row['referred_username']) ?></td>
                    <td class="text-success fw-bold">
    <i class="bi bi-currency-rupee"></i>
    <?= number_format(convertFromtoLKR($row['amount'], $user_currency), 6) ?>
</td>

                    <td><?= date("d-m-Y h:i A", strtotime($row['created_at'])) ?></td>
                  </tr>
                <?php endwhile; ?>
              <?php else: ?>
                <tr>
                  <td colspan="4" class="text-muted">No referral commission records found.</td>
                </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

  <!-- 📋 Copy Script -->
  <script>
    function copyReferralLink() {
      const copyText = document.getElementById("referralLink");
      copyText.select();
      copyText.setSelectionRange(0, 99999);
      navigator.clipboard.writeText(copyText.value).then(() => {
        const alertBox = document.getElementById('copyAlert');
        alertBox.style.display = 'block';
        setTimeout(() => alertBox.style.display = 'none', 2000);
      });
    }
  </script>

  <?php include 'public/include/footer.php'; ?>
  <?php include 'public/include/whatsapp.php'; ?>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>