<?php
require('../../config/db.php');
include '../session.php'; // login check
include '../include/titlemg.php';
include '../include/email_verify.php';

// ✅ Get user ID from cookie or session
if (isset($_COOKIE['user_id'])) {
    $_SESSION['id'] = $_COOKIE['user_id'];
}

$user_id = $_SESSION['id'] ?? null;

// ✅ Check if user exists
if (!$user_id) {
    header("Location: ../../index");
    exit();
}

// ✅ Check re_seller permission
$stmt = $connect->prepare("SELECT re_seller FROM users2 WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user || $user['re_seller'] != 1) {
   $_SESSION['error'] = "You don't have permission to access this page.";
    header("Location: ../../index");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Reseller Dashboard - ROOT SMM V-1</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      background-color: #f8f9fa;
    }

    .summary-card {
      border-radius: 15px;
      color: white;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
      transition: transform 0.2s;
      max-width: 350px;
      margin: 0 auto;
    }

    .summary-card:hover {
      transform: scale(1.03);
    }

    .summary-icon {
      font-size: 2.5rem;
    }

    .card {
      border-radius: 12px;
    }

    .filter-section {
      background: white;
      border-radius: 15px;
      box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
      padding: 20px;
    }

    @media (max-width: 768px) {
      .summary-card h3 {
        font-size: 1.3rem;
      }
      .summary-card h5, .summary-card h4 {
        font-size: 1rem;
      }
    }
  </style>
</head>
<body>
<?php include '../include/header.php'; ?>
  <div class="container py-5">
    <h2 class="text-center mb-4 fw-bold text-primary">Reseller Dashboard</h2>

    <!-- 🔹 Date Range Filter -->
    <div class="filter-section mb-4 text-center">
      <h5 class="fw-bold text-secondary mb-3">Select Date Range</h5>
      <div class="row justify-content-center g-2">
        <div class="col-12 col-sm-4 col-md-3">
          <input type="date" id="fromDate" class="form-control" placeholder="From Date" />
        </div>
        <div class="col-12 col-sm-4 col-md-3">
          <input type="date" id="toDate" class="form-control" placeholder="To Date" />
        </div>
        <div class="col-12 col-sm-4 col-md-2">
          <button id="filterBtn" class="btn btn-primary w-100">
            <i class="bi bi-search"></i> Filter
          </button>
        </div>
      </div>
    </div>

    <!-- 🔹 Summary Section -->
    <div class="row justify-content-center" id="summarySection">
      <!-- JS will inject content here -->
    </div>
  </div>

  <!-- Bootstrap + jQuery -->
  <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    function loadSummary(day = 7, from = '', to = '') {
      $("#summarySection").html(`
        <div class="col-12 text-center">
          <div class="spinner-border text-primary" role="status"></div>
          <p class="text-muted mt-2">Loading summary...</p>
        </div>
      `);

      let apiUrl = `../../admin/more/spand.php?key=access`;
      if (from && to) {
        const diffDays = Math.floor((new Date(to) - new Date(from)) / (1000 * 60 * 60 * 24));
        apiUrl += `&day=${diffDays}`;
      } else {
        apiUrl += `&day=${day}`;
      }

      $.getJSON(apiUrl, function(data) {
        if (data.status === "success") {
          $("#summarySection").html(`
            <div class="col-12 ">
              <div class="card summary-card bg-success p-4 text-center">
                <i class="bi bi-graph-up summary-icon mb-2"></i>
                <h5>Total Profit ${from && to ? `(Custom Range)` : `(Last ${day} Days)`}</h5>
                ${from && to ? `<h6 class="text-light">From ${from} to ${to}</h6>` : ''}
                <h3 class="fw-bold mt-2">${data.total_profit} ${data.currency || 'LKR'}</h3>
              </div>
            </div>
          `);
        } else {
          $("#summarySection").html(`<div class='alert alert-danger text-center'>Error loading data</div>`);
        }
      }).fail(function() {
        $("#summarySection").html(`<div class='alert alert-danger text-center'>Failed to fetch summary data</div>`);
      });
    }

    // ✅ Default load
    $(document).ready(() => loadSummary());

    // ✅ Filter button
    $("#filterBtn").click(() => {
      const from = $("#fromDate").val();
      const to = $("#toDate").val();

      if (!from || !to) {
        alert("Please select both From and To dates.");
        return;
      }

      loadSummary(0, from, to);
    });
  </script>
  <?php include '../include/footer.php'; ?>
</body>
</html>
