<?php
require("../config/db.php");
include 'include/titlemg.php';
session_start();



if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST['submit'])) {
    $email = $_POST['email'];
    $userName = $_POST['name'];

    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    // Check if email already exists
    $emailCheckQuery = "SELECT * FROM users2 WHERE email = ? OR username = ?";
    $stmt = mysqli_prepare($connect, $emailCheckQuery);
    mysqli_stmt_bind_param($stmt, "ss", $email, $userName);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);

        if ($row['email'] == $email) {
            $_SESSION['error'] = "The email address is already registered. Please use a different email.";
        } elseif ($row['username'] == $userName) {
            $_SESSION['error'] = "The username is already taken. Please choose a different username.";
        }

        header("Location: register");
        exit();
    }

    // Example: you are getting this from somewhere
    $emailVerificationSend = $user_conformasen; // or 0

    // Logic: reverse status
    $status = $emailVerificationSend ? 0 : 1;

    // Generate unique refer code (6 characters)
    $referCode = substr(str_shuffle("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, 6);

    // Get referral from cookie if available
    $referBy = $_COOKIE['ref_code'] ?? null;

    // Insert the new user with status
    $sql = "INSERT INTO users2 (email, username, password, status, refer, refer_by) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($connect, $sql);
    mysqli_stmt_bind_param($stmt, "sssiss", $email, $userName, $password, $status, $referCode, $referBy);

    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['success'] = "New account created successfully";
        header("Location: login");
        exit();
    } else {
        $_SESSION['error'] = "Registration failed. Please try again. Error: " . mysqli_error($connect);
        header("Location: register");
        exit();
    }





    mysqli_stmt_close($stmt);
    mysqli_close($connect);
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- 
    seo -->
    <title>Register - <?= htmlspecialchars($sitename) ?> | Create Your Account</title>

    <meta name="description" content="Register now on <?= htmlspecialchars($sitename) ?> to start buying Instagram followers, TikTok likes, and YouTube views. Join Sri Lanka’s best SMM panel today.">
    <meta name="keywords" content="register, signup, smm panel registration, create account, smm panel sri lanka, instagram followers, tiktok likes, youtube views, social media marketing, rootsmm, rootmasterlk">

    <meta name="robots" content="index, follow">
    <meta name="author" content="<?= htmlspecialchars($sitename) ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Open Graph / Facebook / Instagram -->
    <meta property="og:title" content="Register - <?= htmlspecialchars($sitename) ?> | Join Now">
    <meta property="og:description" content="Create your <?= htmlspecialchars($sitename) ?> account to access top SMM services for Instagram, TikTok, and YouTube. Fast & secure signup.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://rootmasterlk.store/register">
    <meta property="og:image" content="<?= htmlspecialchars($site_image) ?>">
    <meta property="og:site_name" content="<?= htmlspecialchars($sitename) ?>">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Register - <?= htmlspecialchars($sitename) ?>">
    <meta name="twitter:description" content="Sign up to <?= htmlspecialchars($sitename) ?> — Sri Lanka’s trusted SMM panel for Instagram, TikTok, and YouTube growth.">
    <meta name="twitter:image" content="<?= htmlspecialchars($site_image) ?>">

    <!-- Canonical -->
    <link rel="canonical" href="https://rootmasterlk.store/register">

    <!-- JSON-LD Schema -->
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebPage",
            "name": "Register - <?= htmlspecialchars($sitename) ?>",
            "url": "https://rootmasterlk.store/register",
            "description": "Register your account on <?= htmlspecialchars($sitename) ?> and start using premium SMM services for Instagram, TikTok, YouTube, and Facebook.",
            "publisher": {
                "@type": "Organization",
                "name": "<?= htmlspecialchars($sitename) ?>",
                "logo": "<?= htmlspecialchars($site_image) ?>"
            }
        }
    </script>

    <!-- seo -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .card {
            border: none;
            border-radius: 1.5rem;
            overflow: hidden;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.2);

        }

        .img-left {
            background: url('<?php echo $header_img; ?>') center center no-repeat;
            background-size: cover;
        }

        .login-form {
            padding: 2rem 2.5rem;
            background: linear-gradient(135deg, #6c63ff 0%, #3f3fff 100%);

        }

        .form-control {
            border-radius: 10px;
        }

        .btn-login {
            width: 100%;
            border-radius: 10px;
            padding: 10px;
        }

        @media (max-width: 768px) {
            .img-left {
                display: none;
            }
        }
    </style>
</head>

<body>
    <?php include 'include/header.php'; ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10 py-4">
                <div class="card">
                    <div class="row g-0">
                        <div class="col-md-6 img-left d-none d-md-block"></div>
                        <div class="col-md-6 bg-white login-form text-light fw-bold">
                            <h3 class="text-center mb-4 text-light">Register at <span class="text-info"><?php echo $main_name ?></span></h3>

                            <?php
                            if (isset($_SESSION['success'])) {
                                echo '<div class="alert alert-success">' . $_SESSION['success'] . '</div>';
                                unset($_SESSION['success']);
                            } elseif (isset($_SESSION['error'])) {
                                echo '<div class="alert alert-danger">' . $_SESSION['error'] . '</div>';
                                unset($_SESSION['error']);
                            }
                            ?>

                            <form action="" method="POST">
                                <div class="mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" name="email" class="form-control" placeholder="Enter email" required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Username</label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter username" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Password</label>
                                    <input type="password" name="password" class="form-control" placeholder="Enter password" required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Confirm Password</label>
                                    <input type="password" name="confirm_password" class="form-control" placeholder="Confirm password" required>
                                    <div class="invalid-feedback text-info" id="confirm-error">
                                        Passwords do not match.
                                    </div>
                                </div>
                                
                                
                                <div class="mb-3 form-check">
    <input type="checkbox" class="form-check-input" id="tc" >
    <label class="form-check-label text-light" for="tc">
        I agree to the 
        <a href="<?php echo $site_main_urluni; ?>/public/terms" class="text-info" target="_blank">Terms & Conditions</a>
    </label>
    <div class="invalid-feedback text-info" id="tc-error">
        You must accept the Terms & Conditions to continue.
    </div>
</div>



                                <button type="submit" name="submit" class="btn btn-primary btn-login">Register</button>
                                <div class="text-center mt-3">
                                    <a href="login.php" class="text-decoration-none text-light">Already have an account? Login</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'include/whatsapp.php'; ?>
    <?php include 'include/footer.php'; ?>

    <script>
        const form = document.querySelector('form');
        const password = form.password;
        const confirmPassword = form.confirm_password;
        const errorDiv = document.getElementById('confirm-error');
        
             // ✅ 2. Terms & Conditions Checkbox Validation
        
           const tc = document.getElementById('tc');
    const tcError = document.getElementById('tc-error');

        form.addEventListener('submit', function(e) {
            if (password.value !== confirmPassword.value) {
                e.preventDefault(); // form submit block பண்ணும்
                confirmPassword.classList.add('is-invalid'); // Bootstrap red border
                errorDiv.style.display = 'block';
            } else {
                confirmPassword.classList.remove('is-invalid');
                errorDiv.style.display = 'none';
            }
            
            
            
            
            
            
            
            
            
            // ✅ 2. Terms & Conditions Checkbox Validation
        if (!tc.checked) {
            e.preventDefault();
            tc.classList.add('is-invalid');
            tcError.style.display = 'block';
            return;
        } else {
            tc.classList.remove('is-invalid');
            tcError.style.display = 'none';
        }
        });
    </script>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>