<?php

session_start();
require("../config/db.php");

// Query string-ல code என்ற param இருந்தா அதை எடுக்கலாம்
if (isset($_GET['code'])) {
    $refCode = $_GET['code'];

    // DB-ல் code இருக்கிறதா சரிபார்க்க
    $stmt = mysqli_prepare($connect, "SELECT id FROM users2 WHERE refer = ?");
    mysqli_stmt_bind_param($stmt, "s", $refCode);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_store_result($stmt);

    if (mysqli_stmt_num_rows($stmt) > 0) {
        setcookie('ref_code', $refCode, time() + (3 * 24 * 60 * 60), "/");
        $_COOKIE['ref_code'] = $refCode; // immediate usage-க்கு
        
    }
}

// Redirect to homepage
header("Location: ../index");
exit();
