<?php
header("Content-Type: application/json");
session_start();
require_once '../../config/db.php';

// Read JSON
$input = json_decode(file_get_contents("php://input"), true);
if (!isset($input["id_token"])) {
    echo json_encode(['success' => false, 'message' => 'No token received']);
    exit;
}

$id_token = $input["id_token"];

// GOOGLE VERIFY USING CURL
$verify_url = "https://oauth2.googleapis.com/tokeninfo?id_token=" . urlencode($id_token);

$ch = curl_init($verify_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 15);

$response = curl_exec($ch);
$curl_error = curl_error($ch);
curl_close($ch);

if (!$response) {
    echo json_encode(['success' => false, 'message' => 'Google verification failed']);
    exit;
}

$user_data = json_decode($response, true);

if (!isset($user_data["email"])) {
    echo json_encode(['success' => false, 'message' => 'Invalid Google token']);
    exit;
}

// USER DATA
$email = $user_data["email"];
$username = explode("@", $email)[0];
$picture = $user_data["picture"] ?? "";

// CHECK IF USER EXISTS
$stmt = $connect->prepare("SELECT id, username FROM users2 WHERE email = ? LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows > 0) {

    $row = $res->fetch_assoc();
    $user_id = $row["id"];
    $username = $row["username"];

} else {

    // NEW USER INSERT
    $referBy = $_COOKIE["ref_code"] ?? null;
    $referCode = substr(str_shuffle("ABCDEFGHJKLMNPQRSTUVWXYZ23456789"), 0, 6);

    // Required values
    $password = "";
    $balance = 0;
    $status = 1;
    $api_key = "";
    $verify_token = "";
    $comisen_parsentang = 0;
    $custome_ref = 0;
    $re_seller = 0;

    // FINAL INSERT QUERY — matches DB columns EXACTLY
    $sql = "INSERT INTO users2 
    (username, email, password, balance, api_key, status, verify_token, refer, refer_by, comisen_parsentag, custome_ref, re_seller)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $ins = $connect->prepare($sql);
    $ins->bind_param(
        "sssdsisssiii",
        $username,
        $email,
        $password,
        $balance,
        $api_key,
        $status,
        $verify_token,
        $referCode,
        $referBy,
        $comisen_parsentang,
        $custome_ref,
        $re_seller
    );

    if (!$ins->execute()) {
        echo json_encode([
            "success" => false,
            "message" => "Insert failed",
            "sql_error" => $ins->error
        ]);
        exit;
    }

    $user_id = $ins->insert_id;
}

// LOGIN SESSION
$_SESSION["id"] = $user_id;
$_SESSION["name"] = $username;
$_SESSION["email"] = $email;
$_SESSION["picture"] = $picture;

setcookie("user_id", $user_id, time() + (86400 * 30), "/");
setcookie("username", $username, time() + (86400 * 30), "/");


   $_SESSION['success'] = "Login successful! Welcome back, $username.";

echo json_encode(["success" => true, "redirect" => "../index"]);
exit;
