<?php
require("../config/db.php");
include 'include/titlemg.php';
session_start();



if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST["email"];

    // DB-ல் user இருக்கானு check பண்ணுறது
    $sql = "SELECT id FROM users2 WHERE email=?";
    $stmt = mysqli_prepare($connect, $sql);
    mysqli_stmt_bind_param($stmt, "s", $email);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_store_result($stmt);

    if (mysqli_stmt_num_rows($stmt) > 0) {

        // OTP Generate பண்ணுறது
        $otp = rand(100000, 999999);
        $_SESSION['otp'] = $otp;
        $_SESSION['otp_email'] = $email;

        // Domain Name Auto Detect
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
        $domain = $_SERVER['HTTP_HOST'];
        $from = "no-reply@$domain";

        // Mail content
        $subject = "🔐 Your OTP Code";
        $message = "Your OTP code is: $otp";

        // SMTP Headers
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/plain;charset=UTF-8" . "\r\n";
        $headers .= "From: OTP Service <$from>" . "\r\n";
        $headers .= "Reply-To: $from" . "\r\n";

        // 🟢 SMTP Mail Send using mail() - Server should support it (Hostinger OK)
        if (mail($email, $subject, $message, $headers)) {
            header("Location: verify_otp.php");
            exit;
        } else {
            $error = "❌ Email sending failed. Try again!";
        }
    } else {
        $error = "❌ Email not found!";
    }
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Forgot Password</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>

<body class="bg-light d-flex align-items-center justify-content-center min-vh-100">

  <div class="card shadow-sm p-4" style="max-width: 400px; width: 90%;">
    <h3 class="text-center fw-bold text-primary mb-4">Forgot Password</h3>

    <?php if (isset($error)) : ?>
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($error) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      </div>
    <?php endif; ?>

    <form method="post" novalidate>
      <div class="mb-3">
        <label for="email" class="form-label fw-semibold">Email address</label>
        <input type="email" id="email" name="email" class="form-control form-control-lg" placeholder="Enter your email" required />
      </div>

      <button type="submit" name="submit" class="btn btn-success btn-lg w-100 fw-semibold">
        Send OTP
      </button>
    </form>

    <div class="text-center mt-3">
      <a href="login" class="text-decoration-none fw-semibold text-primary">
        ← Back to Login
      </a>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <?php include 'include/whatsapp.php'; ?>

</body>

</html>
