<?php
include '../config/db.php';
include '../public/session.php';
include '../public/include/titlemg.php';
include '../public/include/email_verify.php';


$_SESSION['pages_redirect'] = "1";

function formatNumber($num)
{
    if (floor($num) == $num) {
        return number_format($num, 0);
    } else {
        return number_format($num, 2);
    }
}


$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ||
    $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$host = $_SERVER['HTTP_HOST'];
$domain = $protocol . $host; // 👈 subfolder சேர்க்கவே வேண்டாம்



// get database offers %
$query = "SELECT ez_number, offers_percentage, status FROM ez_auto_payment_setting LIMIT 1";
$result = $connect->query($query);

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $ez_number = $row['ez_number'];
    $ez_extra_smm = $row['offers_percentage'];
    $status = $row['status'];
    if ($status == 0) {
        $_SESSION['error'] = "Payment is disabled!";
        header("Location: ../add_Found_history");
        exit();
    }
} else {
    $_SESSION['error'] = "Settings not found!";
    header("Location: ../add_Found_history");
    exit();
}

$showModal = false;
$modalMessage = '';
$ez_extra_smm_formatted = formatNumber($ez_extra_smm);

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $rn_number = $_POST['rn_number'] ?? '';
    $type = "smm";

    $stmt = $connect->prepare("SELECT * FROM ez_payment WHERE rn_number = ?");
    $stmt->bind_param("s", $rn_number);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        $_SESSION['error'] = 'Invalid RN Number!';
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit();
    }

    $payment = $result->fetch_assoc();
    $amountLKR = $payment['net_received'];

    // check type
    if (strtolower($type) === 'smm') {
        // offers % added
        $amountLKR = $amountLKR + ($amountLKR * $ez_extra_smm) / 100;

        $postData = [
            'username' => $username,
            'amount' => $amountLKR,
        ];

        $ch = curl_init("$domain/admin/api_payment");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
        $apiResult = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode == 200 && strpos(strtolower($apiResult), 'username not found') !== false) {
            $_SESSION['error'] = 'Username not found. Please try again.';
            header('Location: ' . $_SERVER['PHP_SELF']);
            exit();
        }

        if ($httpCode == 200) {
            $txn_id = $rn_number;

            // Telegram message
            $sql = "SELECT bot_token, chat_id FROM telegram_bots WHERE status = 1";
            $botResult = mysqli_query($connect, $sql);

            $telegramMessage = "✅ *New Payment Received*\n\n"
                . "👤 *Username:* $username\n"
                . "💸 *Amount (LKR):* Rs $amountLKR\n"
                . "🧾 *Transaction ID:* $txn_id\n";

            while ($bot = mysqli_fetch_assoc($botResult)) {
                $url = "https://api.telegram.org/bot{$bot['bot_token']}/sendMessage";
                $data = [
                    'chat_id' => $bot['chat_id'],
                    'text' => $telegramMessage,
                    'parse_mode' => 'Markdown'
                ];
                file_get_contents($url . '?' . http_build_query($data));
            }

            $connect->query("DELETE FROM ez_payment WHERE rn_number = '$rn_number'");

            $_SESSION['success'] = 'Payment added successfully! Amount: LKR ' . $amountLKR . ' Username: ' . $username;
        } else {
            $_SESSION['error'] = 'Something went wrong. Please try again later.';
        }

        header('Location: ' . $_SERVER['PHP_SELF']);
        exit();
    } else {
        $_SESSION['error'] = 'Invalid payment type!';
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit();
    }
}

if (!isset($_SESSION['bonus_modal_shown'])) {
    if ($ez_extra_smm > 0) {
        $modalMessage = "🎁 An extra {$ez_extra_smm_formatted}% bonus is available for EZ  payments.";
        $showModal = true;
    }
    if ($showModal) {
        $_SESSION['bonus_modal_shown'] = true;
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Verify Payment</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body>
    <?php include '../public/include/header.php'; ?>

    <?php if (isset($_SESSION['success'])): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Success',
                text: <?= json_encode($_SESSION['success']) ?>
            });
        </script>
    <?php unset($_SESSION['success']);
    endif; ?>

    <?php if (isset($_SESSION['error'])): ?>
        <script>
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: <?= json_encode($_SESSION['error']) ?>
            });
        </script>
    <?php unset($_SESSION['error']);
    endif; ?>

    <div class="container py-4">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 col-lg-6">
                <div class="card shadow-lg border-0 rounded-4">
                    <div class="card-header bg-primary text-white text-center">
                        <h4 class="mb-0">🧾 Ez Payment Verification</h4>
                    </div>
                    <div class="card-body p-4">

                        <!-- Ez Number Box -->
                        <div class="input-group mb-4">
                            <input type="text" class="form-control text-center fw-bold fs-5" id="ezNumberText" value="<?= htmlspecialchars($ez_number) ?>" readonly>
                            <button class="btn btn-outline-secondary" type="button" onclick="copyText()">📋</button>
                        </div>

                        <!-- Form Start -->
                        <form method="POST" action="" onsubmit="return showLoading()">
                            <div class="mb-3">
                                <label for="username" class="form-label">User Name</label>
                                <input type="text"
                                    name="username"
                                    id="username"
                                    value="<?php echo htmlspecialchars($_SESSION['name']); ?>"
                                    class="form-control form-control-lg" readonly>
                            </div>

                            <div class="mb-3">
                                <label for="rn_number" class="form-label">RN Number</label>
                                <input type="text"
                                    name="rn_number"
                                    id="rn_number"
                                    required
                                    class="form-control form-control-lg"
                                    placeholder="Enter RN Number">
                            </div>

                            <button type="submit" id="submitBtn" class="btn btn-success btn-lg w-100">
                                Verify Payment
                            </button>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if ($showModal): ?>
        <div class="modal fade" id="bonusModal" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content rounded-4 shadow">
                    <div class="modal-header bg-success text-white">
                        <h5 class="modal-title">🎁 Bonus Offer</h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-center fs-5"><?= $modalMessage ?></div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary w-100" data-bs-dismiss="modal">Got it!</button>
                    </div>
                </div>
            </div>
        </div>




        <script>
            document.addEventListener('DOMContentLoaded', () => {
                var bonusModal = new bootstrap.Modal(document.getElementById('bonusModal'));
                bonusModal.show();
            });
        </script>
    <?php endif; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function showLoading() {
            const btn = document.getElementById('submitBtn');
            btn.disabled = true;
            btn.innerText = 'Processing...';
            return true;
        }




        function copyText() {
            const text = document.getElementById("ezNumberText").value;
            navigator.clipboard.writeText(text).then(() => {
                // set message
                document.getElementById('copyModalBody').innerText = "Ez Number copied: " + text;
                // show modal
                var myModal = new bootstrap.Modal(document.getElementById('copyModal'));
                myModal.show();
            });
        }
    </script>
    <!-- Copy Success Modal - Always Present -->
    <div class="modal fade" id="copyModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content rounded-4 shadow">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title"> Copied Success !</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body fs-5" id="copyModalBody">
                    <!-- Message set dynamically -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary w-100" data-bs-dismiss="modal">OK</button>
                </div>
            </div>
        </div>
    </div>

    <?php include '../public/include/whatsapp.php'; ?>
    <?php include '../public/include/footer.php'; ?>
</body>

</html>