<?php
// Build full referral URL
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$domain = $_SERVER['HTTP_HOST'];

$urls = [
    $protocol . $domain . "/api/order_status",
    $protocol . $domain . "/api/sarvice_chak",
    $protocol . $domain . "/public/cron/provider_price_update"
];

// Initialize multi handle
$mh = curl_multi_init();
$handles = [];

// ஒவ்வொரு URL-க்கும் cURL handle உருவாக்கு
foreach ($urls as $url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_multi_add_handle($mh, $ch);
    $handles[] = $ch;
}

// Execute all queries simultaneously
$running = null;
do {
    curl_multi_exec($mh, $running);
    curl_multi_select($mh);
} while ($running > 0);

// Results
foreach ($handles as $ch) {
    $content = curl_multi_getcontent($ch);
    // Output பார்க்க
    echo "<pre>" . htmlspecialchars($content) . "</pre>";
    curl_multi_remove_handle($mh, $ch);
}

curl_multi_close($mh);
