<?php
require('config/db.php');
include 'public/session.php'; // Check login session
include 'public/include/titlemg.php';
include 'public/include/email_verify.php';

// sesen datas
$user_id = $_SESSION['id'];
$username = $_SESSION['name'];

// order get limit
$limit = 50;

// order page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) {
    $page = 1;
}

// Fetch all orders
$status = $_GET['status'] ?? 'all';

// allowed statuses
$allowed_statuses = ['pending', 'canceled', 'processing', 'inprogress', 'partial', 'completed'];


// offset calculation

// offset nda nammo edukkure vrise padi rcod a skip pannum ez : oosert 100 da 100 rcod skip pannum
$offset = ($page - 1) * $limit;

// மொத்த rows count
$count_query = "SELECT COUNT(*) as total FROM orders WHERE username = '$username'";

$count_result = mysqli_query($connect, $count_query);
$count_row = mysqli_fetch_assoc($count_result);
$total_records = $count_row['total'];

// மொத்த pages எவ்வளவு?
$total_pages = ceil($total_records / $limit);


// get order status joing consept

if ($status === 'all') {

    // ✅ எல்லா status-க்கும் join
    $query = "SELECT orders.*, services.refill_button 
              FROM orders 
              LEFT JOIN services ON orders.service_id = services.id 
              WHERE orders.username = '$username' 
              ORDER BY orders.id DESC 
              LIMIT $limit OFFSET $offset";
} else {
    $status = strtolower($status);
    if (in_array($status, $allowed_statuses)) {


        //  status filter பண்ணி join
        // ஆனால் pending க்கு கூட failed + initiated சேர்க்கணும்னா:
        if ($status === 'pending') {
            $query = "SELECT orders.*, services.refill_button 
                      FROM orders
                      LEFT JOIN services ON orders.service_id = services.id
                      WHERE orders.username = '$username'
                      AND (orders.status = 'pending' OR orders.status = 'failed' OR orders.status = 'initiated')
                      ORDER BY orders.id DESC
                      LIMIT $limit OFFSET $offset";
        }

        // ✅ status filter பண்ணி join
        else {
            $query = "SELECT orders.*, services.refill_button 
                  FROM orders
                  LEFT JOIN services ON orders.service_id = services.id
                  WHERE orders.username = '$username'
                  AND orders.status = '$status'
                  ORDER BY orders.id DESC
                  LIMIT $limit OFFSET $offset";
        }
    } else {
        // ✅ invalid status வந்தா join தான்
        $query = "SELECT orders.*, services.refill_button 
                  FROM orders
                  LEFT JOIN services ON orders.service_id = services.id
                  WHERE orders.username = '$username'
                  ORDER BY orders.id DESC
                  LIMIT $limit OFFSET $offset";
    }
}


$result = mysqli_query($connect, $query);

?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">


<title>Order History | <?= htmlspecialchars($sitename) ?> | Track Your Social Media Orders</title>

<meta name="description" content="View your completed, pending, and active social media marketing orders on <?= htmlspecialchars($sitename) ?>. Track Instagram, TikTok, YouTube, and Facebook service progress easily.">
<meta name="keywords" content="order history, track orders, smm panel sri lanka, social media orders, instagram followers, tiktok likes, youtube views, facebook orders, rootsmm, rootmasterlk">

<meta name="robots" content="noindex, follow">
<meta name="author" content="<?= htmlspecialchars($sitename) ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Open Graph / Facebook / Instagram -->
<meta property="og:title" content="Order History | <?= htmlspecialchars($sitename) ?>">
<meta property="og:description" content="Check your past and current social media orders on <?= htmlspecialchars($sitename) ?>. Track Instagram, TikTok, and YouTube progress in real time.">
<meta property="og:type" content="website">
<meta property="og:url" content="https://rootmasterlk.store/orders">
<meta property="og:image" content="<?= htmlspecialchars($site_image) ?>">
<meta property="og:site_name" content="<?= htmlspecialchars($sitename) ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Order History | <?= htmlspecialchars($sitename) ?>">
<meta name="twitter:description" content="Track your SMM panel order history for Instagram, TikTok, YouTube, and more on <?= htmlspecialchars($sitename) ?>.">
<meta name="twitter:image" content="<?= htmlspecialchars($site_image) ?>">

<!-- Canonical -->
<link rel="canonical" href="https://rootmasterlk.store/orders">

<!-- JSON-LD Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "name": "Order History - <?= htmlspecialchars($sitename) ?>",
  "url": "https://rootmasterlk.store/orders",
  "description": "View and manage your previous and current SMM orders for Instagram, TikTok, YouTube, and Facebook on <?= htmlspecialchars($sitename) ?>.",
  "publisher": {
    "@type": "Organization",
    "name": "<?= htmlspecialchars($sitename) ?>",
    "logo": "<?= htmlspecialchars($site_image) ?>"
  }
}
</script>



    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>



  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      background: #f5f4fa;
      font-family: "Poppins", sans-serif;
    }

    .header-text {
      text-align: center;
      margin-top: 30px;
      margin-bottom: 20px;
      font-weight: bold;
      color: #4a00e0;
    }

    .order-card {
      background: #fff;
      color: #333;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
      transition: 0.3s;
      border: none;
    }

    .order-card:hover {
      transform: translateY(-4px);
      box-shadow: 0 6px 15px rgba(0, 0, 0, 0.15);
    }

    .card-title {
      font-size: 1.1rem;
      color: #4a00e0;
    }

    .badge {
      font-size: 0.85rem;
    }

    .search-box input {
      border-radius: 30px;
      padding: 10px 20px;
      box-shadow: 0 0 6px rgba(0, 0, 0, 0.1);
    }

    .filter-buttons .btn {
      border-radius: 30px;
      font-weight: 500;
      transition: 0.2s;
    }

    .filter-buttons .btn.active,
    .filter-buttons .btn:hover {
      background: linear-gradient(90deg, #6c63ff, #3f3fff);
      color: white !important;
      border: none;
    }

    .pagination .page-item.active .page-link {
      background-color: #6c63ff;
      border-color: #6c63ff;
      color: white;
    }

    @media (max-width: 576px) {
      .card-body {
        font-size: 14px;
      }

      .search-box input {
        width: 100% !important;
      }
    }
  </style>
</head>

<body>

  <?php include 'public/include/header.php'; ?>

  <div class="container mt-4">
    

    <!-- 🔍 Search -->
    <div class="search-box text-center mb-4 mt-5">
      <input type="text" id="searchInput" class="form-control w-50 mx-auto"
        placeholder=" Search by Link, ID, or Status...">
    </div>

    <!-- 🧭 Filter Buttons -->
    <div class="filter-buttons text-center mb-4 ">
      <div class="d-flex flex-wrap justify-content-center gap-2">
        <a href="?status=pending" class="btn btn-outline-warning <?= $status === 'pending' ? 'active' : '' ?>">
          <i class="bi bi-hourglass-split me-1"></i> Pending
        </a>
        <a href="?status=processing" class="btn btn-outline-primary <?= $status === 'processing' ? 'active' : '' ?>">
          <i class="bi bi-arrow-repeat me-1"></i> Processing
        </a>
        <a href="?status=partial" class="btn btn-outline-info <?= $status === 'partial' ? 'active' : '' ?>">
          <i class="bi bi-puzzle-fill me-1"></i> Partial
        </a>
        <a href="?status=completed" class="btn btn-outline-success <?= $status === 'completed' ? 'active' : '' ?>">
          <i class="bi bi-check-circle-fill me-1"></i> Completed
        </a>
        <a href="?status=canceled" class="btn btn-outline-danger <?= $status === 'canceled' ? 'active' : '' ?>">
          <i class="bi bi-x-circle-fill me-1"></i> Canceled
        </a>
        <a href="?status=all" class="btn btn-outline-secondary <?= $status === 'all' ? 'active' : '' ?>">
          <i class="bi bi-list-check me-1"></i> All Orders
        </a>
      </div>
    </div>

    <!-- 🧾 Order Cards -->
    <div class="row g-4">
      <?php if (mysqli_num_rows($result) > 0): ?>
        <?php while ($order = mysqli_fetch_assoc($result)): ?>
          <div class="col-md-6 col-lg-4">
            <div class="card order-card p-3 h-100">
              <div class="card-body">

                <h5 class="card-title">
                  <i class="bi bi-hash me-1 text-secondary"></i> Order #<?= htmlspecialchars($order['id']); ?>
                </h5>

                <p><i class="bi bi-link-45deg text-primary"></i> <strong>Link:</strong>
                  <?= htmlspecialchars($order['link']); ?></p>
                <p><i class="bi bi-diagram-3-fill text-success"></i> <strong>Service:</strong>
                  <?= htmlspecialchars($order['sarvice_name']); ?> (ID <?= htmlspecialchars($order['service_id']); ?>)
                </p>
                <p><i class="bi bi-123 text-info"></i> <strong>Quantity:</strong>
                  <?= htmlspecialchars($order['quantity']); ?></p>
                  
                  
                  
                  
   <p>
    <i class="bi bi-cash-coin text-danger"></i> 
    <strong>Amount:</strong>

    

       <?= $currency_symbol ?> ~ 
<span class="amount-value">
    <?= number_format(convertFromtoLKR($order['price'], $user_currency), 6) ?>
</span>


   
</p>

                  
                  
                  
                  
                  
                  
                <p><i class="bi bi-calendar3 text-warning"></i> <strong>Date:</strong>
                  <?= date("d-m-Y h:i A", strtotime($order['created_at'] ?? 'now')); ?></p>

                <div class="d-flex justify-content-between mt-3">
                  <span class="badge bg-primary"><i class="bi bi-graph-up me-1"></i>
                    Start: <?= htmlspecialchars($order['start_count'] ?? '-'); ?></span>
                  <span class="badge bg-warning text-dark"><i class="bi bi-hourglass me-1"></i>
                    Remains: <?= htmlspecialchars($order['remains'] ?? '-'); ?></span>
                </div>

                <?php
                $status_row = strtolower($order['status'] ?? 'pending');
                $badge_class = "bg-secondary";
                switch ($status_row) {
                  case 'pending':
                    $badge_class = "bg-warning text-dark";
                    break;
                  case 'processing':
                  case 'progress':
                    $badge_class = "bg-primary";
                    break;
                  case 'completed':
                    $badge_class = "bg-success";
                    break;
                  case 'canceled':
                    $badge_class = "bg-danger";
                    break;
                  case 'partial':
                    $badge_class = "bg-info text-dark";
                    break;
                }
                ?>
                <div class="mt-3">
                  <span class="fw-bold me-2">Status:</span>
                  <span class="badge <?= $badge_class ?> px-3 py-2 rounded-pill">
                    <i class="bi bi-circle-fill me-1"></i> <?= ucfirst($status_row); ?>
                  </span>
                </div>

                <?php if ($order['refill_button'] === '1' && strtolower($order['status']) !== 'canceled'): ?>
                  <a href="api/refill.php?api_order_id=<?= urlencode($order['api_order_id']); ?>"
                    class="btn btn-outline-success mt-3 w-100">
                    <i class="bi bi-arrow-clockwise me-1"></i> Refill
                  </a>
                <?php endif; ?>

              </div>
            </div>
          </div>
        <?php endwhile; ?>
      <?php else: ?>
        <div class="alert alert-warning text-center fw-bold">No orders found.</div>
      <?php endif; ?>
    </div>

    <!-- 📄 Pagination -->
    <?php if ($total_pages > 1): ?>
      <nav class="mt-4">
        <ul class="pagination justify-content-center">
          <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
            <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
              <a class="page-link" href="?status=<?= urlencode($status) ?>&page=<?= $i ?>"><?= $i ?></a>
            </li>
          <?php endfor; ?>

          <?php if ($end_page < $total_pages): ?>
            <li class="page-item">
              <a class="page-link" href="?status=<?= urlencode($status) ?>&page=<?= $total_pages ?>">
                Last &raquo;
              </a>
            </li>
          <?php endif; ?>
        </ul>
      </nav>
    <?php endif; ?>
  </div>

  <?php include 'public/include/footer.php'; ?>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    // 🔍 Search filter
    document.getElementById('searchInput').addEventListener('input', function() {
      const filter = this.value.toLowerCase();
      document.querySelectorAll('.order-card').forEach(card => {
        card.parentElement.style.display = card.innerText.toLowerCase().includes(filter) ? '' : 'none';
      });
    });
  </script>

</body>
</html>
