<?php
include 'config/db.php';
include 'public/session.php';
include 'public/include/titlemg.php';
include 'public/include/email_verify.php';
$userid = $_SESSION['id'];

// Fetch current user data
$query = $connect->query("SELECT * FROM users2 WHERE id = " . $userid);
$user = $query->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $email    = $_POST['email'];
    $password = $_POST['password'];
    $currency_type = $_POST['currency_type'];


    // Check if username/email already exists for another user
    $check = $connect->prepare("SELECT id FROM users2 WHERE (username = ? OR email = ?) AND id != ?");
    $check->bind_param("ssi", $username, $email, $userid);
    $check->execute();
    $check->store_result();

    $msg = "";
    $alert_class = "";

    if ($check->num_rows > 0) {
        $msg = "Username or Email already taken!";
        $alert_class = "danger"; // red
    } else {
        // If password is entered, hash it and update
        if (!empty($password)) {
            $password = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $connect->prepare("UPDATE users2 SET username=?, email=?, password=? WHERE id=?");
            $stmt->bind_param("sssi", $username, $email, $password, $userid);
        } else {
            // If password is not entered, only update username and email
            $stmt = $connect->prepare("UPDATE users2 SET username=?, email=?,currency_type=? WHERE id=?");
            $stmt->bind_param("sssi", $username, $email,$currency_type, $userid); // Corrected binding here
        }

        if ($stmt->execute()) {
            $msg = "Updated successfully!";
            $alert_class = "success"; // green
        } else {
            $msg = "Update failed!";
            $alert_class = "danger"; // red
        }

        // Refresh user data
        $query = $connect->query("SELECT * FROM users2 WHERE id = $userid");
        $user = $query->fetch_assoc();
    }
}

// Generate API Key if button is clicked
if (isset($_POST['generate_api'])) {
    function generateApiKey($length = 32)
    {
        return bin2hex(random_bytes($length / 2));
    }

    $newApiKey = generateApiKey();
    $stmt = $connect->prepare("UPDATE users2 SET api_key = ? WHERE id = ?");
    $stmt->bind_param("si", $newApiKey, $userid);

    if ($stmt->execute()) {
        $msg = "New API Key generated successfully!";
        $alert_class = "success";
        // Refresh user data
        $query = $connect->query("SELECT * FROM users2 WHERE id = $userid");
        $user = $query->fetch_assoc();
    } else {
        $msg = "Failed to generate API Key.";
        $alert_class = "danger";
    }
}
// Build full API URL
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$domain = $_SERVER['HTTP_HOST'];
$api_link = $protocol . $domain . "/api/v2";

$allcurrencies = $connect->query("SELECT currency_code FROM currency_rates ORDER BY currency_code ASC");


?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>My Account | <?= htmlspecialchars($sitename ?? 'Dashboard') ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">





<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>



    <!-- Bootstrap + Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            background: #f5f4fa;
            font-family: 'Poppins', sans-serif;
        }

        .account-card {
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            transition: 0.3s;
        }

        .account-card:hover {
            transform: translateY(-3px);
        }

        .account-header {
            background: linear-gradient(135deg, #6c63ff, #3f3fff);
            color: #fff;
            padding: 20px;
            border-radius: 15px 15px 0 0;
        }

        .account-header h4 {
            margin: 0;
            font-weight: 700;
        }

        label {
            font-weight: 500;
        }

        .form-control {
            border-radius: 10px;
        }

        .btn-success {
            border-radius: 30px;
            font-weight: 600;
            background: linear-gradient(135deg, #3f3fff, #6c63ff);
            border: none;
        }

        .btn-success:hover {
            opacity: 0.9;
        }

        .btn-outline-primary {
            border-radius: 10px;
        }

        .input-group .btn-secondary {
            background-color: #6c63ff;
            border: none;
            border-radius: 10px;
        }

        .input-group .btn-secondary:hover {
            background-color: #5a52f0;
        }

        #copyStatus,
        #copyStatusKey {
            font-size: 0.85rem;
        }

        @media (max-width: 576px) {
            .account-card {
                margin: 10px;
            }
        }
    </style>
</head>

<body>
    <?php include 'public/include/header.php'; ?>

    <div class="container mt-5 mb-5">
        <div class="row justify-content-center">
            <div class="col-md-7 col-lg-6">
                <div class="account-card">
                    <div class="account-header d-flex justify-content-between align-items-center">
                        <h4><i class="bi bi-person-circle me-2"></i>My Account</h4>
                        <span class="badge bg-light text-dark"><?= htmlspecialchars($user['username']) ?></span>
                    </div>

                    <div class="card-body p-4">
                        <?php if (!empty($msg)): ?>
                            <div class="alert alert-<?= $alert_class ?> text-center fw-semibold"><?= $msg ?></div>
                        <?php endif; ?>

                        <form method="POST">
                            <div class="mb-3">
                                <label><i class="bi bi-person-fill me-1 text-primary"></i> Username</label>
                                <input type="text" name="username" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" readonly>
                            </div>

                            <div class="mb-3">
                                <label><i class="bi bi-envelope-fill me-1 text-danger"></i> Email</label>
                                <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($user['email']) ?>" readonly>
                            </div>

                            <div class="mb-3">
                                <label><i class="bi bi-lock-fill me-1 text-warning"></i> New Password (optional)</label>
                                <input type="password" name="password" class="form-control" placeholder="Enter new password">
                            </div>
                            
  <div class="mb-3">
    <label><i class="bi bi-currency-exchange me-1 text-success"></i> Currency</label>

    <select id="profile_currency" name="currency_type" class="currency-select">

        <?php while ($cr = $allcurrencies->fetch_assoc()): ?>
            <option value="<?= $cr['currency_code'] ?>"
                data-icon="https://flagcdn.com/24x18/<?= strtolower(substr($cr['currency_code'],0,2)) ?>.png"
                <?= $user['currency_type'] == $cr['currency_code'] ? 'selected' : '' ?>>
                <?= $cr['currency_code'] ?>
            </option>
        <?php endwhile; ?>

    </select>
</div>




                            <div class="mb-3">
                                <label><i class="bi bi-key-fill me-1 text-success"></i> API Key</label>
                                <div class="input-group">
                                    <input type="text" id="apiKeyInput" class="form-control" value="<?= htmlspecialchars($user['api_key']) ?>" readonly>
                                    <button type="submit" name="generate_api" class="btn btn-secondary">
                                        <i class="bi bi-arrow-clockwise"></i>
                                    </button>
                                    <button class="btn btn-outline-primary" type="button" onclick="copyApiKey()">Copy</button>
                                </div>
                                <small id="copyStatusKey" class="text-success" style="display:none;">Copied Successfully!</small>
                            </div>

                            <div class="mb-3">
                                <label><i class="bi bi-globe2 me-1 text-info"></i> API URL</label>
                                <div class="input-group">
                                    <input type="text" id="apiUrlInput" class="form-control" value="<?= htmlspecialchars($api_link) ?>" readonly>
                                    <button class="btn btn-outline-primary" type="button" onclick="copyApiUrl()">Copy</button>
                                </div>
                                <small id="copyStatus" class="text-success" style="display:none;">Copied Successfully!</small>
                            </div>

                            <button type="submit" class="btn btn-success w-100 mt-4">
                                <i class="bi bi-check-circle-fill me-1"></i> Update Details
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ✅ Copy Functions -->
    <script>
        function copyApiUrl() {
            const input = document.getElementById("apiUrlInput");
            const status = document.getElementById("copyStatus");
            input.select();
            input.setSelectionRange(0, 99999);
            document.execCommand("copy");
            status.style.display = "inline";
            setTimeout(() => status.style.display = "none", 2000);
        }

        function copyApiKey() {
            const input = document.getElementById("apiKeyInput");
            const status = document.getElementById("copyStatusKey");
            input.select();
            input.setSelectionRange(0, 99999);
            document.execCommand("copy");
            status.style.display = "inline";
            setTimeout(() => status.style.display = "none", 2000);
        }
    </script>
    
<script>
$(document).ready(function () {

    function formatCurrency(option) {
        if (!option.id) return option.text;
        let icon = $(option.element).data("icon");

        return $(`
            <span style="display:flex;align-items:center;">
                <img src="${icon}" style="width:20px; margin-right:8px;">
                ${option.text}
            </span>
        `);
    }

    $('#profile_currency').select2({
        width: '100%',
        placeholder: "Select currency",
        allowClear: false,
        minimumResultsForSearch: 0,  // search enabled
        templateResult: formatCurrency,
        templateSelection: formatCurrency
    });

});
</script>



    <?php include 'public/include/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>