<?php
header('Content-Type: application/json');


$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ||
    $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$host = $_SERVER['HTTP_HOST'];
$domain = $protocol . $host; // 👈 subfolder சேர்க்கவே வேண்டாம்




// Allow only POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["error" => "Method Not Allowed"]);
    exit;
}

// api input check
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!$data || !is_array($data)) {
    if (!empty($_POST)) {
        $data = $_POST;
    } else {
        echo json_encode(["error" => "No valid input"]);
        exit;
    }
}

// api insertv valu get here
$app    = $data['app'] ?? '';
$sender = $data['sender'] ?? 'Dear User';
$message = trim($data['message'] ?? '');
$group  = $data['group_name'] ?? '';
$phone  = $data['phone'] ?? '';

if ($app === '' || $sender === '' || $message === '') {
    echo json_encode(["error" => "Missing fields"]);
    exit;
}



// custome message 

$lowerMsg = strtolower(trim($message));
if (in_array($lowerMsg, ['hi', 'bro', 'hello', 'epdi use panre', 'brow', 'help', 'hlw'])) {
    $reply =
        "👋 *Hello $sender, I'm Order bot*\n\n" .

        "❓ *Please send the message in one of these formats:*\n" .
        "1️⃣ *Balance Check:* *apikey*\n" .
        "2️⃣ *Price Check:* *apikey|service_id|price*\n" .
        "3️⃣ *Order Status:* *apikey|orderid*\n" .
        "4️⃣ *Place Order:* *apikey|service|link|qty*\n\n" .
        "📌 *Example:* *123456|45|https://example.com|100*\n\n";



    echo json_encode(["reply" => $reply]);
    exit;
}


//  split message
$parts = explode("|", $message);

//  Balance check
if (count($parts) == 1) {
    $apiKey = trim($parts[0]);
    $balance = checkBalance("$domain/api/v2", $apiKey);

    if (isset($balance['balance'])) {
        $lkrBalance = $balance['balance'];

        echo json_encode(["reply" => "*💰 Balance: LKR $lkrBalance*"]);
        exit;
    } else {
        $reply =
            "❌ *Error: Invalid API Key!*\n\n" .                       // bold
            "⚠️ _Please enter a valid API key to continue._\n\n" .     // italic
            "📌 *Example format:*\n" .
            "`1234567890abcdef`\n\n" .                                 // code style
            "🔑 *Get your API key from your account:*\n" .
            "*$domain/my_account*\n\n";

        echo json_encode(["reply" => $reply]);
        exit;
    }
}

// 👉 Price check: apikey|service_id|price
if (count($parts) == 3 && strtolower(trim($parts[2])) == 'price') {
    [$apiKey, $serviceId] = [$parts[0], $parts[1]];
    $services = getServices("$domain/api/v2", $apiKey);

    // Balance get
    $balanceData = checkBalance("$domain/api/v2", $apiKey);
    if (isset($balanceData['balance'])) {
        $lkrBalance = $balanceData['balance'];
    } else {
        $lkrBalance = 0;
    }

    if (!is_array($services) || isset($services['error'])) {
        echo json_encode(["reply" => "*❌ Invalid API Key*"]);
        exit;
    }

    foreach ($services as $service) {
        if ($service['service'] == $serviceId) {
            $rateLkr = $service['rate'];

            $min = $service['min'];
            $max = $service['max'];
            $reply = "💸 *Service:* {$service['name']}\n\n" .
                "💰 *Price:* (LKR {$rateLkr}) per 1000\n\n" .
                "🔢 *Min:* $min\n\n" .
                "🔢 *Max:* $max\n\n" .
                "💵 *Your Balance:* LKR {$lkrBalance}";
            echo json_encode(["reply" => $reply]);
            exit;
        }
    }
    echo json_encode(["reply" => "*❌ Service not found*"]);
    exit;
}

// 👉 Order status: apikey|orderid
if (count($parts) == 2) {
    [$apiKey, $orderId] = $parts;
    $status = checkOrderStatus("$domain/api/v2", $apiKey, $orderId);
    if (isset($status['status'])) {
        $chargeLkr = $status['charge'] ?? 0;



        $reply = "📦 Order $orderId Status: {$status['status']}\n💵 Charge: LKR $chargeLkr";
        echo json_encode(["reply" => $reply]);
        exit;
    }
}

// 👉 Normal order: apikey|service|link|qty
if (count($parts) == 4) {
    [$apiKey, $serviceId, $link, $qty] = $parts;
    $resp = placeOrder("$domain/api/v2", $apiKey, $serviceId, $link, $qty);


    if (isset($resp['order'])) {

        // Balance get
        $balanceData = checkBalance("$domain/api/v2", $apiKey);

        if (isset($balanceData['balance'])) {
            $lkrBalance = $balanceData['balance'];
        }

        $reply =
            "✅ *Order Placed!*\n\n" .
            "📦 *Order ID:* _{$resp['order']}_\n" .
            "💵 *Balance:* LKR {$lkrBalance}\n\n" .
            "ℹ️ *Check your order status with this format:*\n" .
            "*_{$apiKey}|{$resp['order']}_*";
        echo json_encode(["reply" => $reply]);
        exit;
    } else {
        echo json_encode(["reply" => "*❌ Order Failed _reason: {$resp['error']}_*"]);
        exit;
    }
}

// 👉 default fallback
$reply =
    "❌ *Invalid Format!*\n\n" .
    "❓ *Please send the message in one of these formats:*\n" .
    "1️⃣ *Balance Check:* `apikey`\n" .
    "2️⃣ *Price Check:* `apikey|service_id|price`\n" .
    "3️⃣ *Order Status:* `apikey|orderid`\n" .
    "4️⃣ *Place Order:* `apikey|service|link|qty`\n\n" .
    "📌 *Example:* `123456|45|https://example.com|100`";


echo json_encode(["reply" => $reply]);




// ------------- Functions -------------

// api order palce smm
function curlPost($url, $data)
{
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

// blance cheak
function checkBalance($url, $key)
{
    return curlPost($url, ['key' => $key, 'action' => 'balance']);
}

// servuice get
function getServices($url, $key)
{
    return curlPost($url, ['key' => $key, 'action' => 'services']);
}

// order status cheak
function checkOrderStatus($url, $key, $orderId)
{
    return curlPost($url, ['key' => $key, 'action' => 'status', 'order' => $orderId]);
}

// place order
function placeOrder($url, $key, $service, $link, $qty)
{
    return curlPost($url, [
        'key' => $key,
        'action' => 'add',
        'service' => $service,
        'link' => $link,
        'quantity' => $qty
    ]);
}

