<?php
include '../config/db.php'; // Database connection

// api class
include 'api_class.php';

header('Content-Type: application/json');

$action = $_POST['action'] ?? '';
$key = $_POST['key'] ?? '';

// Check action and API key
if (!$action || !$key) {
    echo json_encode(['error' => 'Action and API key required']);
    exit;
}

// ✅ Validate API key from users2 table
$stmt = $connect->prepare("SELECT * FROM users2 WHERE api_key = ?");
$stmt->bind_param("s", $key);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

if (!$user) {
    echo json_encode(['error' => 'Invalid API key']);
    exit;
}


// Step 1: get commission percentage from users2
$user_id = $user['id'];

$com_query = $connect->prepare("SELECT comisen_parsentag FROM users2 WHERE id = ?");
$com_query->bind_param("i", $user_id);
$com_query->execute();
$com_result = $com_query->get_result();
$commission = 0;

if ($row = $com_result->fetch_assoc()) {
    $commission = floatval($row['comisen_parsentag']);
}

// ✅ Action Switch
switch ($action) {

    // 🔹 Get Services
    // 🔹 Get Services
    case 'services':
        $user_id = $user['id'];

        $query = "
        SELECT 
            s.id, 
            s.service_name, 
            s.description, 
            s.refill_button, 
            COALESCE(cq.min_quantity, s.min_quantity) AS min, 
            COALESCE(cq.max_quantity, s.max_quantity) AS max, 
            IF(cp.costome_price IS NOT NULL, cp.costome_price, s.price) AS price, 
            c.category_name
        FROM services s
        LEFT JOIN category c ON s.category_id = c.id
        LEFT JOIN custom_prices cp ON cp.service_id = s.id AND cp.user_id = ?
        LEFT JOIN custom_quantity cq ON cq.service_id = s.id AND cq.user_id = ?
        WHERE s.status = 'active'
        AND s.category_id NOT IN (
            SELECT category_id FROM hide_category WHERE user_id = ?
        )
    ";

        $stmt = $connect->prepare($query);
        $stmt->bind_param("iii", $user_id, $user_id, $user_id); // for cp, cq, hide_category
        $stmt->execute();
        $result = $stmt->get_result();

        $data = [];

        while ($row = $result->fetch_assoc()) {

            $original_price = floatval($row['price']);
            $final_price = $original_price - ($original_price * $commission / 100);


            $data[] = [
                'service' => $row['id'],
                'name' => $row['service_name'],
                'rate' => round($final_price, 2),
                'desc' => $row['description'],
                'refill' => $row['refill_button'],
                'min' => intval($row['min']),
                'max' => intval($row['max']),
                'category' => $row['category_name'],
                'type' => 'Default'
            ];
        }

        echo json_encode($data);
        break;





    // 🔹 Check Balance
    case 'balance':
        echo json_encode([
            'balance' => floatval($user['balance']),
            'currency' => 'LKR'
        ]);
        break;



    // Add Order

    case 'add':
        $service = $_POST['service'] ?? null;
        $link = $_POST['link'] ?? null;
        $quantity = intval($_POST['quantity'] ?? 0);
        $user_id = $user['id'] ?? null;
        $username = $user['username'] ?? null;

        //  Comments handle
        $comments = isset($_POST['comments']) ? trim($_POST['comments']) : "";
        $using_comments = !empty($comments);


        if ($using_comments) {
            // split comments by new lines and count
            $comment_lines = array_filter(array_map('trim', explode("\n", $comments)));
            $comments = implode("\n", $comment_lines);
            $quantity = count($comment_lines);
            if ($quantity <= 0) {
                echo json_encode(['error' => ' Please enter valid comments']);
                exit;
            }
        } else {
            // normal quantity
            $quantity = intval($_POST['quantity'] ?? 0);
            if ($quantity <= 0) {
                echo json_encode(['error' => ' Invalid quantity']);
                exit;
            }
        }


        // normel prameters check
        if (!$service || !$link || $quantity <= 0 || !$user_id || !$username) {
            echo json_encode(['error' => 'Missing or invalid parameters']);
            exit;
        }

        //  Get service min max custome price get
        $query = "
        SELECT 
            s.id AS service_id,
            s.api_order_id,
            s.provider_id,
            s.service_name,
            COALESCE(cq.min_quantity, s.min_quantity) AS min,
            COALESCE(cq.max_quantity, s.max_quantity) AS max,
            IF(cp.costome_price IS NOT NULL, cp.costome_price, s.price) AS price
        FROM services s
        LEFT JOIN custom_prices cp ON cp.service_id = s.id AND cp.user_id = ?
        LEFT JOIN custom_quantity cq ON cq.service_id = s.id AND cq.user_id = ?
        WHERE s.status = 'active'
          AND s.id = ?
          AND s.category_id NOT IN (
              SELECT category_id FROM hide_category WHERE user_id = ?
          )
    ";

        $stmt = $connect->prepare($query);
        if (!$stmt) {
            echo json_encode(['error' => 'Prepare failed: ' . $connect->error]);
            exit;
        }

        $stmt->bind_param("iiii", $user_id, $user_id, $service, $user_id);
        if (!$stmt->execute()) {
            echo json_encode(['error' => 'Execute failed: ' . $stmt->error]);
            exit;
        }

        $result = $stmt->get_result();
        $sdata = $result->fetch_assoc();

        if (!$sdata) {
            echo json_encode(['error' => 'Invalid service or service hidden']);
            exit;
        }

        if ($quantity < $sdata['min'] || $quantity > $sdata['max']) {
            echo json_encode(['error' => "Quantity must be between {$sdata['min']} and {$sdata['max']}"]);
            exit;
        }

        $original_price = floatval($sdata['price']);

        $final_price = $original_price - ($original_price * $commission / 100);

        // Now apply price per 1000 logic
        $price = ($final_price / 1000) * $quantity;



        if ($user['balance'] < $price) {
            echo json_encode(['error' => 'Insufficient balance']);
            exit;
        }

        $new_balance = $user['balance'] - $price;
        $update_balance_stmt = $connect->prepare("UPDATE users2 SET balance = ? WHERE id = ?");
        if (!$update_balance_stmt) {
            echo json_encode(['error' => 'Prepare failed (balance update): ' . $connect->error]);
            exit;
        }

        $update_balance_stmt->bind_param("di", $new_balance, $user_id);
        $update_balance_stmt->execute();

        $order_unique_id = uniqid(); // unique id உருவாக்கல்

        $insert_order_stmt = $connect->prepare("INSERT INTO orders (username, service_id, quantity, link, price, status, sarvice_name, api_order_id) VALUES (?, ?, ?, ?, ?, 'initiated', ?, ?)");
        if (!$insert_order_stmt) {
            echo json_encode(['error' => 'Prepare failed (order insert): ' . $connect->error]);
            exit;
        }

        $insert_order_stmt->bind_param("siisdss", $username, $sdata['service_id'], $quantity, $link, $price, $sdata['service_name'], $order_unique_id);
        if (!$insert_order_stmt->execute()) {
            echo json_encode(['error' => 'Execute failed (order insert): ' . $insert_order_stmt->error]);
            exit;
        }

        $order_db_id = $connect->insert_id;

        $output = array(
            "order" => $order_db_id,       // API order ID
            "start_count" => "0",          // (Optional) started count
            "charge" => $price,            // (Optional) deducted amount
            "currency" => "LKR",           // (Optional) currency
            "status" => "Pending"
        );

        echo json_encode($output);



        // class Api
        // {
        //     public $api_url;
        //     public $api_key;

        //     public function order($data)
        //     {
        //         $post = array_merge(['key' => $this->api_key, 'action' => 'add'], $data);
        //         return json_decode($this->connect($post));
        //     }

        //     private function connect($post)
        //     {
        //         $ch = curl_init($this->api_url);
        //         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        //         curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
        //         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        //         $result = curl_exec($ch);
        //         curl_close($ch);
        //         return $result;
        //     }
        // }


        //main  🌐 Step 2: API Call
        $sdata['provider_id'];

        $setting_q = mysqli_query($connect, "SELECT api_key, api_url FROM providers WHERE id = {$sdata['provider_id']} LIMIT 1");
        $setting = mysqli_fetch_assoc($setting_q);
        $api_key = $setting['api_key'];
        $api_url = $setting['api_url'];

        // $api = new Api();
        // $api->api_key = $api_key;
        // $api->api_url = $api_url;

        $api = new Api($api_key, $api_url);

        $data = [
            'service' => $sdata['api_order_id'],
            'link' => $link,
            'quantity' => $quantity
        ];
        if ($using_comments) {
            $data['comments'] = $comments;
        }

        $api_response = $api->order($data);

        // ✅ Step 3: Check API Response
        if (isset($api_response->order) && is_numeric($api_response->order)) {
            $api_order_id = $api_response->order;

            // 👉 JSON encode the full response to save in DB
            $full_response = mysqli_real_escape_string($connect, json_encode($api_response));

            // ✅ Update DB with api_order_id, status, and api_response
            mysqli_query($connect, "
        UPDATE orders 
        SET api_order_id='$api_order_id', status='pending', api_response='$full_response' 
        WHERE id=$order_db_id
    ");

            // 💰 Deduct balance (if you add here later)

        } else {
            // 👉 API failed, also store the failed response for debugging
            $failed_response = mysqli_real_escape_string($connect, json_encode($api_response));

            // ❌ Update status and store failed response
            mysqli_query($connect, "
        UPDATE orders 
        SET status='failed', api_response='$failed_response' 
        WHERE id=$order_db_id
    ");
        }

        exit;
        break;



    // 🔹 Get Order Status
    case 'status':
        $order_id = $_POST['order'] ?? null;

        if (!$order_id) {
            echo json_encode(['error' => 'Missing order id']);
            exit;
        }

        $stmt = $connect->prepare("SELECT * FROM orders WHERE id = ?");
        $stmt->bind_param("s", $order_id);
        $stmt->execute();
        $order = $stmt->get_result()->fetch_assoc();

        if (!$order) {
            echo json_encode(['error' => 'Order not found']);
            exit;
        }

        echo json_encode([
            'status' => $order['status'],
            'charge' => floatval($order['price']),
            'start_count' => intval($order['start_count']),
            'remains' => intval($order['remains']),
        ]);
        break;

        // 🔸 If API fail or api_order_id empty
        echo json_encode([
            'status' => $order['status'],
            'charge' => floatval($order['price']),
            'start_count' => intval($order['start_count']),
            'remains' => intval($order['remains']),
        ]);
        break;



    // 🔹 Invalid Action
    default:
        echo json_encode(['error' => 'Invalid action']);
        break;
}
