<?php

include '../config/db.php';

// smm api class
include 'api_class.php';
include '../public/function/currency.php';


// ✅ Get relevant orders
$sql = "SELECT * FROM orders 
        WHERE api_order_id IS NOT NULL 
        AND (status IN ('pending', 'processing', 'inprogress') OR status IS NULL)";
$result = $connect->query($sql);

while ($row = $result->fetch_assoc()) {
    $order_db_id = $row['id'];
    $api_order_id = $row['api_order_id'];
    $username = $row['username'];
    $price = floatval($row['price']);
    $service_id = $row['service_id'];

    // ✅ Step 1: Get provider_id from services
    $service_q = mysqli_query($connect, "SELECT provider_id FROM services WHERE id = $service_id");
    $service = mysqli_fetch_assoc($service_q);
    if (!$service || !$service['provider_id']) {
        continue; // Skip if no provider
    }

    $provider_id = $service['provider_id'];

    // ✅ Step 2: Get api_key and api_url from providers
    $provider_q = mysqli_query($connect, "SELECT api_key, api_url , cransi_type FROM providers WHERE id = $provider_id");
    $provider = mysqli_fetch_assoc($provider_q);
    if (!$provider) {
        continue; // Skip if no API details
    }

    $api_key = $provider['api_key'];
    $api_url = $provider['api_url'];

    // ✅ Step 3: API call
    $api = new Api($api_key, $api_url);
    $status_data = $api->status($api_order_id);

    $status = $status_data->status ?? 'pending';
    $start_count = isset($status_data->start_count) ? intval($status_data->start_count) : NULL;
    $remains = isset($status_data->remains) ? intval($status_data->remains) : NULL;
    $api_charge_raw = isset($status_data->charge) ? floatval($status_data->charge) : 0;



    $provider_currency = $provider['cransi_type'];

    $conversion_rate = getConversionRate($provider_currency);


    $api_charge_lkr = round($api_charge_raw * $conversion_rate, 2);


    if ($status === "Canceled") {
        // ✅ Refund to user
        $uq = mysqli_query($connect, "SELECT balance FROM users2 WHERE username='$username'");
        $user = mysqli_fetch_assoc($uq);
        $new_balance = $user['balance'] + $price;

        mysqli_query($connect, "UPDATE users2 SET balance=$new_balance WHERE username='$username'");

        $action = 'refund';
        $today = date('Y-m-d');

        $insertHistory = "INSERT INTO balance_history (username, date, amount, action) VALUES (?, ?, ?, ?)";
        $stmt = mysqli_prepare($connect, $insertHistory);
        mysqli_stmt_bind_param($stmt, "ssds", $username, $today, $price, $action);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);

        mysqli_query($connect, "UPDATE orders SET status='canceled', start_count=$start_count, remains=$remains, api_charge=$api_charge_lkr, price=0 WHERE id=$order_db_id");
    } else {
        // ✅ Normal status update
        $stmt = $connect->prepare("UPDATE orders SET status = ?, start_count = ?, remains = ?, api_charge = ? WHERE id = ?");
        $stmt->bind_param("sidsi", $status, $start_count, $remains, $api_charge_lkr, $order_db_id);
        $stmt->execute();
    }
}

header("Location: ../admin/all_orders");
exit;
