<?php
require('../config/db.php'); // Database connection
include 'session.php';
$query = "SELECT * FROM users2";
$result = mysqli_query($connect, $query);

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Digital Products</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href=".//style.css">
</head>
<?php include 'include/header.php'; ?>

<body class="bg-light">


    <div class="container mt-4">
        <div class="card shadow-lg p-3 bg-white rounded">

            <div class="table-responsive">
                <input type="text" id="searchInput" class="form-control mb-3" placeholder="🔍 Search by Name or Number">

                <table class="table table-bordered table-striped text-center" id="userBalanceTable">
                    <thead class="table-dark">
                        <tr>
                            <th>#</th>
                            <th>User Email</th>
                            <th>User Name</th>
                            <th>Blance</th>
                            <th>Comisen</th>
                            <th>Status</th>
                            <th>Action</th>


                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo htmlspecialchars($row['email']); ?></td>
                                <td><?php echo htmlspecialchars($row['username']); ?></td>
                                <td><?php echo htmlspecialchars($row['balance']); ?></td>
                                <td><?php echo htmlspecialchars($row['comisen_parsentag']); ?>%</td>
                                <td>
                                    <?php if ($row['status'] == 1): ?>
                                        <span class="badge bg-success">Approved</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Unapproved</span>
                                    <?php endif; ?>
                                </td>





                                <td>
                                    <div class="d-grid gap-2">
                                        <a href="userseaditform?id=<?php echo $row['id']; ?>" class="btn btn-primary btn-sm">Edit</a>
                                    </div>

                                    <!-- New API Key button -->
                                    <button class=" mt-1 btn btn-warning btn-sm update-api-key-btn"
                                        data-id="<?php echo $row['id']; ?>">
                                        🔑 Update API Key
                                    </button>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <!-- Success Modal api key show coppy  -->
    <div class="modal fade" id="successModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title" id="successModalLabel">✅ API Key Updated</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <p class="mb-2">Here is the new API Key:</p>
                    <div class="input-group mb-3">
                        <input type="text" class="form-control" id="apiKeyField" readonly>
                        <button class="btn btn-outline-primary" type="button" id="copyBtn">📋 Copy</button>
                    </div>
                    <small class="text-muted">Click copy to copy the API Key.</small>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>


    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <script>
        // Search function

        $(document).ready(function() {
            // Search function
            $('#searchInput').on('input', function() {
                var value = $(this).val().toLowerCase();
                $("#userBalanceTable tbody tr").filter(function() {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
                });
            });
        });
    </script>



    <script>
        // api key update model show script
        $(document).ready(function() {
            $('.update-api-key-btn').on('click', function() {
                var userId = $(this).data('id');

                $.ajax({
                    url: 'more/update_api_key.php',
                    type: 'POST',
                    data: {
                        id: userId
                    },
                    success: function(response) {
                        var res = {};
                        try {
                            res = JSON.parse(response);
                        } catch (e) {}

                        if (res.status === 'success') {
                            // Set value in input field
                            $('#apiKeyField').val(res.api_key);

                            // Show modal
                            var modal = new bootstrap.Modal(document.getElementById('successModal'));
                            modal.show();
                        } else {
                            alert('Error: ' + (res.message || 'Unknown error'));
                        }
                    },
                    error: function() {
                        alert('AJAX error!');
                    }
                });
            });

            // Copy button
            $('#copyBtn').on('click', function() {
                var copyText = document.getElementById('apiKeyField');
                copyText.select();
                copyText.setSelectionRange(0, 99999); // mobile support
                navigator.clipboard.writeText(copyText.value).then(function() {
                    // optional feedback
                    alert('API Key Copied: ' + copyText.value);
                });
            });
        });
    </script>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>