<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Register</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #2a2a72, #009ffd);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .register-container {
            width: 100%;
            max-width: 400px;
            background: #fff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0px 5px 20px rgba(0, 0, 0, 0.2);
            animation: fadeIn 0.6s ease-in-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .form-control {
            border-radius: 8px;
            font-size: 1rem;
            padding: 12px;
        }
        .btn-custom {
            background: #28a745;
            border: none;
            padding: 12px;
            font-size: 1rem;
            border-radius: 8px;
            transition: 0.3s;
        }
        .btn-custom:hover {
            background: #218838;
            transform: scale(1.05);
        }
        @media (max-width: 576px) {
            .register-container {
                padding: 20px;
            }
            .form-control {
                font-size: 0.9rem;
                padding: 10px;
            }
            .btn-custom {
                font-size: 0.9rem;
                padding: 10px;
            }
        }
    </style>
</head>

<?php
require("../config/db.php");
session_start();

if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST['submit'])) {
    $userName = $_POST['name'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    $emailCheckQuery = "SELECT * FROM admin WHERE email = ?";
    $stmt = mysqli_prepare($connect, $emailCheckQuery);
    mysqli_stmt_bind_param($stmt, "s", $email);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if (mysqli_num_rows($result) > 0) {
        $_SESSION['error'] = "The email address is already registered. Please use a different email.";
        header("Location: crate_admin");
        exit();
    }

    $sql = "INSERT INTO admin (name, email, password) VALUES (?, ?, ?)";
    $stmt = mysqli_prepare($connect, $sql);
    mysqli_stmt_bind_param($stmt, "sss", $userName, $email, $password);

    if (mysqli_stmt_execute($stmt)) {
        $_SESSION['success'] = "New admin created successfully";
        header("Location: login");
        exit();
    } else {
        $_SESSION['error'] = "Registration failed. Please try again. Error: " . mysqli_error($connect);
        header("Location: crate_admin");
        exit();
    }

    mysqli_stmt_close($stmt);
    mysqli_close($connect);
}
?>

<body>
    <div class="register-container">
        <h3 class="text-center fw-bold text-primary">Admin Register</h3>

        <form method="post">
            <?php
            if(isset($_SESSION['success'])) {
                echo '<div class="alert alert-success" role="alert">'.$_SESSION["success"].'</div>'; 
                unset($_SESSION["success"]);
            } elseif(isset($_SESSION['error'])) {
                echo '<div class="alert alert-danger" role="alert">'.$_SESSION["error"].'</div>'; 
                unset($_SESSION["error"]);
            }
            ?>
            <div class="mb-3">
                <label class="form-label text-dark">Name</label>
                <input type="text" class="form-control" placeholder="Enter your name" name="name" required>
            </div>
            <div class="mb-3">
                <label class="form-label text-dark">Email</label>
                <input type="email" class="form-control" placeholder="Enter your email" name="email" required>
            </div>
            <div class="mb-3">
                <label class="form-label text-dark">Password</label>
                <input type="password" class="form-control" placeholder="Enter your password" name="password" required>
            </div>
            <button type="submit" class="btn btn-custom w-100 fw-bold" name="submit">Register</button>
        </form>
        <p class="text-center mt-3 fw-bold">
            <a href="#">Forgot password?</a> | <a href="adminlogin.php">Login</a>
        </p>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
