<?php
// db
include '../../config/db.php';

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $type = $_POST['type'];
    $percent = floatval($_POST['percent']);
    $ids = $_POST['ids'] ?? ''; // May be empty

    // Validate input
    if ($percent <= 0 || !in_array($type, ['increase', 'decrease'])) {
        die("Invalid input.");
    }

    // Prepare the SQL query

    if (!empty($ids)) {
        // Apply only for selected services
        $idArray = array_map('intval', explode(",", $ids));
        $idList = implode(",", $idArray);
        $whereClause = "WHERE id IN ($idList)";
    } else {
        // Apply for all services
        $whereClause = "";
    }

    // Execute the query 
    // insrease ? if : else decrease
    $query = $type === 'increase'
      ? "UPDATE services SET price = price + (price * $percent / 100) $whereClause"
      : "UPDATE services SET price = price - (price * $percent / 100) $whereClause";

    if ($connect->query($query) === TRUE) {
        echo "Prices updated successfully.";
    } else {
        echo "Error updating prices: " . $connect->error;
    }
} else {
    echo "Invalid request.";
}
?>
