<?php
// db
include '../../config/db.php';

// session
include '../session.php';

// step 1: get all used category_ids from services


if (isset($_POST['cleanup'])) {
    $used_categories = [];

    // get all catcry id from services
    $result = mysqli_query($connect, "SELECT DISTINCT category_id FROM services");
    while ($row = mysqli_fetch_assoc($result)) {
        $used_categories[] = $row['category_id'];
    }

    // step 2: delete all categories that are NOT in used list
    // service tablele ulle id ye mattum vittu matte ellam dlt pannum 
    if (!empty($used_categories)) {
        // build comma-separated ids
        $ids = implode(',', array_map('intval', $used_categories));
        $delete_sql = "DELETE FROM category WHERE id NOT IN ($ids)";
        mysqli_query($connect, $delete_sql);

        $_SESSION['success'] = "All unused categories have been deleted.";
        header("Location: ../category");
        exit;
    } else {
        // no services at all → delete all categories
        mysqli_query($connect, "DELETE FROM category");

        $_SESSION['success'] = "All categories have been deleted.";
        header("Location: ../category");
        exit;
    }
}

$_SESSION['error'] = " Something went wrong.";
header("Location: ../category");
exit();
