<?php
include '../../config/db.php'; // DB connection
include '../session.php'; // Session check

header('Content-Type: application/json');

// SQL query - services table-ல் இல்லாத service_id கொண்ட orders delete
$sql = "DELETE FROM orders 
        WHERE service_id NOT IN (SELECT id FROM services)";


// 1 Delete balance_history 30 days முன்
$dateThreshold = date('Y-m-d', strtotime('-30 days'));
$sqlBalance = "DELETE FROM balance_history WHERE date < ?";
if ($stmt = $connect->prepare($sqlBalance)) {
    $stmt->bind_param('s', $dateThreshold);
    $stmt->execute();
    $deletedBalance = $stmt->affected_rows;
    $stmt->close();
    $response['balance_deleted'] = $deletedBalance;
} else {
    $response['balance_error'] = $connect->error;
}

// 2
$sqlPayment = "DELETE FROM payment_request WHERE created_at < ?";
if ($stmt = $connect->prepare($sqlPayment)) {
    $stmt->bind_param('s', $dateThreshold);
    $stmt->execute();
    $deletedPayment = $stmt->affected_rows;
    $stmt->close();
    $response['payment_deleted'] = $deletedPayment;
} else {
    $response['payment_error'] = $connect->error;
}


// 3
if ($stmt = $connect->prepare($sql)) {
    $stmt->execute();
    $deletedCount = $stmt->affected_rows;
    $stmt->close();

    echo json_encode([
        'status' => 'success',
        'deleted' => $deletedCount
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => $connect->error
    ]);
}
