<?php

require("../config/db.php");
session_start();

if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST['submit'])) {

    $email = $_POST['email'];
    $password = $_POST['password'];

    // Cookie-based fail counter read 
    $fail_count = isset($_COOKIE['admin_login_fail_count']) ? intval($_COOKIE['admin_login_fail_count']) : 0;
    $fail_time = isset($_COOKIE['admin_login_fail_time']) ? intval($_COOKIE['admin_login_fail_time']) : 0;
    $current_time = time();
    $block_duration = 600; // 10 நிமிடம் in seconds

    if ($fail_count >= 3 && ($current_time - $fail_time) < $block_duration) {
        $remaining_seconds = $block_duration - ($current_time - $fail_time);
        $remaining_minutes = ceil($remaining_seconds / 60);

        $_SESSION['error'] = "❌ You have exceeded 3 failed login attempts. Please try again after $remaining_minutes minute(s).";
    } else {
        $sql = "SELECT id, name, password FROM admin WHERE email=?";
        $stmt = mysqli_prepare($connect, $sql);
        mysqli_stmt_bind_param($stmt, "s", $email);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_store_result($stmt);

        if (mysqli_stmt_num_rows($stmt) > 0) {
            mysqli_stmt_bind_result($stmt, $id, $username, $hashed_password);
            mysqli_stmt_fetch($stmt);

            if (password_verify($password, $hashed_password)) {
                // Login success: fail counter cookie-ஐ delete பண்ணு
                setcookie('admin_login_fail_count', '', time() - 3600);
                setcookie('admin_login_fail_time', '', time() - 3600);

                $_SESSION['id_admin'] = $id;
                $_SESSION['name_admin'] = $username;


                // 🔒 Set cookie to remember for 30 days
                setcookie("id_admin", $id, time() + (30 * 24 * 60 * 60), "/");
                setcookie("name_admin", $username, time() + (30 * 24 * 60 * 60), "/");

                header("Location: dashboard");
                exit;
            } else {
                // Password தவறு: fail count 1 ஆகும், 10 நிமிட காலாவதி
                $fail_count++;
                setcookie('admin_login_fail_count', $fail_count, time() + 600);
                if ($fail_count == 1) {
                    setcookie('admin_login_fail_time', time(), time() + 600);
                }
                $_SESSION['error'] = "Invalid email or password only available 3 times and $fail_count times failed ";
            }
        } else {
            // Email இல்லாததால் fail count அதிகரிக்கவும்
            $fail_count++;
            setcookie('admin_login_fail_count', $fail_count, time() + 600);
            if ($fail_count == 1) {
                setcookie('admin_login_fail_time', time(), time() + 600);
            }
            $_SESSION['error'] = "Invalid email or password only available 3 times and $fail_count times failed";
        }

        mysqli_stmt_close($stmt);
    }

    mysqli_close($connect);
}

// Session இல்லைனா, Cookies இருக்கா-nu Check பண்ணுறது
if (!isset($_SESSION['id_admin'])) {
    if (isset($_COOKIE['id_admin']) && isset($_COOKIE['name_admin'])) {
        // Cookies இருந்தா, session set பண்ணுறது
        $_SESSION['id_admin'] = $_COOKIE['id_admin'];
        $_SESSION['name_admin'] = $_COOKIE['name_admin'];
    }
}


if (isset($_SESSION['id_admin'])) {
    header("Location: dashboard");
    exit();
}
?>








<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Admin Login</title>
    <link
        href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
        rel="stylesheet" />
</head>

<body class="bg-white d-flex align-items-center vh-100">

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-sm-8 col-md-6 col-lg-4">

                <div class="card shadow-sm">
                    <div class="card-body p-4">
                        <h3 class="card-title text-center mb-4 text-primary fw-bold">Admin Login</h3>


                        <form method="post" novalidate>
                            <?php

                            if (isset($_SESSION['success'])) {
                                echo '<div class="alert alert-success">' . htmlspecialchars($_SESSION["success"]) . '</div>';
                                unset($_SESSION["success"]);
                            } elseif (isset($_SESSION['error'])) {
                                echo '<div class="alert alert-danger">' . htmlspecialchars($_SESSION["error"]) . '</div>';
                                unset($_SESSION["error"]);
                            }
                            ?>

                            <div class="mb-3">
                                <label for="email" class="form-label">Email address</label>
                                <input
                                    type="email"
                                    class="form-control"
                                    id="email"
                                    name="email"
                                    placeholder="Enter your email"
                                    required
                                    autofocus />
                            </div>

                            <div class="mb-4">
                                <label for="password" class="form-label">Password</label>
                                <input
                                    type="password"
                                    class="form-control"
                                    id="password"
                                    name="password"
                                    placeholder="Enter your password"
                                    required />
                            </div>

                            <button type="submit" name="submit" class="btn btn-primary w-100 fw-semibold">
                                Login
                            </button>
                        </form>

                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>