<?php include 'session.php'; ?>
<?php include '../config/db.php';


?>

<?php

// redarty dasbord
if (!isset($_SESSION['dashboard']) || $_SESSION['dashboard'] != "25") {
  // Session இருந்தால் அழிக்கவும்
  if (isset($_SESSION['dashboard'])) {
    unset($_SESSION['dashboard']);
  }
  header("Location: dashboard");  // redirect செய்யும் பக்கம்
  exit();
}
?>


<?php
// Handle insert/update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = $_POST['id'] ?? '';
  $category_id  = $_POST['category_id'];
  $service_name = $_POST['service_name'];
  $price = $_POST['price'];
  $description = $_POST['description'];
  $status = $_POST['status'];
  $api_order_id = $_POST['api_order_id'];
  $min_quantity = $_POST['min_quantity'];
  $max_quantity = $_POST['max_quantity'];
  $refill_button = $_POST['refill_button'];

  $provider_id = $_POST['provider_id'] ?? null;

  if ($id) {
    $stmt = $connect->prepare("UPDATE services SET category_id=?, service_name=?, price=?, description=?, status=?, api_order_id=?, min_quantity=?, max_quantity=?, refill_button=?, provider_id=? WHERE id=?");
    $stmt->bind_param("isdssiiiisi", $category_id, $service_name, $price, $description, $status, $api_order_id, $min_quantity, $max_quantity, $refill_button, $provider_id, $id);
    $stmt->execute();
    $message = "Service Updated!";
  } else {
    $stmt = $connect->prepare("INSERT INTO services (category_id, service_name, price, description, status, api_order_id, min_quantity, max_quantity, refill_button, provider_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isdssiiisi", $category_id, $service_name, $price, $description, $status, $api_order_id, $min_quantity, $max_quantity, $refill_button, $provider_id);
    $stmt->execute();
    $message = "Service Added!";
  }
  header("Location: index?msg=" . urlencode($message));
  exit();
}

// Fetch all services
$services = $connect->query("
  SELECT services.*, category.category_name, providers.provider_name, providers.api_url
  FROM services
  JOIN category ON services.category_id = category.id
  LEFT JOIN providers ON services.provider_id = providers.id
  ORDER BY 
    
    CAST(category.in_order AS UNSIGNED) ASC,
    services.id DESC
");


// Fetch all categories
$categories = $connect->query("SELECT * FROM category ORDER BY order_id ASC");

// Fetch all providers
$providers = $connect->query("SELECT id, provider_name, api_url FROM providers ORDER BY provider_name ASC");


// order service by category
$services_by_category = [];
while ($row = $services->fetch_assoc()) {
  $cat = $row['category_name'] ?: 'Uncategorized';
  if (!isset($services_by_category[$cat])) {
    $services_by_category[$cat] = [];
  }
  $services_by_category[$cat][] = $row;
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title>Service Manager</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- tabl styl -->
  <style>
    .desc-limit {
      max-width: 200px;
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: nowrap;
    }

    @media (max-width: 768px) {
      .desc-limit {
        max-width: 100px;
      }
    }
  </style>

  <!-- trosted link -->

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

  <!-- trosted end -->



  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Bootstrap Icons CSS -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

</head>




<body class="bg-light">

  <!-- toastr alerts -->
  <?php if (isset($_SESSION['success'])): ?>
    <script>
      document.addEventListener('DOMContentLoaded', function() {
        toastr.success("<?= addslashes($_SESSION['success']); ?>", "Success", {
          closeButton: true,
          progressBar: true,
          positionClass: "toast-top-right",
          timeOut: 3000,
        });
      });
    </script>
    <?php unset($_SESSION['success']); ?>
  <?php endif; ?>

  <?php if (isset($_SESSION['error'])): ?>
    <script>
      document.addEventListener('DOMContentLoaded', function() {
        toastr.error("<?= addslashes($_SESSION['error']); ?>", "Error", {
          closeButton: true,
          progressBar: true,
          positionClass: "toast-top-right",
          timeOut: 3000,
        });
      });
    </script>
    <?php unset($_SESSION['error']); ?>
  <?php endif; ?>

  <?php if (isset($_SESSION['info'])): ?>
    <script>
      document.addEventListener('DOMContentLoaded', function() {
        toastr.info("<?= addslashes($_SESSION['info']); ?>", "Info", {
          closeButton: true,
          progressBar: true,
          positionClass: "toast-top-right",
          timeOut: 3000,
        });
      });
    </script>
    <?php unset($_SESSION['info']); ?>
  <?php endif; ?>
  <!-- toastr end -->


  <?php include 'include/header.php'; ?>

  <div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <h4 class="fw-bold">Services</h4>
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#serviceModal" onclick="clearForm()">+ Add Service</button>
    </div>

    <!-- Success Message -->
    <?php if (isset($_GET['msg'])): ?>
      <div class="alert alert-success text-center"><?= htmlspecialchars($_GET['msg']) ?></div>
    <?php endif; ?>


    <!-- Responsive Increase/Decrease Section -->
    <div class="row g-3 align-items-end mb-3">
      <div class="col-12 col-md-4 col-lg-3">
        <label for="percentInput" class="form-label fw-bold">Enter Percentage:</label>
        <input type="number" class="form-control" id="percentInput" placeholder="Eg: 10" step="0.01" min="0">
      </div>

      <div class="col-12 col-md-8 col-lg-6 d-flex flex-wrap gap-2">
        <button class="btn btn-success flex-fill" id="increaseBtn">Increase % in DB</button>
        <button class="btn btn-danger flex-fill" id="decreaseBtn">Decrease % in DB</button>
      </div>
    </div>
    <!-- Responsive Increase/Decrease Section -->




    <div class="table-responsive">
      <input type="text" id="searchInput" class="form-control mb-3" placeholder="🔍 Search by Name or Number">





      <!-- Button trigger modal -->
      <button type="button" class="btn btn-primary rounded-pill px-4 fw-bold mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalCenter">
        <i class="bi bi-sliders2-vertical me-2"></i> More Controls
      </button>

      <!-- Modal -->
      <div class="modal fade" id="exampleModalCenter" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content rounded-4 shadow">
            <div class="modal-header bg-primary text-white">
              <h5 class="modal-title" id="exampleModalCenterTitle">
                <i class="bi bi-tools me-2"></i> Advanced Actions
              </h5>
              <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center p-4">

              <form method="post" action="more/cleanup_inactive.php" onsubmit="return confirmDelete()">
                <button type="submit" name="cleanup_inactive_services" class="btn btn-danger btn-lg px-4 rounded-pill">
                  <i class="bi bi-trash-fill me-2"></i> Delete All Inactive Services
                </button>
              </form>
            </div>
            <div class="modal-footer justify-content-center">
              <button type="button" class="btn btn-outline-secondary rounded-pill" data-bs-dismiss="modal">
                <i class="bi bi-x-circle me-2"></i> Close
              </button>
            </div>
          </div>
        </div>
      </div>








      <!-- from slect -->
      <form method="POST" action="more/delete_selected_services.php" onsubmit="return confirm('Are you sure to delete selected services?')">

        <!-- from slect dlt btn -->
        <div class="mb-2">
          <button type="submit" class="btn btn-danger btn-sm">🗑️ Delete Selected</button>
        </div>

        <!-- fesrts hed -->
        <table class="table table-bordered table-hover align-middle" id="userBalanceTable">
          <thead class="table-dark text-center">
            <tr>
              <th><input type="checkbox" id="selectAll"> Select All</th>
              <th>Catagory Name</th>
            </tr>
          </thead>


          <tbody>



            <!-- catacry all show -->
            <?php foreach ($services_by_category as $category_name => $services): ?>


              <!-- color change  ctacry php code -->
              <?php
              // default
              $category_color = 'table-primary';

              // loop through services
              foreach ($services as $row) {
                $price = (float)$row['price'];
                $provider_price = (float)$row['provider_price'];

                // status 
                $status = $row['status'];

                if ($status === "inactive") {
                  // wornig
                  $category_color = 'table-warning';
                  break;
                }


                if ($price < $provider_price) {
                  // 🔴 priority red
                  $category_color = 'table-danger';
                  break;
                } elseif ($price == $provider_price) {
                  // 🟡 warning
                  $category_color = 'table-warning';
                  // 👉 priority warning? break if you want
                  break;
                } elseif ($price > $provider_price) {
                  // 🟢 green (only if no warning/danger already)
                  if ($category_color !== 'table-danger') {
                    $category_color = 'table-success';
                  }
                }
              }
              ?>


              <tr class="<?= $category_color ?> category-header <?= $color ?>" style="cursor:pointer;"
                data-bs-toggle="collapse" data-bs-target="#cat-<?= md5($category_name) ?>"
                aria-expanded="false" aria-controls="cat-<?= md5($category_name) ?>">
                <td colspan="12" class="fw-bold">
                  <?= htmlspecialchars($category_name) ?> <span class="float-end">▼</span>
                </td>
              </tr>

              <!-- servic row show  inclode ctacrys-->
              <tr>
                <td colspan="12" class="p-0">
                  <div class="collapse" id="cat-<?= md5($category_name) ?>">
                    <table class="table table-bordered table-hover mb-0">
                      <thead class="table-light text-center">
                        <tr>
                          <th>
                            <input type="checkbox" id="selectAllSub_<?= md5($category_name) ?>" class="selectAllSub" data-target="cat-<?= md5($category_name) ?>">
                          </th>
                          <th>#</th>
                          <th>Service Name</th>
                          <th>Price</th>
                          <th>Description</th>
                          <th>Status</th>
                          <th>API Order ID</th>
                          <th>Min Qty</th>
                          <th>Max Qty</th>
                          <th>Provider</th>
                          <th>Refill</th>
                          <th>Action</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php $sub_i = 1;
                        foreach ($services as $row): ?>
                          <tr>
                            <td class="text-center"><input type="checkbox" name="selected_ids[]" value="<?= $row['id'] ?>"></td>
                            <td class="text-center"><?= $sub_i++ ?></td>
                            <td><?= htmlspecialchars($row['service_name']) ?></td>
                            <?php
                            $price = (float)$row['price'];
                            $provider_price = (float)$row['provider_price'];
                            $color = 'text-success';
                            if ($price < $provider_price) $color = 'text-danger';
                            elseif ($price == $provider_price) $color = 'text-secondary';
                            ?>
                            <td class="text-end">
                              <span class="<?= $color ?>"><?= htmlspecialchars($row['price']) ?></span><br>
                              <small class="text-muted">Provider Price: <?= htmlspecialchars($row['provider_price']) ?></small>
                            </td>
                            <td class="text-truncate desc-limit" title="<?= htmlspecialchars($row['description']) ?>">
                              <?= htmlspecialchars($row['description']) ?>
                            </td>
                            <td class="text-center">
                              <span class="badge bg-<?= $row['status'] == 'active' ? 'success' : 'secondary' ?>">
                                <?= ucfirst($row['status']) ?>
                              </span>
                            </td>
                            <td class="text-center"><?= htmlspecialchars($row['api_order_id']) ?></td>
                            <td class="text-center">
                              <?= htmlspecialchars($row['min_quantity']) ?><br>
                              <small class="text-muted">Provider Min: <?= htmlspecialchars($row['provider_min']) ?></small>
                            </td>
                            <td class="text-center">
                              <?= htmlspecialchars($row['max_quantity']) ?><br>
                              <small class="text-muted">Provider Max: <?= htmlspecialchars($row['provider_max']) ?></small>
                            </td>

                            <td>
                              <strong><?= htmlspecialchars($row['provider_name']) ?></strong><br>
                              <small class="text-muted"><?= htmlspecialchars($row['api_url']) ?></small>
                            </td>
                            <td class="text-center">
                              <span class="badge bg-<?= $row['refill_button'] == '1' ? 'success' : 'danger' ?>">
                                <?= $row['refill_button'] == '1' ? 'On' : 'Off' ?>
                              </span>
                            </td>
                            <td class="text-center">
                              <button type="button" class="btn btn-sm btn-warning mb-1" data-bs-toggle="modal" data-bs-target="#serviceModal"
                                onclick='editService(<?= htmlspecialchars(json_encode($row), ENT_QUOTES, "UTF-8") ?>)'>
                                ✏️ Edit
                              </button>
                              <br>
                              <a href="delete_service.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger"
                                onclick="return confirm('Are you sure you want to delete this service?')">
                                🗑️ Delete
                              </a>
                            </td>
                          </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>

        </table>

      </form>
    </div>
  </div>

  <!-- Modal service add and edit -->
  <div class="modal fade" id="serviceModal" tabindex="-1">
    <div class="modal-dialog">
      <form class="modal-content" method="POST">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title">Service Form</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="service_id">
          <div class="mb-3">
            <label>Category</label>
            <select name="category_id" id="category_id" class="form-select" required>
              <option value="">-- Select Category --</option>
              <?php while ($cat = $categories->fetch_assoc()): ?>
                <option value="<?= htmlspecialchars($cat['id']) ?>">
                  <?= htmlspecialchars($cat['category_name']) ?>
                </option>
              <?php endwhile; ?>
            </select>
          </div>

          <div class="mb-3">
            <label>Service Name</label>
            <input type="text" name="service_name" id="service_name" class="form-control" required>
          </div>
          <div class="mb-3">
            <label>Price</label>
            <input type="number" step="0.01" name="price" id="price" class="form-control" required>
          </div>
          <div class="mb-3">
            <label>Description</label>
            <textarea name="description" id="description" class="form-control"></textarea>
          </div>

          <div class="mb-3">
            <label>Api order id</label>
            <input type="number" name="api_order_id" id="api_order_id" class="form-control" required>
          </div>

          <div class="mb-3">
            <label>Min Quantity</label>
            <input type="number" name="min_quantity" id="min_quantity" class="form-control" required>
          </div>

          <div class="mb-3">
            <label>Max Quantity</label>
            <input type="number" name="max_quantity" id="max_quantity" class="form-control" required>
          </div>

          <div class="mb-3">
            <label>Status</label>
            <select name="status" id="status" class="form-select">
              <option value="active">Active</option>
              <option value="inactive">Inactive</option>
            </select>
          </div>

          <div class="mb-3">
            <label>Provider</label>
            <select name="provider_id" id="provider_id" class="form-select" required>
              <option value="">-- Select Provider --</option>
              <?php while ($provider = $providers->fetch_assoc()): ?>
                <option value="<?= htmlspecialchars($provider['id']) ?>">
                  <?= htmlspecialchars($provider['provider_name']) ?> - <?= htmlspecialchars($provider['api_url']) ?>
                </option>
              <?php endwhile; ?>
            </select>
          </div>



          <div class="mb-3">
            <label>Refill Button</label>
            <select name="refill_button" id="refill_button" class="form-select">
              <option value="0">Off</option>
              <option value="1">On</option>

            </select>
          </div>


        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success w-100">Save</button>
        </div>
      </form>
    </div>
  </div>

  <!-- Custom Alert Modal -->
  <div class="modal fade" id="customAlertModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content border-warning">
        <div class="modal-header bg-warning text-dark">
          <h5 class="modal-title">Warning</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body" id="customAlertBody">
          <!-- Message will appear here -->
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-warning" data-bs-dismiss="modal">OK</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Confirm Modal price update -->
  <div class="modal fade" id="confirmModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content border-primary">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title">Please Confirm</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body" id="confirmModalBody">Are you sure?</div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" id="cancelBtn" data-bs-dismiss="modal">No</button>
          <button type="button" class="btn btn-primary" id="yesBtn">Yes</button>
        </div>
      </div>
    </div>
  </div>


  <script>
    // Checkbox Select All
    document.getElementById('selectAll').onclick = function() {
      const checkboxes = document.querySelectorAll('input[name="selected_ids[]"]');
      for (let checkbox of checkboxes) {
        checkbox.checked = this.checked;
      }


      // ealla ctacryde boxseum tik pannu
      const subSelects = document.querySelectorAll('.selectAllSub');
      for (let sub of subSelects) {
        sub.checked = this.checked;
      }
    };
  </script>



  <script>
    function editService(data) {
      document.getElementById('service_id').value = data.id;
      document.getElementById('category_id').value = data.category_id;
      document.getElementById('service_name').value = data.service_name;
      document.getElementById('price').value = data.price;
      document.getElementById('description').value = data.description;
      document.getElementById('status').value = data.status;
      document.getElementById('api_order_id').value = data.api_order_id;
      document.getElementById('min_quantity').value = data.min_quantity;
      document.getElementById('max_quantity').value = data.max_quantity;
      document.getElementById('refill_button').value = data.refill_button;
      document.getElementById('provider_id').value = data.provider_id;

    }

    function clearForm() {
      document.getElementById('service_id').value = '';
      document.getElementById('category_id').value = '';
      document.getElementById('service_name').value = '';
      document.getElementById('price').value = '';
      document.getElementById('description').value = '';
      document.getElementById('status').value = 'active';
      document.getElementById('api_order_id').value = '';
      document.getElementById('min_quantity').value = '';
      document.getElementById('max_quantity').value = '';
      document.getElementById('refill_button').value = '0';
      document.getElementById('provider_id').value = '';

    }
  </script>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
      $('#searchInput').on('input', function() {
        var value = $(this).val().toLowerCase();

        // ஒவ்வொரு category group process பண்ணு
        $("div.collapse[id^='cat-']").each(function() {
          var $collapseDiv = $(this);
          var $tbody = $collapseDiv.find("tbody");
          var anyVisible = false;

          // ஒவ்வொரு service row-ம் filter பண்ணு
          $tbody.find("tr").each(function() {
            var text = $(this).text().toLowerCase();
            var show = text.indexOf(value) > -1;
            $(this).toggle(show);
            if (show) anyVisible = true;
          });

          // அந்த categoryக்கு header கண்டுபிடிக்க
          var $categoryHeader = $collapseDiv.closest("tr").prev(".category-header");

          if (anyVisible) {
            $collapseDiv.addClass("show"); // auto open
            $categoryHeader.show();
          } else {
            $collapseDiv.removeClass("show");

            $categoryHeader.hide();
          }
        });
      });
    });
  </script>



  <script>
    // Search filter (search across visible service rows)
    document.getElementById("#searchInput").addEventListener("input", function() {
      const searchValue = this.value.toLowerCase();

      // For each category group, check if any service matches the search
      document.querySelectorAll("tbody[id^='cat-']").forEach(tbody => {
        let anyVisible = false;
        tbody.querySelectorAll(".service-row").forEach(row => {
          const text = row.textContent.toLowerCase();
          const show = text.includes(searchValue);
          row.style.display = show ? "" : "none";
          if (show) anyVisible = true;
        });

        // Show or hide category header based on if any service visible
        const categoryHeader = tbody.previousElementSibling;
        if (anyVisible) {
          tbody.classList.add("show"); // bootstrap collapse show
          categoryHeader.style.display = "";
        } else {
          tbody.classList.remove("show");
          categoryHeader.style.display = "none";
        }
      });
    });
  </script>


  <script>
    // price updatev %
    async function updatePrice(type) {
      const percent = parseFloat(document.getElementById('percentInput').value) || 0;

      function showModalAlert(message) {
        document.getElementById('customAlertBody').textContent = message;
        const alertModal = new bootstrap.Modal(document.getElementById('customAlertModal'));
        alertModal.show();
      }

      if (percent <= 0) {
        showModalAlert("Please enter a valid percentage.");
        return;
      }


      // Selected checkboxes
      const selectedCheckboxes = document.querySelectorAll('input[name="selected_ids[]"]:checked');
      const selected = [...selectedCheckboxes].map(cb => cb.value);

      // alrt mess slct no slct

      function showCustomAlert(message) {
        document.getElementById('customAlertBody').textContent = message;
        const alertModal = new bootstrap.Modal(document.getElementById('customAlertModal'));
        alertModal.show();
      }



      let msg = selected.length > 0 ?
        `Are you sure you want to ${type} prices by ${percent}% for selected services?` :
        `No service selected. Are you sure you want to ${type} prices by ${percent}% for ALL services?`;

      const confirmed = await showConfirmModal(msg);
      if (!confirmed) return;

      const formData = new URLSearchParams();
      formData.append("type", type);
      formData.append("percent", percent);

      // slct id set 
      if (selected.length > 0) {
        formData.append("ids", selected.join(","));
      }

      // Send request to update prices
      fetch("more/update_price.php", {
          method: "POST",
          headers: {
            "Content-Type": "application/x-www-form-urlencoded"
          },
          body: formData.toString()
        })
        .then(res => res.text())
        .then(data => {
          alert(data);
          location.reload();
        })
        .catch(err => {
          console.error("Error:", err);
          alert("Something went wrong.");
        });
    }

    document.getElementById('increaseBtn').addEventListener('click', () => updatePrice('increase'));
    document.getElementById('decreaseBtn').addEventListener('click', () => updatePrice('decrease'));


    // confirm modal open script
    function showConfirmModal(message) {
      return new Promise((resolve) => {
        document.getElementById('confirmModalBody').textContent = message;

        const confirmModal = new bootstrap.Modal(document.getElementById('confirmModal'));
        confirmModal.show();

        const yesBtn = document.getElementById('yesBtn');
        const cancelBtn = document.getElementById('cancelBtn');

        const cleanup = () => {
          yesBtn.removeEventListener('click', onYes);
          cancelBtn.removeEventListener('click', onCancel);
        };

        const onYes = () => {
          cleanup();
          confirmModal.hide();
          resolve(true);
        };

        const onCancel = () => {
          cleanup();
          resolve(false);
        };

        yesBtn.addEventListener('click', onYes);
        cancelBtn.addEventListener('click', onCancel);
      });
    }
  </script>

  <script>
    // ctacry kku ullukku ulle service ellam all service slct box script
    document.querySelectorAll('.selectAllSub').forEach(function(subCheckbox) {
      subCheckbox.addEventListener('change', function() {
        const targetId = this.getAttribute('data-target');
        // anthe ctacrykke ulle secrvice boxx a mattum slct pnnum
        const checkboxes = document.querySelectorAll('#' + targetId + ' input[name="selected_ids[]"]');
        checkboxes.forEach(cb => {
          cb.checked = subCheckbox.checked;
        });
      });
    });
  </script>


  <script>
    // inactiv srvice dlt script cnfrom
    function confirmDelete() {
      return confirm("Are you sure you want to delete all inactive services? This action cannot be undone.");
    }
  </script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>