<?php
include '../config/db.php'; // DB இணைப்பு
include 'session.php';


if (!isset($_SESSION['selected_provider_id'])) {
    header("Location: select_provider");
    exit();
}

$provider_id = $_SESSION['selected_provider_id'];

// providers get
$stmt = $connect->prepare("SELECT api_key, api_url,cransi_type FROM providers WHERE id = ?");
$stmt->bind_param("i", $provider_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows == 0) {
    die("Invalid Provider ID");
}
$row_provider = $result->fetch_assoc();

$api_key = $row_provider['api_key'];
$api_url = $row_provider['api_url'];
$currency_type = $row_provider['cransi_type'];

class Api
{
    private $api_url;
    private $api_key;

    public function __construct($api_key, $api_url)
    {
        $this->api_key = $api_key;
        $this->api_url = $api_url;
    }

    // API மூலம் சேவைகள் (services) பெறும் method
    public function services()
    {
        $post_data = [
            'key' => $this->api_key,
            'action' => 'services'
        ];
        $response = $this->connect($post_data);
        return json_decode($response);
    }

    // POST request அனுப்பும் function
    private function connect($post_fields)
    {
        $post_data = http_build_query($post_fields);
        $ch = curl_init($this->api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Curl error: ' . curl_error($ch);
            return false;
        }
        curl_close($ch);
        return $result;
    }
}

$api = new Api($api_key, $api_url);
$services = $api->services();

$services_by_category = [];
if ($services && is_array($services)) {
    foreach ($services as $service) {
        $category = $service->category ?? 'Uncategorized';
        if (!isset($services_by_category[$category])) {
            $services_by_category[$category] = [];
        }
        $services_by_category[$category][] = $service;
    }
}

// Helper function for truncate description
function truncateText($text, $maxLength = 50)
{
    $text = strip_tags($text);
    if (strlen($text) > $maxLength) {
        return htmlspecialchars(substr($text, 0, $maxLength)) . '...';
    }
    return htmlspecialchars($text);
}

function getDescription($service)
{
    // Possible keys for description
    $possibleKeys = ['desc', 'description', 'Description', 'details'];

    foreach ($possibleKeys as $key) {
        if (property_exists($service, $key)) {
            return $service->$key;
        }
    }

    // Default value if nothing found
    return '';
}


// Function: Get conversion rate once inclod funsen fill

include '../public/function/currency.php';

// funsen cal;l get lkr cransi cavorsen rate
$conversionRate = getConversionRate($currency_type);

if ($services && is_array($services)) {
    foreach ($services as &$service) {
        // rate இருக்கும் என்றால் convert செய்யலாம்
        if (isset($service->rate)) {
            $service->rate_in_lkr = round($service->rate * $conversionRate, 6);
        } else {
            $service->rate_in_lkr = 0;
        }
    }
    unset($service);
}


?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>API Services List by Category</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        /* Scrollable table */
        .table-responsive {
            max-height: 600px;
            overflow-y: auto;
        }

        /* Pointer for collapsible */
        .category-header {
            cursor: pointer;
        }

        /* Truncate description with tooltip */
        .desc-cell {
            max-width: 250px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
    </style>
</head>

<body>
    <?php include 'include/header.php'; ?>

    <div class="container mt-4">
        <h2 class="mb-4 fw-bold text-success">All Services with Categories</h2>

        <form action="import_api_services" method="post" id="importForm">
            <input type="hidden" name="import_data_json" id="import_data_json" />
            <button type="submit" class="btn btn-primary mb-3">Import Selected Services</button>

            <div class="mb-3">
                <label for="searchInput" class="form-label">Search Services</label>
                <input type="text" id="searchInput" class="form-control" placeholder="Search by name, type, or category..." />
            </div>

            <div class="table-responsive">
                <table class="table table-bordered table-hover align-middle" id="productTable">
                    <thead class="table-dark text-center sticky-top">
                        <tr>

                            <th style="width: 80px;">Service ID</th>
                            <th>Name</th>
                            <th style="width: 80px;">Type</th>
                            <th style="width: 100px;">Rate LKR</th>
                            <th style="width: 80px;">Min Qty</th>
                            <th style="width: 80px;">Max Qty</th>
                            <th style="width: 60px;">Refill</th>
                            <th>Description</th>
                            <th style="width: 80px;">Select</th>
                            <th class="text-center">
                                <input type="checkbox" id="selectAll"> Select All
                            </th>




                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($services_by_category as $category_name => $services): ?>
                            <tr class="table-primary category-header" data-bs-toggle="collapse" data-bs-target="#cat-<?= md5($category_name) ?>" aria-expanded="false" aria-controls="cat-<?= md5($category_name) ?>">
                                <td colspan="10" class="fw-bold"><?= htmlspecialchars($category_name) ?> <span class="float-end">▼</span>
                                    <input type="checkbox" id="selectAllSub_<?= md5($category_name) ?>" class="selectAllSub" data-target="cat-<?= md5($category_name) ?>">

                                </td>

                            </tr>
                    <tbody id="cat-<?= md5($category_name) ?>" class="collapse">
                        <?php foreach ($services as $service): ?>
                            <tr class="service-row">
                                <td class="text-center"><?= htmlspecialchars($service->service) ?></td>
                                <td><?= htmlspecialchars($service->name) ?></td>
                                <td class="text-center"><?= htmlspecialchars($service->type) ?></td>
                                <td class="text-end">
                                    <?= number_format((float)$service->rate_in_lkr, 6) ?>
                                </td>

                                <td class="text-center"><?= htmlspecialchars($service->min) ?></td>
                                <td class="text-center"><?= htmlspecialchars($service->max) ?></td>
                                <td class="text-center"><?= ($service->refill) ? 'Yes' : 'No' ?></td>

                                <?php
                                $description = getDescription($service);
                                ?>

                                <td class="desc-cell" title="<?= htmlspecialchars($description) ?>">
                                    <?= truncateText($description) ?>
                                </td>

                                <td class="text-center">
                                    <input type="checkbox" name="selected_ids[]" class="service-checkbox" data-service='<?= json_encode([
                                                                                                                            'service_id' => $service->service,
                                                                                                                            'category' => $category_name,
                                                                                                                            'name' => $service->name,
                                                                                                                            'type' => $service->type,
                                                                                                                            'rate' => $service->rate_in_lkr,
                                                                                                                            'min' => $service->min,
                                                                                                                            'max' => $service->max,
                                                                                                                            'refill' => $service->refill,
                                                                                                                            'desc' => getDescription($service),

                                                                                                                        ], JSON_HEX_APOS | JSON_HEX_QUOT) ?>' />
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                <?php endforeach; ?>
                </tbody>
                </table>
            </div>
        </form>
    </div>







    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        document.getElementById("importForm").addEventListener("submit", function(e) {
            e.preventDefault(); // prevent browser default submission

            const selectedData = {};
            document.querySelectorAll(".service-checkbox:checked").forEach((checkbox) => {
                const data = JSON.parse(checkbox.dataset.service);
                selectedData[data.service_id] = data;
            });

            if (Object.keys(selectedData).length === 0) {
                alert("❌ Please select at least one service to import.");
                return;
            }

            document.getElementById("import_data_json").value = JSON.stringify(selectedData);
            this.submit(); // now safe to submit
        });
    </script>


    <script>
        // Search filter (search across visible service rows)
        document.getElementById("searchInput").addEventListener("input", function() {
            const searchValue = this.value.toLowerCase();

            // For each category group, check if any service matches the search
            document.querySelectorAll("tbody[id^='cat-']").forEach(tbody => {
                let anyVisible = false;
                tbody.querySelectorAll(".service-row").forEach(row => {
                    const text = row.textContent.toLowerCase();
                    const show = text.includes(searchValue);
                    row.style.display = show ? "" : "none";
                    if (show) anyVisible = true;
                });

                // Show or hide category header based on if any service visible
                const categoryHeader = tbody.previousElementSibling;
                if (anyVisible) {
                    tbody.classList.add("show"); // bootstrap collapse show
                    categoryHeader.style.display = "";
                } else {
                    tbody.classList.remove("show");
                    categoryHeader.style.display = "none";
                }
            });
        });
    </script>

    <script>
        //  Main Select All tik boxx
        document.getElementById('selectAll').onclick = function() {
            // all service-checkbox-களையும் select/deselect செய்க
            const serviceCheckboxes = document.querySelectorAll('.service-checkbox');
            serviceCheckboxes.forEach(cb => cb.checked = this.checked);

            //  எல்லா sub-category selectAllSub-களையும் select/deselect செய்க
            const subSelectCheckboxes = document.querySelectorAll('.selectAllSub');
            subSelectCheckboxes.forEach(cb => cb.checked = this.checked);
        };

        // ஒவ்வொரு category க்கான selectAllSub checkboxக்கு click event
        document.querySelectorAll('.selectAllSub').forEach(function(subSelect) {
            subSelect.addEventListener('change', function() {
                const targetTbodyId = this.dataset.target;
                const tbody = document.getElementById(targetTbodyId);
                if (!tbody) return;

                // அந்த tbody உள்ள எல்லா checkbox-களையும் change செய்யலாம்
                const subCheckboxes = tbody.querySelectorAll('.service-checkbox');
                subCheckboxes.forEach(cb => cb.checked = this.checked);
            });
        });
    </script>





</body>

</html>