<?php include 'session.php'; ?>
<?php include '../config/db.php'; ?>


<?php


// Delete selected records
if (isset($_POST['delete_selected']) && !empty($_POST['selected_ids'])) {
  $ids = $_POST['selected_ids'];

  // Clean the input to avoid SQL Injection
  $ids = array_map('intval', $ids);

  // Prepare placeholders for IN clause
  $placeholders = implode(',', array_fill(0, count($ids), '?'));

  // Prepare statement
  $types = str_repeat('i', count($ids)); // all integers
  $stmt = $connect->prepare("DELETE FROM ez_payment WHERE id IN ($placeholders)");

  // Bind parameters dynamically
  $stmt->bind_param($types, ...$ids);
  $stmt->execute();

  $_SESSION['msg'] = '<div class="alert alert-success">' . count($ids) . ' record(s) deleted successfully!</div>';
  header("Location: " . $_SERVER['PHP_SELF']);
  exit();
}



// DELETE Record
if (isset($_POST['delete_id'])) {
  $del_id = intval($_POST['delete_id']);
  $stmt = $connect->prepare("DELETE FROM ez_payment WHERE id = ?");
  $stmt->bind_param("i", $del_id);
  $stmt->execute();
  $_SESSION['msg'] = '<div class="alert alert-success">Record deleted successfully!</div>';
  header("Location: " . $_SERVER['PHP_SELF']);
  exit();
}

// EDIT Record
if (isset($_POST['edit_id'])) {
  $edit_id = intval($_POST['edit_id']);
  $rn_number = $_POST['rn_number'] ?? null;
  $amount = $_POST['amount'] ?? 0;
  $charge = $_POST['charge'] ?? 0;
  $date = $_POST['date'] ?? '';
  $received_from = $_POST['received_from'] ?? '';
  $net_received = $_POST['net_received'] ?? 0;

  $stmt = $connect->prepare("UPDATE ez_payment SET rn_number=?, amount=?, charge=?, date=?, received_from=?, net_received=? WHERE id=?");
  $stmt->bind_param("iddssdi", $rn_number, $amount, $charge, $date, $received_from, $net_received, $edit_id);
  $stmt->execute();

  $_SESSION['msg'] = '<div class="alert alert-success">Record updated successfully!</div>';
  header("Location: " . $_SERVER['PHP_SELF']);
  exit();
}

// Fetch records
$result = $connect->query("SELECT * FROM ez_payment ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>EZ Payment Records</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>

<body>
  <?php include 'include/header.php'; ?>
  <div class="container my-4">
    <h2 class="mb-4 text-center fw-bold text-primary">Ez not Complete Payment Records</h2>

    <!-- Session Message -->
    <?php
    if (!empty($_SESSION['msg'])) {
      echo $_SESSION['msg'];
      unset($_SESSION['msg']);
    }
    ?>



    <div class="table-responsive shadow rounded">
      <table class="table table-striped table-hover table-bordered align-middle text-center">

        <form method="POST" action="" onsubmit="return confirm('Are you sure to delete selected Payment ?')">

          <div class="d-flex justify-content-end mb-3">
            <button type="submit" name="delete_selected" class="btn btn-danger">
              Delete Selected
            </button>
          </div>


          <thead class="table-primary">
            <tr>
              <th>
                <input type="checkbox" id="selectAll">
              </th>
              <th>ID</th>
              <th>RN Number</th>
              <th>Amount</th>
              <th>Charge</th>
              <th>Date</th>
              <th>Received From</th>
              <th>Net Received</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php if ($result && $result->num_rows > 0): ?>
              <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                  <td class="text-center"><input type="checkbox" name="selected_ids[]" value="<?= $row['id'] ?>"></td>

                  <td><?= htmlspecialchars($row['id']) ?></td>
                  <td><?= htmlspecialchars($row['rn_number']) ?></td>
                  <td><?= htmlspecialchars($row['amount']) ?></td>
                  <td><?= htmlspecialchars($row['charge']) ?></td>
                  <td><?= htmlspecialchars($row['date']) ?></td>
                  <td><?= htmlspecialchars($row['received_from']) ?></td>
                  <td><?= htmlspecialchars($row['net_received']) ?></td>

                  <td>
                    <button
                    type="button"
                      class="btn btn-warning btn-sm"
                      data-bs-toggle="modal"
                      data-bs-target="#editModal"
                      data-id="<?= $row['id'] ?>"
                      data-rn="<?= htmlspecialchars($row['rn_number']) ?>"
                      data-amount="<?= htmlspecialchars($row['amount']) ?>"
                      data-charge="<?= htmlspecialchars($row['charge']) ?>"
                      data-date="<?= htmlspecialchars($row['date']) ?>"
                      data-received_from="<?= htmlspecialchars($row['received_from']) ?>"
                      data-net_received="<?= htmlspecialchars($row['net_received']) ?>">Edit</button>

                    <button
                    type="button"
                      class="btn btn-danger btn-sm"
                      data-bs-toggle="modal"
                      data-bs-target="#deleteModal"
                      data-id="<?= $row['id'] ?>">Delete</button>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php else: ?>
              <tr>
                <td colspan="8" class="text-center">No records found</td>
              </tr>
            <?php endif; ?>
          </tbody>

        </form>
      </table>
    </div>
  </div>

  <!-- Edit Modal -->
  <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
      <div class="modal-content">
        <form method="post" id="editForm">
          <div class="modal-header bg-warning text-dark">
            <h5 class="modal-title" id="editModalLabel">Edit Payment Record</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body row g-3">
            <input type="hidden" name="edit_id" id="edit-id" />

            <div class="col-md-4">
              <label for="edit-rn" class="form-label">RN Number</label>
              <input type="number" class="form-control" name="rn_number" id="edit-rn" required />
            </div>
            <div class="col-md-4">
              <label for="edit-amount" class="form-label">Amount</label>
              <input type="number" step="0.01" class="form-control" name="amount" id="edit-amount" required />
            </div>
            <div class="col-md-4">
              <label for="edit-charge" class="form-label">Charge</label>
              <input type="number" step="0.01" class="form-control" name="charge" id="edit-charge" />
            </div>
            <div class="col-md-6">
              <label for="edit-date" class="form-label">Date</label>
              <input type="text" class="form-control" name="date" id="edit-date" />
            </div>
            <div class="col-md-6">
              <label for="edit-received-from" class="form-label">Received From</label>
              <input type="text" class="form-control" name="received_from" id="edit-received-from" />
            </div>
            <div class="col-md-6">
              <label for="edit-net-received" class="form-label">Net Received</label>
              <input type="number" step="0.01" class="form-control" name="net_received" id="edit-net-received" />
            </div>
          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-warning">Save Changes</button>
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Delete Modal -->
  <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <form method="post" id="deleteForm">
          <div class="modal-header bg-danger text-white">
            <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            Are you sure you want to delete this record?
            <input type="hidden" name="delete_id" id="delete-id" />
          </div>
          <div class="modal-footer">
            <button type="submit" class="btn btn-danger">Delete</button>
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          </div>
        </form>
      </div>
    </div>
  </div>


  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    // Fill Edit Modal with data on button click
    var editModal = document.getElementById('editModal')
    editModal.addEventListener('show.bs.modal', function(event) {
      var button = event.relatedTarget
      var id = button.getAttribute('data-id')
      var rn = button.getAttribute('data-rn')
      var amount = button.getAttribute('data-amount')
      var charge = button.getAttribute('data-charge')
      var date = button.getAttribute('data-date')
      var received_from = button.getAttribute('data-received_from')
      var net_received = button.getAttribute('data-net_received')

      document.getElementById('edit-id').value = id
      document.getElementById('edit-rn').value = rn
      document.getElementById('edit-amount').value = amount
      document.getElementById('edit-charge').value = charge
      document.getElementById('edit-date').value = date
      document.getElementById('edit-received-from').value = received_from
      document.getElementById('edit-net-received').value = net_received
    })

    // Fill Delete Modal with id on button click
    var deleteModal = document.getElementById('deleteModal')
    deleteModal.addEventListener('show.bs.modal', function(event) {
      var button = event.relatedTarget
      var id = button.getAttribute('data-id')
      document.getElementById('delete-id').value = id
    })









    // Checkbox Select All
    document.getElementById('selectAll').onclick = function() {
      const checkboxes = document.querySelectorAll('input[name="selected_ids[]"]');
      for (let checkbox of checkboxes) {
        checkbox.checked = this.checked;
      }
    };
  </script>

</body>

</html>
<?php
$connect->close();
?>