<?php include 'session.php'; ?>
<?php include '../config/db.php'; ?>

<?php
$_SESSION['dashboard'] = "25";

// 🔹 Count Function
function getCount($connect, $table)
{
  $res = mysqli_query($connect, "SELECT COUNT(*) as cnt FROM $table");
  return $res ? mysqli_fetch_assoc($res)['cnt'] : 0;
}

// 🔹 Get counts
$orders_count = getCount($connect, 'orders');
$category_count = getCount($connect, 'category');
$providers_count = getCount($connect, 'providers');
$services_count = getCount($connect, 'services');
$hide_category_count = getCount($connect, 'hide_category');
$payment_request_count = getCount($connect, 'payment_request');
$payment_history_count = getCount($connect, 'payment_history');
$bank_details_count = getCount($connect, 'bank_details');
$custom_prices_count = getCount($connect, 'custom_prices');
$custom_quantity_count = getCount($connect, 'custom_quantity');
$referel_count = getCount($connect, 'referel');
$telegram_bots_count = getCount($connect, 'telegram_bots');
$users2_count = getCount($connect, 'users2');
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Professional Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <style>
    body {
      background-color: #f8f9fc;
    }

    .card {
      border: none;
      border-radius: 15px;
      transition: all 0.3s ease-in-out;
    }

    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    }

    .summary-card {
      color: #fff;
      border-radius: 15px;
    }

    .summary-icon {
      font-size: 2.2rem;
    }

    .chart-container {
      position: relative;
      min-height: 350px;
    }

    @media(max-width: 576px) {
      .summary-icon {
        font-size: 1.8rem;
      }

      h3 {
        font-size: 1.4rem;
      }

      h5 {
        font-size: 1rem;
      }
    }
  </style>
</head>

<body>
  <?php include 'include/header.php'; ?>

  <div class="container py-4">
    <h1 class="fw-bold text-center text-primary mb-4">Admin Dashboard</h1>


    <!-- 🔹 Date Range Filter -->
    <div class="card shadow-sm mb-4 p-3">
      <div class="row align-items-center g-2">
        <div class="col-md-3 text-center">
          <h5 class="fw-bold text-secondary mb-0">Select Date Range</h5>
        </div>
        <div class="col-md-3">
          <input type="date" id="fromDate" class="form-control" />
        </div>
        <div class="col-md-3">
          <input type="date" id="toDate" class="form-control" />
        </div>
        <div class="col-md-3">
          <button id="filterBtn" class="btn btn-primary w-100">
            <i class="bi bi-search"></i> Filter
          </button>
        </div>
      </div>
    </div>

    <!-- 🔹 Summary Section -->
    <div class="row g-4 mb-4" id="summarySection">
      <div class="col-12 text-center">
        <div class="spinner-border text-primary" role="status"></div>
        <p class="text-muted mt-2">Loading statistics...</p>
      </div>
    </div>

    <!-- 🔹 Chart -->
    <div class="card shadow-sm mb-5">
      <div class="card-body">
        <h5 class="fw-bold text-center mb-3 text-success">
          Panel Statistics Overview
        </h5>
        <div class="chart-container">
          <canvas id="dashboardChart"></canvas>
        </div>
      </div>
    </div>























    <div class="py-4">
      <h1 class="mb-4 text-center fw-bold text-danger">Cron Jobs Control</h1>

      <div class="row g-4 justify-content-center">
        <!-- Service Check -->
        <div class="col-12 col-sm-6 col-md-4 col-lg-3">
          <a href="../api/sarvice_chak.php" class="text-decoration-none">
            <div class="card shadow-sm h-100 text-center p-4 bg-primary text-white">
              <i class="bi bi-gear-fill fs-1 mb-3"></i>
              <h5 class="card-title">Service Check</h5>
              <p class="small">Run cron to check services</p>
            </div>
          </a>
        </div>

        <!-- Cransi Convert Update -->
        <div class="col-12 col-sm-6 col-md-4 col-lg-3">
          <a href="../public/cron/currency_rates.php" class="text-decoration-none">
            <div class="card shadow-sm h-100 text-center p-4 bg-success text-white">
              <i class="bi bi-currency-exchange fs-1 mb-3"></i>
              <h5 class="card-title">Cransi Update</h5>
              <p class="small">Update conversion rates</p>
            </div>
          </a>
        </div>

        <!-- Order Status Check -->
        <div class="col-12 col-sm-6 col-md-4 col-lg-3">
          <a href="../api/order_status.php" class="text-decoration-none">
            <div class="card shadow-sm h-100 text-center p-4 bg-warning text-dark">
              <i class="bi bi-list-check fs-1 mb-3"></i>
              <h5 class="card-title">Order Status</h5>
              <p class="small">Check & update order status</p>
            </div>
          </a>
        </div>

        <!-- Lost Provider Price Update -->
        <div class="col-12 col-sm-6 col-md-4 col-lg-3">
          <a href="../public/cron/provider_price_update.php" class="text-decoration-none">
            <div class="card shadow-sm h-100 text-center p-4 bg-danger text-white">
              <i class="bi bi-cash-coin fs-1 mb-3"></i>
              <h5 class="card-title">Provider Price</h5>
              <p class="small">Update lost provider price</p>
            </div>
          </a>
        </div>



        <!-- Clean Invalid Orders -->
        <div class="col-12 col-sm-6 col-md-4 col-lg-3">
          <div id="cleanBtn" class="card shadow-sm h-100 text-center p-4 bg-warning text-white" style="cursor:pointer;">
            <i class="bi bi-trash-fill fs-1 mb-3"></i>
            <h5 class="card-title">Clean Orders</h5>
            <p class="small">Delete orders with missing service</p>
          </div>
        </div>

    

      </div>
    </div>







  <!-- Clean Orders Modal -->
    <div class="modal fade" id="cleanModal" tabindex="-1" aria-labelledby="cleanModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content text-center">
                <div class="modal-header">
                    <h5 class="modal-title" id="cleanModalLabel">Cleaning Orders</h5>
                </div>
                <div class="modal-body" id="cleanModalBody">
                    <div class="spinner-border text-warning mb-3" role="status"></div>
                    <p>Please wait, cleaning in progress...</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary d-none" id="closeModalBtn" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>





















    <!-- 🔹 Stats Grid -->
    <div class="row g-4 text-center">
      <?php
      $cards = [
        ['Orders', 'bi-basket-fill', $orders_count, 'primary'],
        ['Categories', 'bi-tags-fill', $category_count, 'warning'],
        ['Providers', 'bi-people-fill', $providers_count, 'danger'],
        ['Services', 'bi-gear-fill', $services_count, 'info'],
        ['Hidden Categories', 'bi-eye-slash-fill', $hide_category_count, 'secondary'],
        ['Payment Requests', 'bi-wallet2', $payment_request_count, 'dark'],
        ['Payment History', 'bi-receipt', $payment_history_count, 'success'],
        ['Bank Details', 'bi-bank', $bank_details_count, 'info'],
        ['Custom Prices', 'bi-cash-stack', $custom_prices_count, 'warning'],
        ['Custom Quantity', 'bi-box-seam', $custom_quantity_count, 'secondary'],
        ['Referral', 'bi-people', $referel_count, 'danger'],
        ['Telegram Bots', 'bi-robot', $telegram_bots_count, 'primary'],
        ['Users', 'bi-person-fill', $users2_count, 'success']
      ];

      foreach ($cards as $card) {
        echo "
            <div class='col-6 col-sm-6 col-md-4 col-lg-3'>
              <div class='card shadow-sm bg-{$card[3]} text-white h-100 p-3'>
                <div class='d-flex align-items-center justify-content-center'>
                  <i class='bi {$card[1]} summary-icon me-3'></i>
                  <div>
                    <h6 class='mb-1 fw-bold'>{$card[0]}</h6>
                    <h4>{$card[2]}</h4>
                  </div>
                </div>
              </div>
            </div>
            ";
      }
      ?>
    </div>
  </div>

  <script>
    // ✅ Load profit summary (default or custom)
    function loadSummary(day = 7, from = '', to = '') {
      $("#summarySection").html(`
        <div class="col-12 text-center">
          <div class="spinner-border text-primary" role="status"></div>
          <p class="text-muted mt-2">Loading summary...</p>
        </div>
      `);

      let apiUrl = `more/spand.php?key=access`;
      if (from && to) {
        const diffDays = Math.floor((new Date(to) - new Date(from)) / (1000 * 60 * 60 * 24));
        apiUrl += `&day=${diffDays}`;
      } else {
        apiUrl += `&day=${day}`;
      }

      $.getJSON(apiUrl, function(data) {
        if (data.status === "success") {
          $("#summarySection").html(`
            <div class="col-12 col-md-4">
              <div class="card summary-card bg-primary p-4 text-center">
                <i class="bi bi-wallet2 summary-icon mb-2"></i>
                <h5>Total Spent</h5>
                <h3>${data.total_spent} ${data.currency || 'LKR'}</h3>
              </div>
            </div>
            <div class="col-12 col-md-4">
              <div class="card summary-card bg-success p-4 text-center">
                <i class="bi bi-coin summary-icon mb-2"></i>
                <h5>Total Charge</h5>
                <h3>${data.total_charge} ${data.currency || 'LKR'}</h3>
              </div>
            </div>
            <div class="col-12 col-md-4">
              <div class="card summary-card bg-danger p-4 text-center">
                <i class="bi bi-graph-up summary-icon mb-2"></i>
                <h5>Total Profit</h5>
                <h3>${data.total_profit} ${data.currency || 'LKR'}</h3>
              </div>
            </div>
          `);
        } else {
          $("#summarySection").html(
            `<div class='alert alert-danger text-center'>Error loading data</div>`
          );
        }
      }).fail(function() {
        $("#summarySection").html(
          `<div class='alert alert-danger text-center'>Failed to fetch summary data</div>`
        );
      });
    }

    // ✅ Default 7 days load
    loadSummary();

    // ✅ Filter button event
    $("#filterBtn").click(function() {
      const from = $("#fromDate").val();
      const to = $("#toDate").val();

      if (!from || !to) {
        alert("Please select both From and To dates.");
        return;
      }

      loadSummary(0, from, to);
    });

    // ✅ Chart
    const ctx = document.getElementById("dashboardChart").getContext("2d");
    new Chart(ctx, {
      type: "bar",
      data: {
        labels: [
          "Orders", "Categories", "Providers", "Services", "Hidden Categories",
          "Payment Requests", "Payment History", "Bank Details", "Custom Prices",
          "Custom Quantity", "Referral", "Telegram Bots", "Users"
        ],
        datasets: [{
          label: "Counts",
          data: [
            <?= $orders_count ?>,
            <?= $category_count ?>,
            <?= $providers_count ?>,
            <?= $services_count ?>,
            <?= $hide_category_count ?>,
            <?= $payment_request_count ?>,
            <?= $payment_history_count ?>,
            <?= $bank_details_count ?>,
            <?= $custom_prices_count ?>,
            <?= $custom_quantity_count ?>,
            <?= $referel_count ?>,
            <?= $telegram_bots_count ?>,
            <?= $users2_count ?>
          ],
          backgroundColor: [
            "#4e73df", "#1cc88a", "#36b9cc", "#f6c23e", "#e74a3b",
            "#858796", "#5a5c69", "#2e59d9", "#17a673", "#f6c23e",
            "#f8f9fc", "#fd7e14", "#20c997"
          ]
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
          legend: {
            display: false
          },
          title: {
            display: true,
            text: "System Overview",
            color: "#333",
            font: {
              size: 18
            }
          }
        },
        scales: {
          y: {
            beginAtZero: true
          }
        }
      }
    });
    
    
    
    
    
    
    
    
    
    
    
    
    
  </script>
  
  
    <!-- Clean Orders script -->
      <script>
          $('#cleanBtn').click(function() {
            // Show modal before starting AJAX
            $('#cleanModal').modal('show');
            $('#cleanModalBody').html(`
        <div class="spinner-border text-warning mb-3" role="status"></div>
        <p>Please wait, cleaning in progress...</p>
    `);
            $('#closeModalBtn').addClass('d-none');

            $.ajax({
              url: 'more/clean.php',
              type: 'POST',
              dataType: 'json',
              success: function(response) {
                if (response.status === 'success') {
                  $('#cleanModalBody').html(`
                    <i class="bi bi-check-circle-fill text-success fs-1 mb-3"></i>
                    <p><strong>${response.deleted}</strong> invalid orders deleted!</p>
                `);
                } else {
                  $('#cleanModalBody').html(`
                    <i class="bi bi-exclamation-triangle-fill text-danger fs-1 mb-3"></i>
                    <p>Error: ${response.message}</p>
                `);
                }
                $('#closeModalBtn').removeClass('d-none');
              },
              error: function() {
                $('#cleanModalBody').html(`
                <i class="bi bi-exclamation-triangle-fill text-danger fs-1 mb-3"></i>
                <p>AJAX request failed!</p>
            `);
                $('#closeModalBtn').removeClass('d-none');
              }
            });
          });
        </script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>