<?php
include 'session.php';
include '../config/db.php';

// Handle form actions
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $action = $_POST['action'];
    $user_id = (int)($_POST['user_id'] ?? 0);
    $service_id = (int)($_POST['service_id'] ?? 0);
    $min_quantity = (int)($_POST['min_quantity'] ?? 0);
    $max_quantity = (int)($_POST['max_quantity'] ?? 0);
    $id = (int)($_POST['id'] ?? 0);

    if ($action === 'add') {
        $stmt = $connect->prepare("INSERT INTO custom_quantity (user_id, service_id, min_quantity, max_quantity) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("iiii", $user_id, $service_id, $min_quantity, $max_quantity);
        $stmt->execute();
    } elseif ($action === 'delete') {
        $stmt = $connect->prepare("DELETE FROM custom_quantity WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
    }

    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}

// Fetch data for display
$data = $connect->query("
    SELECT cq.id, u.username, s.service_name, cq.min_quantity, cq.max_quantity 
    FROM custom_quantity cq
    JOIN users2 u ON cq.user_id = u.id
    JOIN services s ON cq.service_id = s.id
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Custom Quantity Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php include 'include/header.php'; ?>

<div class="container mt-4">
    <h3 class="fw-bold text-primary mb-3">📊 Custom Quantity List</h3>
    <a href="custom_quantity_set" class="btn btn-success mb-3">➕ Add New Custom Quantity</a>

    <div class="table-responsive">
        <table class="table table-bordered align-middle">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Service</th>
                    <th>Min Qty</th>
                    <th>Max Qty</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            <?php while ($row = $data->fetch_assoc()) : ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= htmlspecialchars($row['username']) ?></td>
                    <td><?= htmlspecialchars($row['service_name']) ?></td>
                    <td><?= $row['min_quantity'] ?></td>
                    <td><?= $row['max_quantity'] ?></td>
                    <td>
                        <form method="POST" onsubmit="return confirm('Are you sure to delete this entry?')" class="d-inline">
                            <input type="hidden" name="id" value="<?= $row['id'] ?>">
                            <input type="hidden" name="action" value="delete">
                            <button class="btn btn-danger btn-sm">🗑 Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
