<?php
require('../config/db.php');
include 'session.php';
date_default_timezone_set('Asia/Colombo');

// Form Submit Check
if (isset($_POST['submit'])) {
    $username = mysqli_real_escape_string($connect, $_POST['username']);
    $amount = floatval($_POST['amount']); // Ensure it's a valid number
    $action = $_POST['action']; // Add or Deduct
    $currentDate = date('Y-m-d');
    // Check if user exists
    $query = "SELECT balance, refer_by, custome_ref FROM users2 WHERE username = '$username'";
    $result = mysqli_query($connect, $query);



    if (mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $currentBalance = $row['balance'];
        $referBy = $row['refer_by'];
        $custome_ref = $row['custome_ref'];

        if ($action == "add") {
            $newBalance = $currentBalance + $amount; // Add Balance
            $successMsg = "₹$amount added successfully!";
        } elseif ($action == "deduct") {
            if ($amount > $currentBalance) {
                $errorMsg = "Insufficient balance!";
            } else {
                $newBalance = $currentBalance - $amount; // Deduct Balance
                $successMsg = "₹$amount deducted successfully!";
            }
        }

        // Update balance in database (Only if deduction is valid)
        if (!isset($errorMsg)) {
            $updateQuery = "UPDATE users2 SET balance = '$newBalance' WHERE username = '$username'";
            if (mysqli_query($connect, $updateQuery)) {
                // Balance update success - now insert into history
                $insertHistory = "INSERT INTO balance_history (username, date, amount, action) 
                          VALUES ('$username', '$currentDate', '$amount', '$action')";
                if (!mysqli_query($connect, $insertHistory)) {
                    $errorMsg = "Error inserting into balance history: " . mysqli_error($connect);
                }
            } else {
                $errorMsg = "Error updating balance: " . mysqli_error($connect);
            }
        }




        // referral commission
        // Get referral info from referel table (1 row)
        $sql_comm = "SELECT referel_comisen, refrel_status FROM referel LIMIT 1";
        $stmt_comm = mysqli_prepare($connect, $sql_comm);
        mysqli_stmt_execute($stmt_comm);
        $result_comm = mysqli_stmt_get_result($stmt_comm);

        if ($row_comm = mysqli_fetch_assoc($result_comm)) {
            if ($row_comm['refrel_status'] == 1 && $row_comm['referel_comisen'] > 0) {



                if ($custome_ref <= 1) {
                    $commissionPercent = $row_comm['referel_comisen'];
                } else {
                    $commissionPercent = $custome_ref;
                }


                $commissionAmount = ($commissionPercent / 100) * $amount;

                // Get referrer's current balance & username
                $sql_balance = "SELECT balance, username FROM users2 WHERE refer = ?";
                $stmt_bal = mysqli_prepare($connect, $sql_balance);
                mysqli_stmt_bind_param($stmt_bal, "s", $referBy);
                mysqli_stmt_execute($stmt_bal);
                $result_bal = mysqli_stmt_get_result($stmt_bal);

                if ($row_bal = mysqli_fetch_assoc($result_bal)) {
                    $currentBalance = $row_bal['balance'];
                    $username_refer = $row_bal['username'];

                    $newBalance = $currentBalance + $commissionAmount;

                    // Update referrer's balance
                    $sql_update = "UPDATE users2 SET balance = ? WHERE refer = ?";
                    $stmt_update = mysqli_prepare($connect, $sql_update);
                    mysqli_stmt_bind_param($stmt_update, "ds", $newBalance, $referBy);
                    mysqli_stmt_execute($stmt_update);


                    // Insert commission record in referral_commissions
                    $date = date('Y-m-d H:i:s');
                    $sql_hist = "INSERT INTO referral_commissions (refer_username, referred_username, amount) VALUES (?, ?, ?)";
                    $stmt_hist = mysqli_prepare($connect, $sql_hist);
                    mysqli_stmt_bind_param($stmt_hist, "ssd", $username_refer, $username, $commissionAmount);
                    mysqli_stmt_execute($stmt_hist);
                }
            }
        }
    } else {
        $errorMsg = "User not found!";
    }
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Balance Update</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<?php include 'include/header.php'; ?>

<body class="bg-secondary">

    <div class="container mt-5 d-flex justify-content-center">
        <div class="card shadow-lg p-4 border-0 rounded-4" style="max-width: 450px; backdrop-filter: blur(10px); background: rgba(255, 255, 255, 0.15); box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);">
            <h2 class="text-center text-primary fw-bold mb-4">💰 Manage Balance</h2>

            <!-- Success & Error Messages -->
            <?php if (isset($successMsg)) : ?>
                <div class="alert alert-success text-center fw-bold py-2"><?php echo $successMsg; ?></div>
            <?php endif; ?>

            <?php if (isset($errorMsg)) : ?>
                <div class="alert alert-danger text-center fw-bold py-2"><?php echo $errorMsg; ?></div>
            <?php endif; ?>

            <form method="POST">
                <!-- Username Input -->
                <div class="mb-3 position-relative">
                    <label for="username" class="form-label fw-bold text-dark">👤 Username</label>
                    <input type="text" class="form-control shadow-sm px-3 py-2 border-0 rounded-pill" id="username" name="username" placeholder="Enter Username" required style="background: rgba(255, 255, 255, 0.2); transition: all 0.3s;">
                </div>

                <!-- Amount Input -->
                <div class="mb-3 position-relative">
                    <label for="amount" class="form-label fw-bold text-dark">💵 Amount (₹)</label>
                    <input type="number" class="form-control shadow-sm px-3 py-2 border-0 rounded-pill" id="amount" name="amount" placeholder="Enter Amount" required style="background: rgba(255, 255, 255, 0.2); transition: all 0.3s;">
                </div>

                <!-- Add / Deduct Selection -->
                <div class="mb-3 text-center">
                    <input type="radio" id="add" name="action" value="add" checked>
                    <label for="add" class="fw-bold text-success">➕ Add Balance</label>

                    <input type="radio" id="deduct" name="action" value="deduct" class="ms-3">
                    <label for="deduct" class="fw-bold text-danger">➖ Deduct Balance</label>
                </div>

                <!-- Submit Button -->
                <div class="text-center">
                    <button type="submit" name="submit" class="btn btn-success fw-bold px-4 py-2 rounded-pill" style="transition: all 0.3s; background: linear-gradient(45deg, #28a745, #218838); border: none;">
                        🔄 Update Balance
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Add Hover & Focus Effects -->
    <style>
        .form-control:focus {
            background: rgba(255, 255, 255, 0.4) !important;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1) !important;
        }

        .btn-success:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 12px rgba(0, 128, 0, 0.3);
        }

        input[type="radio"] {
            transform: scale(1.2);
            margin-right: 5px;
        }
    </style>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>