<?php include 'session.php'; ?>
<?php
// DB Connection
include '../config/db.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $payment_method = $_POST['payment_method'];
    $account_name = $_POST['account_name'];
    $account_number = $_POST['account_number'];
    $branch = $_POST['branch'];
    $message = $_POST['message'];

    // Insert the bank details into the database
    $stmt = $connect->prepare("INSERT INTO bank_details (payment_method, account_name, account_number, branch, message) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $payment_method, $account_name, $account_number, $branch, $message);
    $stmt->execute();

    // Success message
    $msg = "Bank details added successfully!";
    header('Location: add_bank.php');
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Bank Details</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include 'include/header.php'; ?>

<div class="container mt-5">
    <div class="card shadow p-4">
        <h3 class="mb-4">Add Bank Details</h3>
        
        <!-- Success Message -->
        <?php if (isset($msg)): ?>
            <div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="payment_method" class="form-label">Payment Method</label>
                    <input type="text" name="payment_method" id="payment_method" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label for="account_name" class="form-label">Account Name</label>
                    <input type="text" name="account_name" id="account_name" class="form-control" required>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="account_number" class="form-label">Account Number</label>
                    <input type="text" name="account_number" id="account_number" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <label for="branch" class="form-label">Branch</label>
                    <input type="text" name="branch" id="branch" class="form-control" required>
                </div>
            </div>

            <div class="mb-3">
                <label for="message" class="form-label">Message</label>
                <textarea name="message" id="message" class="form-control" rows="3"></textarea>
            </div>

            <button type="submit" class="btn btn-primary">Save Bank Details</button>
        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
