<?php

require('config/db.php'); // Database connection
include 'public/session.php';
include 'public/include/email_verify.php';




$username = mysqli_real_escape_string($connect, $_SESSION['name']);
$query = "SELECT * FROM balance_history WHERE username = '$username' ORDER BY id DESC";
$result = mysqli_query($connect, $query);
$name = $_SESSION['name'];
$query2 = "SELECT * FROM users2 WHERE username = '$name'";
$result2 = mysqli_query($connect, $query2);
$row2 = mysqli_fetch_assoc($result2);
$_SESSION['email'] = $row2['email'];




$bank_query = "SELECT * FROM bank_details";
$bank_result = mysqli_query($connect, $bank_query);

$result_whatsapp = $connect->query("SELECT whatsapp_number FROM setting LIMIT 1");
$row_whatsapp = $result_whatsapp->fetch_assoc();
$whatsapp_number = $row_whatsapp['whatsapp_number'] ?? "+94700000000"; // fallback number

// Fetch site settings from `ez_setting` table
$result_setting = $connect->query("SELECT ez_number, offers_percentage,status, website_url FROM  ez_auto_payment_setting LIMIT 1");
$row_setting = $result_setting->fetch_assoc();


// ✅ Newly added fields
$ez_number          = $row_setting['ez_number'] ?? '';
$profit_percentage  = $row_setting['offers_percentage'] ?? '';
$status             = $row_setting['status'] ?? 0;
$website_url        = $row_setting['website_url'] ?? 'https://demo.com';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $name = mysqli_real_escape_string($connect, $_POST['name']);
  $email = mysqli_real_escape_string($connect, $_POST['email']);
  $whatsapp = mysqli_real_escape_string($connect, $_POST['whatsapp']);
  $payment_method = mysqli_real_escape_string($connect, $_POST['payment_method']);

  // File Upload
  $upload_dir = 'upload/';
  if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true);
  }

  $file_tmp = $_FILES['payment_image']['tmp_name'];
  $file_name = time() . '_' . basename($_FILES['payment_image']['name']);
  $file_path = $upload_dir . $file_name;

  if (move_uploaded_file($file_tmp, $file_path)) {

    // Insert into DB
    $query = "INSERT INTO payment_request (username, email, whatsapp_number, payment_method, payment_image)
              VALUES ('$name', '$email', '$whatsapp', '$payment_method', '$file_path')";

    if (mysqli_query($connect, $query)) {



      $_SESSION['success'] = "✅ Payment submitted successfully!";







      //  taligram bot message

      // ✅ Auto domain
      $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ||
        $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
      $host = $_SERVER['HTTP_HOST'];
      $auto_base_url = rtrim($protocol . $host, "/") . "/";


      $base_url = $auto_base_url;


      $image_url = $base_url . ltrim($file_path, "/");

      // ✅ Caption
      $message = "🧾 *New Payment Request!*\n\n"
        . "👤 *Name:* $name\n"
        . "📧 *Email:* $email\n"
        . "📱 *WhatsApp:* $whatsapp\n"
        . "💳 *Payment Method:* $payment_method";

      // ✅ Send to all active bots
      $sql = "SELECT bot_token, chat_id FROM telegram_bots WHERE status = 1";
      $result = mysqli_query($connect, $sql);

      if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
          $bot_token = $row['bot_token'];
          $chat_id = $row['chat_id'];

          $sent = false;

          // 🔎 First try image URL
          $headers = @get_headers($image_url);
          if ($headers && strpos($headers[0], '200') !== false) {
            $data = [
              'chat_id' => $chat_id,
              'photo' => $image_url,
              'caption' => $message,
              'parse_mode' => 'Markdown'
            ];
            $url = "https://api.telegram.org/bot$bot_token/sendPhoto";
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_exec($ch);
            curl_close($ch);
            $sent = true;
          }

          // 🔎 If URL not valid, try uploading local file
          if (!$sent && file_exists($file_path)) {
            $data = [
              'chat_id' => $chat_id,
              'photo' => new CURLFile(realpath($file_path)),
              'caption' => $message,
              'parse_mode' => 'Markdown'
            ];
            $url = "https://api.telegram.org/bot$bot_token/sendPhoto";
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_exec($ch);
            curl_close($ch);
            $sent = true;
          }

          // 📩 If image not sent, at least send text
          if (!$sent) {
            $data = [
              'chat_id' => $chat_id,
              'text' => $message,
              'parse_mode' => 'Markdown'
            ];
            $url = "https://api.telegram.org/bot$bot_token/sendMessage";
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_exec($ch);
            curl_close($ch);
          }
        }
      }






      header("Location: add_Found_history");
      exit;
    } else {
      $_SESSION['error'] = "❌ Failed to submit payment. Error: " . mysqli_error($connect);
    }
  } else {
    $_SESSION['error'] = "❌ Failed to upload payment image.";
  }
}
?>



<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">






  <title>Add Fund & Payment History | <?= htmlspecialchars($sitename) ?> | Secure Payments & Transaction Records</title>

<meta name="description" content="Manage your funds and view payment history on <?= htmlspecialchars($sitename) ?>. Add balance securely and track all your past social media marketing transactions.">
<meta name="keywords" content="add fund, payment history, smm panel sri lanka, deposit funds, transaction history, secure payments, instagram followers, tiktok likes, youtube views, rootsmm, rootmasterlk">

<meta name="robots" content="noindex, follow">
<meta name="author" content="<?= htmlspecialchars($sitename) ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Open Graph / Facebook / Instagram -->
<meta property="og:title" content="Add Fund & Payment History | <?= htmlspecialchars($sitename) ?>">
<meta property="og:description" content="Easily add funds and track your payment history on <?= htmlspecialchars($sitename) ?>. Secure transactions for all your SMM panel services.">
<meta property="og:type" content="website">
<meta property="og:url" content="https://rootmasterlk.store/addfunds">
<meta property="og:image" content="<?= htmlspecialchars($site_image) ?>">
<meta property="og:site_name" content="<?= htmlspecialchars($sitename) ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Add Fund & Payment History | <?= htmlspecialchars($sitename) ?>">
<meta name="twitter:description" content="Add funds and view your SMM panel payment history securely on <?= htmlspecialchars($sitename) ?>. Manage your balance with ease.">
<meta name="twitter:image" content="<?= htmlspecialchars($site_image) ?>">

<!-- Canonical -->
<link rel="canonical" href="https://rootmasterlk.store/addfunds">

<!-- JSON-LD Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "name": "Add Fund & Payment History - <?= htmlspecialchars($sitename) ?>",
  "url": "https://rootmasterlk.store/addfunds",
  "description": "Add funds to your <?= htmlspecialchars($sitename) ?> account and view your full payment history securely. Trusted platform for SMM services and fast deposits.",
  "publisher": {
    "@type": "Organization",
    "name": "<?= htmlspecialchars($sitename) ?>",
    "logo": "<?= htmlspecialchars($site_image) ?>"
  }
}
</script>


  <!-- ✅ Toastr -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

  <!-- ✅ Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <?php include 'public/include/titlemg.php'; ?>

  <style>
    body {
      background: #f5f4fa;
      font-family: 'Poppins', sans-serif;
    }

    /* 🔹 Toast Styling */
    .toast-success {
      background-color: #fff !important;
      color: #28a745 !important;
      border: 2px solid #28a745;
      font-weight: 500;
    }

    .toast-error {
      background-color: #fff !important;
      color: #dc3545 !important;
      border: 2px solid #dc3545;
      font-weight: 500;
    }

    /* 🔹 Payment Form */
    .payment-form {
      background: linear-gradient(135deg, #6c63ff, #3f3fff);
      padding: 2rem;
      border-radius: 15px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
      color: #fff;
    }

    .payment-form label {
      font-weight: 500;
    }

    .form-control, .form-select {
      border-radius: 8px;
    }

    .btn-primary {
      background: #fff;
      color: #3f3fff;
      font-weight: 600;
      border: none;
      border-radius: 30px;
      transition: 0.3s;
    }

    .btn-primary:hover {
      background: #f5f4fa;
      color: #3f3fff;
    }

    .btn-outline-light {
      border-radius: 30px;
    }

    /* 🔹 Payment History Table */
    .card-history {
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
      padding: 2rem;
    }

    table th {
      background-color: #6c63ff;
      color: #fff;
      text-transform: uppercase;
      font-size: 0.9rem;
    }

    table td {
      vertical-align: middle;
    }

    .badge {
      font-size: 0.85rem;
      border-radius: 20px;
    }

    #searchInput {
      border-radius: 30px;
      padding: 10px 15px;
      box-shadow: 0 0 6px rgba(0,0,0,0.1);
    }
  </style>
</head>

<body>
  <?php include 'public/include/header.php'; ?>

  <!-- ✅ Toastr Alerts -->
  <?php if (isset($_SESSION['success'])): ?>
    <script>
      document.addEventListener('DOMContentLoaded', () => {
        toastr.success("<?php echo addslashes($_SESSION['success']); ?>", "Success", {
          closeButton: true, progressBar: true, timeOut: 3000, positionClass: "toast-top-right"
        });
      });
    </script>
    <?php unset($_SESSION['success']); ?>
  <?php endif; ?>

  <?php if (isset($_SESSION['error'])): ?>
    <script>
      document.addEventListener('DOMContentLoaded', () => {
        toastr.error("<?php echo addslashes($_SESSION['error']); ?>", "Error", {
          closeButton: true, progressBar: true, timeOut: 3000, positionClass: "toast-top-right"
        });
      });
    </script>
    <?php unset($_SESSION['error']); ?>
  <?php endif; ?>

  <!-- 💳 Add Fund Form -->
  <div class="container mt-5">
    <div class="payment-form">
      <h3 class="text-center fw-bold mb-4">
        <i class="bi bi-wallet2 me-2"></i>Send Payment Request
      </h3>

      <div class="text-center mb-3">
        <a href="public/ez_automatic" class="btn btn-outline-light">
          <i class="bi bi-lightning-charge-fill me-1"></i>Ez Automatic Payment
        </a>
      </div>

      <form method="POST" id="paymentForm" enctype="multipart/form-data">
        <input type="hidden" name="name" value="<?= htmlspecialchars($_SESSION['name']); ?>">
        <input type="hidden" name="email" value="<?= htmlspecialchars($row2['email']); ?>">

        <div class="row g-3">
          <div class="col-md-6">
            <label for="whatsapp" class="form-label"><i class="bi bi-whatsapp me-1"></i> WhatsApp Number</label>
            <input type="tel" name="whatsapp" class="form-control" id="whatsapp" value="+94" required>
          </div>

          <div class="col-md-6">
            <label for="payment_method" class="form-label"><i class="bi bi-bank me-1"></i> Payment Method</label>
            <select class="form-select" name="payment_method" id="payment_method" onchange="updateDetails()" required>
              <option value="" disabled selected>Choose Method</option>
              <?php
              mysqli_data_seek($bank_result, 0);
              while ($row = mysqli_fetch_assoc($bank_result)) {
                echo '<option value="' . htmlspecialchars($row['payment_method']) . '">' .
                  htmlspecialchars($row['payment_method']) . '</option>';
              }
              ?>
            </select>
          </div>

          <div class="col-12" id="payment_details"></div>

          <div class="col-12">
            <label for="payment_image" class="form-label"><i class="bi bi-card-image me-1"></i> Upload Payment Screenshot</label>
            <input type="file" class="form-control" name="payment_image" accept="image/*" required>
          </div>

          <div class="col-12 text-center mt-4">
            <button type="submit" id="orderBtn" name="submit" class="btn btn-primary px-5 py-2">
              <i class="bi bi-cash-coin me-2"></i>Add Fund
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- 💰 Payment History -->
  <div class="container my-5">
    <div class="card-history">
      <h3 class="text-center mb-4 fw-bold text-primary">
        <i class="bi bi-receipt-cutoff me-2"></i>Payment History
      </h3>

      <input type="text" id="searchInput" class="form-control mb-3" placeholder=" Search by ID or Amount">

      <div class="table-responsive">
        <table class="table table-hover table-bordered align-middle text-center"   id="paymentTable">
          <thead>
            <tr>
              <th>ID</th>
              <th>Date</th>
              <th>Amount ~ <?= $currency_symbol ?></th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php while ($row = mysqli_fetch_assoc($result)) { 
              $action = strtolower(trim($row['action']));
              $badgeClass = match ($action) {
                'add fund request' => 'bg-warning text-dark',
                'refund' => 'bg-danger',
                'add' => 'bg-success',
                'request complete' => 'bg-info text-dark',
                default => 'bg-secondary'
              };
            ?>
              <tr>
                <td><?= $row['id']; ?></td>
                <td><?= htmlspecialchars($row['date']); ?></td>
               <td>
    <span class="badge bg-success">
        <?= number_format(convertFromtoLKR($row['amount'], $user_currency), 6) ?>
    </span>
</td>

                <td><span class="badge <?= $badgeClass ?>"><?= htmlspecialchars($row['action']); ?></span></td>
              </tr>
            <?php } ?>
            
            
            
              <!-- your php rows -->

 <tr id="noResultRow" style="display:none;">
  <td colspan="4" class="text-center fw-bold text-danger">
    <i class="bi bi-exclamation-triangle-fill fast-blink me-2"></i>
    No matching records found
  </td>
</tr>

          </tbody>
        </table>
      </div>
    </div>
  </div>

  <?php
  $details = [];
  $bank_query = "SELECT * FROM bank_details";
  $bank_result = mysqli_query($connect, $bank_query);
  while ($row = mysqli_fetch_assoc($bank_result)) {
    $method = $row['payment_method'];
    $account = $row['account_number'];
    $name = $row['account_name'];
    $branch = $row['branch'];
    $message = nl2br($row['message']);
    $details[$method] = "<div class='alert alert-info mt-3'><b>Account:</b> $account<br><b>Name:</b> $name<br><b>Branch:</b> $branch<br><br>$message</div>";
  }
  ?>

  <script>
    const bankDetails = <?= json_encode($details); ?>;
    function updateDetails() {
      const method = document.getElementById("payment_method").value;
      document.getElementById("payment_details").innerHTML = bankDetails[method] || '';
    }

   document.getElementById('searchInput').addEventListener('input', e => {
  const filter = e.target.value.toLowerCase();
  let matchFound = false;

  document.querySelectorAll("#paymentTable tbody tr").forEach(row => {
    
    // Skip "no result" row
    if (row.id === "noResultRow") return;

    if (row.innerText.toLowerCase().includes(filter)) {
      row.style.display = '';
      matchFound = true;
    } else {
      row.style.display = 'none';
    }
  });

  // Show or hide "No Result" message
  document.getElementById("noResultRow").style.display = matchFound ? 'none' : '';
});


    document.getElementById('paymentForm').addEventListener('submit', () => {
      const btn = document.getElementById('orderBtn');
      btn.disabled = true;
      btn.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Processing...';
    });
  </script>

  <?php include 'public/include/footer.php'; ?>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
