<?php
session_start();

// ✅ Check session value
if (isset($_SESSION['pages_redirect']) && $_SESSION['pages_redirect'] == "1") {
  // ✅ Unset the session first
  unset($_SESSION['pages_redirect']);

  // ✅ Redirect to homepage
  header("Location: ../../../../../../../../../"); // உங்கள் homepage path
  exit();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <title>404 - Page Not Found</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <!-- Bootstrap CSS -->
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css"
    rel="stylesheet" />
  <!-- Bootstrap Icons -->
  <link
    href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css"
    rel="stylesheet" />

  <style>
    body {
      background: linear-gradient(135deg, #5b2cff, #6a00ff, #4f46e5);
      background-size: 300% 300%;
      animation: bgShift 8s ease infinite;
      color: white;
      font-family: 'Montserrat', sans-serif;
    }


  </style>
</head>

<body class="d-flex flex-column justify-content-center align-items-center text-center vh-100 text-white">
  <div class="container">

    <div class="card-body">
     

      <h1 class="display-1 fw-bold">404</h1>
      <h4 class="mb-3 fw-semibold">Oops! Page not found</h4>
      <p class="lead mb-4">
        The page you are looking for doesn’t exist or has been moved.
      </p>

      <a
        href="../index"
        class="btn btn-success btn-lg rounded-pill px-4">
        <i class="bi bi-house-door-fill me-2"></i> Go Back Home
      </a>

    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>