<?php

require("config/db.php");
include 'public/session.php';
include 'public/include/titlemg.php';



$userId = $_SESSION['id'];

// Check if user is verified
$userId = $_SESSION['id'];

// Check if user is verified
$sql = "SELECT status FROM users2 WHERE id = ?";
$stmt = mysqli_prepare($connect, $sql);
mysqli_stmt_bind_param($stmt, "i", $userId);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$user = mysqli_fetch_assoc($result);

// If user found and status = 0 → redirect to verify email page
if ($user && $user['status'] == 1) {
    header("Location: index");
    exit();
}


// Get user email & username
$sql = "SELECT email, username FROM users2 WHERE id = ?";
$stmt = mysqli_prepare($connect, $sql);
mysqli_stmt_bind_param($stmt, "i", $userId);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$user = mysqli_fetch_assoc($result);
$email = $user['email'];
$username = $user['username'];

// Generate new token
$token = bin2hex(random_bytes(16));

// Save token to DB
$update = "UPDATE users2 SET verify_token = ? WHERE id = ?";
$updateStmt = mysqli_prepare($connect, $update);
mysqli_stmt_bind_param($updateStmt, "si", $token, $userId);
mysqli_stmt_execute($updateStmt);

// Domain auto-detect
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$domain = $_SERVER['HTTP_HOST'];

// Build verification link
$verifyLink = $protocol . $domain . "/public/verify?email=" . urlencode($email) . "&token=" . $token;

// Send mail when button clicked
if (isset($_POST['send'])) {
    $subject = "🔐 Verify Your Email";
    $message = "Hi $username,\n\nPlease click the link below to verify your email:\n$verifyLink\n\nThanks!";
    $headers = "From: no-reply@" . $domain;

    if (mail($email, $subject, $message, $headers)) {
        $status = "Verification link sent to your email!";
        $alertClass = "success";
    } else {
        $status = "Failed to send verification email.";
        $alertClass = "danger";
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Email Verification</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .box {
            max-width: 500px;
            margin: 100px auto;
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>

<body>
    <?php include 'public/include/header.php'; ?>

    <div class="container">
        <div class="box text-center">
            <h3 class="mb-4">Verify Your Email</h3>
            <?php if (isset($status)): ?>
                <div class="alert alert-<?= $alertClass ?>"><?= $status ?></div>
            <?php endif; ?>
            <form method="post">
                <input type="hidden" name="email" value="<?= $email ?>">
                <button type="submit" name="send" class="btn btn-primary">Send Verification Link</button>
            </form>
        </div>
    </div>
    <?php include 'public/include/whatsapp.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>