<?php
require("../config/db.php");

$email = $_GET['email'] ?? '';
$token = $_GET['token'] ?? '';

if (!$email || !$token) {
    die("Invalid link.");
}

// Check email & token match
$sql = "SELECT id, username FROM users2 WHERE email = ? AND verify_token = ?";
$stmt = mysqli_prepare($connect, $sql);
mysqli_stmt_bind_param($stmt, "ss", $email, $token);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if ($user = mysqli_fetch_assoc($result)) {
    $userId = $user['id'];
    $username = $user['username'];

    // Update status to 1 (verified)
    $update = "UPDATE users2 SET status = 1, verify_token = NULL WHERE id = ?";
    $updateStmt = mysqli_prepare($connect, $update);
    mysqli_stmt_bind_param($updateStmt, "i", $userId);
    mysqli_stmt_execute($updateStmt);

    $message = "🎉 Hi $username, your email has been successfully verified!";
    $alertClass = "success";
} else {
    $message = "❌ Invalid or expired verification link.";
    $alertClass = "danger";
}




?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Email Verified</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background: #f4f6f9;
            font-family: 'Segoe UI', sans-serif;
        }

        .verify-box {
            max-width: 600px;
            margin: 80px auto;
            background: white;
            padding: 40px 30px;
            border-radius: 15px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
        }

        .verify-box h2 {
            font-weight: 600;
        }
    </style>
</head>

<body>

    <div class="container">
        <div class="verify-box text-center">
            <h2 class="mb-4">🔐 Email Verification</h2>

            <!-- Dynamic message alert -->
            <div class="alert alert-<?= $alertClass ?>"><?= $message ?></div>

            <a href="../index" class="btn btn-success mt-3 px-4 py-2">Go to Login</a>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>