<?php
require("../config/db.php");
include 'include/titlemg.php';
session_start();

if (!isset($_SESSION['reset_email'])) {
    // Optional: Message காட்டணும்னா
    $_SESSION['error_message'] = "Session expired. Please try resetting again.";

    // Login page-க்கு redirect
    header("Location: ../login");
    exit();
}




if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    if ($new_password !== $confirm_password) {
        $error = "Passwords do not match!";
    } else {
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $email = $_SESSION['reset_email'];

        $sql = "UPDATE users2 SET password=? WHERE email=?";
        $stmt = mysqli_prepare($connect, $sql);
        mysqli_stmt_bind_param($stmt, "ss", $hashed_password, $email);
        mysqli_stmt_execute($stmt);

        // Clear session reset data
        unset($_SESSION['reset_token']);
        unset($_SESSION['reset_email']);

        $success = "Password has been reset successfully!";
    }
}
?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Reset Password</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>

<body class="container d-flex align-items-center justify-content-center" style="min-height: 100vh;">

    <div class="card shadow p-4" style="max-width: 400px; width: 100%;">
        <h3 class="text-center text-primary fw-bold mb-4">Reset Password</h3>

        <?php if (isset($error)) : ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= htmlspecialchars($error) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if (isset($success)) : ?>
            <div class="alert alert-success text-center">
                <p><?= htmlspecialchars($success) ?></p>
                <a href="login" class="btn btn-primary mt-3">Login</a>
            </div>
        <?php endif; ?>

        <form method="post" novalidate>
            <div class="mb-3">
                <label for="password" class="form-label fw-semibold">New Password</label>
                <input type="password" id="password" name="password" class="form-control form-control-lg" placeholder="Enter your new password" required />
            </div>
            <div class="mb-3">
                <label for="confirm_password" class="form-label fw-semibold">Confirm Password</label>
                <input type="password" id="confirm_password" name="confirm_password" class="form-control form-control-lg" placeholder="Re-enter your new password" required />
            </div>
            <button type="submit" name="submit" class="btn btn-success btn-lg w-100 fw-semibold">Verify</button>
        </form>

        <p class="text-center mt-3">
            <a href="login" class="text-decoration-none fw-semibold text-primary">&larr; Back to Login</a>
        </p>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <?php include 'include/whatsapp.php'; ?>

</body>

</html>