<?php
require("../config/db.php");
include 'include/titlemg.php';




session_start();

if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST['submit'])) {

    $username = $_POST['username'];
    $password = $_POST['password'];

    // Select id, email, password from users2 where username is provided
    $sql = "SELECT id, username, password FROM users2 WHERE username=? OR email=?";
    $stmt = mysqli_prepare($connect, $sql);
    mysqli_stmt_bind_param($stmt, "ss", $username, $username);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_store_result($stmt);

    if (mysqli_stmt_num_rows($stmt) > 0) {
        // Bind result variables correctly
        mysqli_stmt_bind_result($stmt, $id, $db_username, $hashed_password);
        mysqli_stmt_fetch($stmt);

        // Verify password with the hashed password
        if (password_verify($password, $hashed_password)) {
            // Store the user ID and username in session variables
            $_SESSION['id'] = $id;
            $_SESSION['name'] = $db_username;

            // 🔒 Set cookie to remember for 30 days
            setcookie("user_id", $id, time() + (30 * 24 * 60 * 60), "/");
            setcookie("username", $db_username, time() + (30 * 24 * 60 * 60), "/");

            $_SESSION['success'] = "Login successful! Welcome back, $username.";


            // Redirect to main page after successful login
            header("Location: ../index");
            exit;
        } else {
            $_SESSION['error'] = "Invalid username or password";
        }
    } else {
        $_SESSION['error'] = "Invalid username or password";
    }

    mysqli_stmt_close($stmt);
    mysqli_close($connect);
}


// Session இல்லைனா, Cookies இருக்கா-nu Check பண்ணுறது
if (!isset($_SESSION['id'])) {
    if (isset($_COOKIE['user_id']) && isset($_COOKIE['username'])) {
        // Cookies இருந்தா, session set பண்ணுறது
        $_SESSION['id'] = $_COOKIE['user_id'];
        $_SESSION['name'] = $_COOKIE['username'];
    }
}

if (isset($_SESSION['id'])) {
    header("Location: ../index");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <!-- seo -->
    <title><?= htmlspecialchars($sitename) ?> - Login | Access Your Account Securely</title>

    <meta name="description" content="Login to your <?= htmlspecialchars($sitename) ?> account to manage your social media marketing orders. Fast, secure, and reliable SMM panel in Sri Lanka.">
    <meta name="keywords" content="login, smm panel login, rootsmm login, rootmasterlk login, smm panel sri lanka, social media marketing, instagram followers, tiktok likes, youtube views">

    <meta name="robots" content="index, follow">
    <meta name="author" content="<?= htmlspecialchars($sitename) ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Open Graph / Facebook / Instagram -->
    <meta property="og:title" content="<?= htmlspecialchars($sitename) ?> - Login | Secure SMM Panel Access">
    <meta property="og:description" content="Sign in to <?= htmlspecialchars($sitename) ?> and manage your Instagram, TikTok, and YouTube orders easily. Trusted SMM panel in Sri Lanka.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://rootmasterlk.store/auth">
    <meta property="og:image" content="<?= htmlspecialchars($site_image) ?>">
    <meta property="og:site_name" content="<?= htmlspecialchars($sitename) ?>">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?= htmlspecialchars($sitename) ?> - Login">
    <meta name="twitter:description" content="Login to <?= htmlspecialchars($sitename) ?> and access your social media marketing dashboard. Fast & secure.">
    <meta name="twitter:image" content="<?= htmlspecialchars($site_image) ?>">

    <!-- Canonical -->
    <link rel="canonical" href="https://rootmasterlk.store/auth">

    <!-- JSON-LD Schema -->
    <script type="application/ld+json">
        {
            "@context": "https://schema.org",
            "@type": "WebPage",
            "name": "Login - <?= htmlspecialchars($sitename) ?>",
            "url": "https://rootmasterlk.store/auth",
            "description": "Login to your <?= htmlspecialchars($sitename) ?> account to manage Instagram, TikTok, YouTube, and Facebook social media services.",
            "publisher": {
                "@type": "Organization",
                "name": "<?= htmlspecialchars($sitename) ?>",
                "logo": "<?= htmlspecialchars($site_image) ?>"
            }
        }
    </script>
    <!-- seo -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://accounts.google.com/gsi/client" async defer></script>
    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <style>
        .card {
            border: none;
            border-radius: 1.5rem;
            overflow: hidden;
            box-shadow: 0 8px 40px rgba(0, 0, 0, 0.3);
        }

        .img-left {
            background: url('<?php echo $header_img; ?>') center center no-repeat;
            background-size: cover;
            min-height: 400px;
        }

        .login-form {
            padding: 2.5rem 2rem;
            background: linear-gradient(135deg, #6c63ff 0%, #3f3fff 100%);

        }

        .login-form h3 {
            font-weight: 700;
            color: #333;
        }

        .form-control {
            border-radius: 12px;
            box-shadow: none;
            border: 1px solid #ddd;
            padding: 10px 15px;
        }

        .form-control:focus {
            border-color: #6c63ff;
            box-shadow: 0 0 5px rgba(108, 99, 255, 0.5);
        }

        .btn-login {
            width: 100%;
            border-radius: 12px;
            padding: 12px;
            background: #6c63ff;
            border: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-login:hover {
            background: #574fd1;
        }

        .text-center a {
            color: #ffffffff;
            transition: 0.3s;
        }

        .text-center a:hover {
            text-decoration: underline;
            color: #ffffffff;
        }

        @media (max-width: 768px) {
            .img-left {
                display: none;
            }
        }

        /* Alert Styling */
        .alert {
            border-radius: 12px;
            font-size: 0.9rem;
        }
    </style>
</head>

<body>
    <?php include 'include/header.php'; ?>


    <script>
        function handleCredentialResponse(response) {
            fetch('include/google-login-backend.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        id_token: response.credential
                    })
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {

                        window.location.href = data.redirect;
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Login Failed',
                            text:  data.message || 'Google login failed. Please try again!',
                            confirmButtonText: 'OK'
                        });
                    }
                })
                .catch(err => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Login Failed',
                        text: err.message || 'Google login failed. Please try again!',
                        confirmButtonText: 'OK'
                    });
                });
        }
    </script>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10 py-4">
                <div class="card shadow-lg border-0 rounded-3">
                    <div class="row g-0">
                        <div class="col-md-6 img-left d-none d-md-block"></div>
                        <div class="col-md-6 login-form text-light fw-old">
                            <h3 class="text-center mb-4 text-light">Welcome to <span class="text-info"><?php echo $main_name ?></span></h3>

                            <?php
                            if (isset($_SESSION['success'])) {
                                echo '<div class="alert alert-success text-center" role="alert">' . $_SESSION["success"] . '</div>';
                                unset($_SESSION["success"]);
                            } elseif (isset($_SESSION['error'])) {
                                echo '<div class="alert alert-danger text-center" role="alert">' . $_SESSION["error"] . '</div>';
                                unset($_SESSION["error"]);
                            }
                            ?>

                            <form action="" method="POST">
                                <div class="mb-3">
                                    <label class="form-label">Username or Email</label>
                                    <input type="text" class="form-control" name="username" id="username" placeholder="Enter your username or email" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Password</label>
                                    <input type="password" class="form-control" name="password" id="password" placeholder="Enter your password" required>
                                </div>







                                <button type="submit" name="submit" id="submit" class="btn btn-primary btn-login">Login</button>

                                <!--  Google Login JS SDK -->
                                <?php if ($google_login == 1 && !empty($google_client_id)) : ?>

                                    <div id="g_id_onload"
                                        data-client_id="<?= htmlspecialchars($google_client_id) ?>"
                                        data-callback="handleCredentialResponse"
                                        data-auto_prompt="false">
                                    </div>

                                    <div class="g_id_signin mt-2 fw-bold d-flex justify-content-center"
                                        data-type="standard"
                                        data-size="large"
                                        data-theme="filled_white"
                                        data-text="signin_with"
                                        data-shape="rectangular"
                                        data-logo_alignment="left">
                                    </div>


                                <?php endif ?>

                                <div class="text-center mt-3">
                                    <a href="register" class="text-decoration-none">Don't have an account? Register</a><br>
                                    <a href="forgot_password" class="text-decoration-none">Forgot password?</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include 'include/whatsapp.php'; ?>
    <?php include 'include/footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>