<?php
// 🔥 DB connect
include '../../config/db.php'; // $connect variable இருக்கணும்

// 🔥 Currency API key
include '../../admin/include/currency_api.php'; 
$api_key = $cransi_api_key;
$base_currency = "USD";

// 🔥 API URL
$api_url = "https://v6.exchangerate-api.com/v6/$api_key/latest/$base_currency";
$response = file_get_contents($api_url);
if ($response === false) {
    die("API call failed!");
}

$data = json_decode($response, true);

// 🔥 conversion_rates இருக்கா என்று check
if (!isset($data['conversion_rates'])) {
    die("Invalid API response!");
}

$rates = $data['conversion_rates'];

// 🔥 loop பண்ணி insert/update
foreach ($rates as $currency => $rate) {
    // API says: 1 USD = $rate <currency>
    // We need: 1 <currency> = ? USD
    $rate_to_usd = 0;
    if ($rate != 0) {
        $rate_to_usd = 1 / $rate; // ✅ main fix here
    }

    $currency_code = mysqli_real_escape_string($connect, $currency);
    $rate_to_usd   = mysqli_real_escape_string($connect, $rate_to_usd);

    $sql = "
        INSERT INTO currency_rates (currency_code, rate_to_usd, updated_at)
        VALUES ('$currency_code', '$rate_to_usd', NOW())
        ON DUPLICATE KEY UPDATE
            rate_to_usd = VALUES(rate_to_usd),
            updated_at = NOW()
    ";
    mysqli_query($connect, $sql);
}

header("Location: ../../admin/dashboard");
exit;
?>
