<?php

require('config/db.php'); // db
include 'public/session.php'; // Check login session
include 'public/include/titlemg.php'; // titel
include 'public/include/email_verify.php'; // email vrifi

?>




<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
   


<title>Mass Order | <?= htmlspecialchars($sitename) ?> | Bulk SMM Orders for Instagram, TikTok & YouTube</title>

<meta name="description" content="Use the Mass Order feature on <?= htmlspecialchars($sitename) ?> to place bulk social media marketing orders. Buy Instagram followers, TikTok likes, YouTube views & more — fast and affordable.">
<meta name="keywords" content="mass order, bulk orders, smm panel sri lanka, instagram followers, tiktok likes, youtube views, facebook engagement, social media marketing, rootsmm, rootmasterlk">

<meta name="robots" content="noindex, follow">
<meta name="author" content="<?= htmlspecialchars($sitename) ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- Open Graph / Facebook / Instagram -->
<meta property="og:title" content="Mass Order | <?= htmlspecialchars($sitename) ?>">
<meta property="og:description" content="Place multiple SMM orders at once with <?= htmlspecialchars($sitename) ?>. Perfect for agencies managing bulk Instagram, TikTok, and YouTube services.">
<meta property="og:type" content="website">
<meta property="og:url" content="https://rootmasterlk.store/mass-order">
<meta property="og:image" content="<?= htmlspecialchars($site_image) ?>">
<meta property="og:site_name" content="<?= htmlspecialchars($sitename) ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Mass Order | <?= htmlspecialchars($sitename) ?>">
<meta name="twitter:description" content="Easily place bulk social media orders on <?= htmlspecialchars($sitename) ?> — the best SMM panel for Instagram, TikTok, YouTube & Facebook.">
<meta name="twitter:image" content="<?= htmlspecialchars($site_image) ?>">

<!-- Canonical -->
<link rel="canonical" href="https://rootmasterlk.store/mass-order">

<!-- JSON-LD Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "name": "Mass Order - <?= htmlspecialchars($sitename) ?>",
  "url": "https://rootmasterlk.store/mass-order",
  "description": "Place bulk SMM orders using the <?= htmlspecialchars($sitename) ?> Mass Order tool. Buy multiple Instagram, TikTok, and YouTube services in one go.",
  "publisher": {
    "@type": "Organization",
    "name": "<?= htmlspecialchars($sitename) ?>",
    "logo": "<?= htmlspecialchars($site_image) ?>"
  }
}
</script>




    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">
    <?php include 'public/include/header.php'; ?>
    <div class="container py-5 " >
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="card shadow rounded-4 bg-custome">
                    <div class="card-body p-4">
                        <h4 class="mb-4 text-center fw-bold"> Mass Order Form</h4>

                        <?php if (!empty($_SESSION['success'])): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?= $_SESSION['success'];
                                unset($_SESSION['success']); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($_SESSION['error'])): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?= $_SESSION['error'];
                                unset($_SESSION['error']); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        <?php endif; ?>



                        <form method="post" action="api/mass_order" onsubmit="disableButton(this)">
                            <div class="mb-3">
                                <label for="mass_order" class="form-label fw-bold">Mass Orders</label>
                                <textarea name="mass_order" id="mass_order" class="form-control" rows="8" placeholder="Ex: 1|1000|https://link.com"></textarea>
                                <div class="form-text text-light">Format: <code class="fw-bold text-light">service_id|quantity|link</code> – one per line</div>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary btn-lg" id="submitBtn"> Submit Orders</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function disableButton(form) {
            const btn = document.getElementById('submitBtn');
            btn.disabled = true;
            btn.innerHTML = ' Processing...';
        }
    </script>

    <?php include 'public/include/whatsapp.php'; ?>
    <?php include 'public/include/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>