<?php
// db and session
include 'config/db.php';
include 'public/session.php';

include 'public/include/email_verify.php';
$name = $_SESSION['name'];










// Get user ID
$getUser = mysqli_query($connect, "SELECT id, balance FROM users2 WHERE username='$name'");
$user = mysqli_fetch_assoc($getUser);
$user_id = $user['id'];
$balance = $user['balance'];

// Get hidden categories for this user
$hidden_cat_ids = [];
$hidden_query = mysqli_query($connect, "SELECT category_id FROM hide_category WHERE user_id = '$user_id'");
while ($row = mysqli_fetch_assoc($hidden_query)) {
  $hidden_cat_ids[] = $row['category_id'];
}

// Prepare exclusion string for SQL
$hidden_cat_ids_str = implode(',', $hidden_cat_ids);

// Now fetch all unique categories, excluding hidden ones
$categories = [];
$cat_sql = "
  SELECT DISTINCT c.id, c.category_name AS name, c.order_id,c.in_order
  FROM services s 
  JOIN category c ON s.category_id = c.id 
  WHERE s.status = 'active' 
";

// Exclude hidden categories
if (!empty($hidden_cat_ids)) {
  $cat_sql .= " AND c.id NOT IN ($hidden_cat_ids_str)";
}

$cat_sql .= "
  ORDER BY 
    CAST(c.in_order AS UNSIGNED) ASC
";


$cat_q = mysqli_query($connect, $cat_sql);
while ($row = mysqli_fetch_assoc($cat_q)) {
  $categories[] = $row;
}








$query = $connect->query("SELECT id FROM orders ORDER BY id DESC LIMIT 1");
$lastOrder = $query->fetch_assoc();
$lastOrderId = $lastOrder['id'];

?>




<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <!-- seo -->
  <title>Place Order | Buy Instagram, TikTok, YouTube & Facebook Services | <?= htmlspecialchars($sitename) ?></title>

  <meta name="description" content="Easily place orders for Instagram followers, TikTok likes, YouTube views, and Facebook page likes with <?= htmlspecialchars($sitename) ?> — Sri Lanka’s #1 trusted SMM panel.">
  <meta name="keywords" content="place order, smm panel sri lanka, buy instagram followers, tiktok likes, youtube views, facebook likes, social media orders, rootsmm, rootmasterlk">

  <meta name="robots" content="index, follow">
  <meta name="author" content="<?= htmlspecialchars($sitename) ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Open Graph (Facebook, Instagram) -->
  <meta property="og:title" content="Place Order | <?= htmlspecialchars($sitename) ?>">
  <meta property="og:description" content="Quickly place your social media marketing orders — Instagram, TikTok, YouTube & more with <?= htmlspecialchars($sitename) ?>. Fast delivery and real results.">
  <meta property="og:type" content="website">
  <meta property="og:url" content="https://rootmasterlk.store/order">
  <meta property="og:image" content="<?= htmlspecialchars($site_image) ?>">
  <meta property="og:site_name" content="<?= htmlspecialchars($sitename) ?>">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Place Order | <?= htmlspecialchars($sitename) ?>">
  <meta name="twitter:description" content="Buy social media services — Instagram, TikTok, YouTube, Facebook — from <?= htmlspecialchars($sitename) ?>, Sri Lanka’s best SMM panel.">
  <meta name="twitter:image" content="<?= htmlspecialchars($site_image) ?>">

  <!-- Canonical -->
  <link rel="canonical" href="https://rootmasterlk.store/order">

  <!-- JSON-LD Schema -->
  <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "WebPage",
      "name": "Place Order | <?= htmlspecialchars($sitename) ?>",
      "url": "https://rootmasterlk.store/order",
      "description": "Place your social media marketing orders on <?= htmlspecialchars($sitename) ?> — fast, affordable SMM panel for Instagram, TikTok, and YouTube services.",
      "publisher": {
        "@type": "Organization",
        "name": "<?= htmlspecialchars($sitename) ?>",
        "logo": "<?= htmlspecialchars($site_image) ?>"
      }
    }
  </script>
  <!-- seo -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <!-- main script j query -->
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <!-- HEAD tag உள்ளே இதை paste பண்ணு -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <!-- Select2 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

  <!-- Select2 JS -->
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


  <?php include 'public/include/titlemg.php'; ?>




</head>

<body class="bg-light">
  <!-- hader -->
  <?php include 'public/include/header.php'; ?>



  <!-- sesen message start -->

  <?php
  // session messages


  if (isset($_SESSION['success_order'])): ?>
    <script>
      Swal.fire({
        icon: 'success',
        title: 'Success!',
        html: `<pre style="text-align:left"><?= $_SESSION['success_order']; ?></pre>`
      });
    </script>
    <?php unset($_SESSION['success_order']); ?>
  <?php endif; ?>



  <?php if (isset($_SESSION['error'])): ?>
    <script>
      Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '<?= addslashes($_SESSION['error']); ?>'
      });
    </script>
    <?php unset($_SESSION['error']); ?>
  <?php endif; ?>

  <?php if (isset($_SESSION['success'])): ?>
    <script>
      Swal.fire({
        icon: 'success',
        title: 'Success',
        text: '<?= addslashes($_SESSION['success']); ?>'
      });
    </script>
    <?php unset($_SESSION['success']); ?>
  <?php endif; ?>

  <!-- sesen messagfe end -->



  <div class="container my-3  ">




    <div class="container mt-5 mb-4">
      <div class="row g-4">

        <!-- 🟢 Total Orders -->
        <div class="col-md-6 col-lg-6">
          <div class="info-card p-4 d-flex justify-content-between align-items-center border-0 shadow-lg rounded-4"
            style="background: linear-gradient(135deg, #42e695, #3bb2b8); color: white;">
            <div class="d-flex align-items-center gap-3">
              <div class="p-3 bg-white bg-opacity-25 rounded-circle">
                <img src="https://img.icons8.com/ios-filled/50/ffffff/delivery--v1.png" width="40" height="40" alt="Orders">
              </div>
              <div>
                <h6 class="fw-semibold mb-1 text-light opacity-75">Total Orders</h6>
                <h4 class="fw-bold mb-0 text-white"><?= htmlspecialchars($lastOrderId) ?></h4>
              </div>
            </div>
            <!--<i class="bi bi-bag-check-fill fs-1 opacity-75"></i>-->
          </div>
        </div>

        <!-- 💰 Balance -->
        <div class="col-md-6 col-lg-6">
          <div class="info-card p-4 d-flex justify-content-between align-items-center border-0 shadow-lg rounded-4"
            style="background: linear-gradient(135deg, #667eea, #764ba2); color: white;">
            <div class="d-flex align-items-center gap-3">
              <div class="p-3 bg-white bg-opacity-25 rounded-circle">
                <img src="https://img.icons8.com/ios-filled/50/ffffff/money--v1.png" width="40" height="40" alt="Balance">
              </div>
              <div>
                <h6 class="fw-semibold mb-1 text-light opacity-75">Available Balance</h6>
               <h4 class="fw-bold mb-0 text-white">
    

     <?= $currency_symbol ?> ~ 
<span class="amount-value">
    <?= number_format(convertFromtoLKR($balance, $user_currency), 3) ?>
</span>



  
</h4>

              </div>
            </div>
            <!--<i class="bi bi-cash-coin fs-1 opacity-75"></i>-->
          </div>
        </div>

      </div>
    </div>
    <style>
      .info-card {
        transition: all 0.3s ease-in-out;
      }

      .info-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
      }

      @media (max-width: 576px) {
        .info-card {
          text-align: center;
          flex-direction: column;
          gap: 10px;
        }
      }
    </style>









    <!-- ctacary filter consept start  -->




    <!-- 🎯 Category Filter Section -->
    <div class="container my-4">
      <div class="card shadow-lg border-0 rounded-4">
        <div class="card-body text-center bg-light">
          <h5 class="fw-bold text-primary mb-4">
            <i class="bi bi-grid-3x3-gap-fill me-1"></i> Select Platform
          </h5>

          <div class="d-flex flex-wrap justify-content-center gap-3 p-2" id="category-buttons">
            <button class="btn btn-cat bg-secondary text-white" onclick="filterStarted('everything', this)">
              <i class="fas fa-layer-group"></i> <span>All</span>
            </button>

            <button class="btn btn-cat bg-danger text-white" onclick="filterStarted('youtube', this)">
              <i class="fab fa-youtube"></i> <span>YouTube</span>
            </button>

            <button class="btn btn-cat bg-dark text-white" onclick="filterStarted('tiktok', this)">
              <i class="fab fa-tiktok"></i> <span>TikTok</span>
            </button>

            <button class="btn btn-cat bg-pink text-white" onclick="filterStarted('instagram', this)">
              <i class="fab fa-instagram"></i> <span>Instagram</span>
            </button>

            <button class="btn btn-cat bg-primary text-white" onclick="filterStarted('facebook', this)">
              <i class="fab fa-facebook-f"></i> <span>Facebook</span>
            </button>

            <button class="btn btn-cat bg-success text-white" onclick="filterStarted('whatsapp', this)">
              <i class="fab fa-whatsapp"></i> <span>WhatsApp</span>
            </button>

            <button class="btn btn-cat bg-warning text-dark" onclick="filterStarted('google', this)">
              <i class="fab fa-google"></i> <span>Google</span>
            </button>

            <button class="btn btn-cat bg-danger text-white" onclick="filterStarted('freefire', this)">
              <i class="fas fa-fire"></i> <span>Free Fire</span>
            </button>
          </div>
        </div>
      </div>
    </div>








    <style>
      /* 🔘 Button base */
      .btn-cat {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        font-weight: 600;
        border-radius: 50px;
        padding: 10px 20px;
        border: none;
        transition: all 0.3s ease;
        box-shadow: 0 3px 8px rgba(0, 0, 0, 0.15);
      }

      /* 🪄 Hover animation */
      .btn-cat:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 15px rgba(0, 0, 0, 0.25);
        filter: brightness(1.1);
      }

      /* 🌈 Active button effect */
      .btn-cat.active {
        border: 2px solid white;
        outline: 3px solid #00ff88;
        transform: scale(1.05);
      }

      /* 💖 Custom pink */
      .bg-pink {
        background-color: #e83e8c !important;
      }

      /* 📱 Mobile Scroll */
      @media (max-width: 576px) {
        #category-buttons {
          flex-wrap: nowrap;
          overflow-x: auto;
          scrollbar-width: none;
          -webkit-overflow-scrolling: touch;
          padding-bottom: 8px;
        }

        #category-buttons::-webkit-scrollbar {
          display: none;
        }

        .btn-cat {
          flex: 0 0 auto;
          width: 60px;
          height: 60px;
          border-radius: 15%;
          font-size: 22px;
          box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }

        .btn-cat span {
          display: none;
        }
      }
    </style>


    <style>
      /* 🎯 Service ID Badge */
      .service-badge {
        background: linear-gradient(135deg, #4b6cff, #2b1bff);
        color: #fff;
        padding: 3px 8px;
        border-radius: 10px;
        font-size: 11px;
        margin-left: 6px;
        font-weight: 600;
        letter-spacing: 0.3px;
        box-shadow: 0 2px 6px rgba(0, 0, 255, 0.25);
        transition: all 0.3s ease-in-out;
      }

      /* 🧠 Search Result Container */
      #searchResult {
        position: absolute;
        top: calc(100% + 6px);
        left: 0;
        right: 0;
        background: #ffffff;
        border-radius: 12px;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        border: 1px solid rgba(0, 0, 0, 0.05);
        overflow-y: auto;
        max-height: 250px;
        z-index: 1000;
        transition: all 0.2s ease-in-out;
        scrollbar-width: thin;
        scrollbar-color: #6c63ff transparent;
      }

      /* Hide initially */
      #searchResult:empty {
        display: none;
      }

      /* 🌈 Scrollbar Styling */
      #searchResult::-webkit-scrollbar {
        width: 6px;
      }

      #searchResult::-webkit-scrollbar-thumb {
        background: linear-gradient(180deg, #6c63ff, #3a3aff);
        border-radius: 10px;
      }

      /* 🔍 Search Result Box */
      #searchResult {
        border-radius: 10px;
        background: #fff;
        overflow-y: auto;
        max-height: 250px;
      }

      .result-item {
        padding: 10px;
        cursor: pointer;
        transition: 0.3s;
      }

      .result-item:hover {
        background: #6c63ff;
        color: #fff;
      }

      @media (max-width: 576px) {
        .card h3 {
          font-size: 1.3rem;
        }
      }

      /* 🧩 Hover Effect */
      .result-item:hover {
        background: linear-gradient(135deg, #4b6cff, #3a3aff);
        color: #fff;
        border-radius: 8px;

      }

      /* ✨ Smooth Fade Animation */
      #searchResult {
        animation: fadeIn 0.2s ease-in-out;
      }

      @keyframes fadeIn {
        from {
          opacity: 0;
          transform: translateY(-5px);
        }

        to {
          opacity: 1;
          transform: translateY(0);
        }
      }
    </style>

    <style>
      .select2-container--default .select2-selection--multiple .select2-selection__choice,
      .select2-container--default .select2-selection--single .select2-selection__rendered {

        color: #000000ff !important;
        /* white text */
        border: none !important;
        border-radius: 6px !important;
        font-weight: 500;
        transition: 0.3s ease;
      }


      /* 🔹 When option is selected (active value inside dropdown) */
      .select2-container--default .select2-results__option[aria-selected="true"] {
        background-color: #ffffffff !important;
        /* black background */
        color: #fff !important;
        /* white text */
      }

      /* 🔹 General Select2 Container */
      .select2-container {
        
        font-family: "Poppins", sans-serif;
      }

      /* 🔹 Single Select Box */
      .select2-container--default .select2-selection--single {
        background-color: #f8f9fa;
        border: 1px solid #ced4da;
        border-radius: 0.5rem;
        height: 48px;
        display: flex;
        align-items: center;
        transition: all 0.2s ease-in-out;
        box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.05);
      }

      /* 🔹 Selected text */
      .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 46px;
        color: #000000ff;
        padding-left: 12px;
        font-weight: 500;
      }

      /* 🔹 Arrow Icon */
      .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 100%;
        right: 10px;
      }

      /* 🔹 Focused Effect */
      .select2-container--default.select2-container--focus .select2-selection--single {
        border-color: #86b7fe;
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
      }

      /* 🔹 Dropdown Panel */
      .select2-dropdown {
        border-radius: 10px;
        border: 1px solid #dee2e6;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        z-index: 2000;
      }

      /* 🔹 Dropdown Option */
      .select2-results__option {
        padding: 10px 12px;
        font-size: 15px;
        color: #000000ff;
        cursor: pointer;
        transition: background 0.2s ease-in-out;
      }

      /* 🔹 Hovered Option */
      .select2-results__option--highlighted {
        background: linear-gradient(135deg, #4b6cff, #2b1bff);
        color: #fff;
      }

      /* 🔹 Disabled Option */
      .select2-results__option[aria-disabled="true"] {
        color: #000000ff;
        background-color: #f8f9fa;
      }

      /* 🔹 Dark Mode (optional – auto adapt if .bg-custome used) */
      .bg-custome .select2-container--default .select2-selection--single {
        background-color: #222;
        border-color: #444;
        color: #fff;
      }

      .bg-custome .select2-container--default .select2-selection--single .select2-selection__rendered {
        color: #e9ecef;
      }

      .bg-custome .select2-dropdown {
        background: #000000ff;
        border-color: #555;
      }

      .bg-custome .select2-results__option {
        color: #000000ff;
      }

      .bg-custome .select2-results__option--highlighted {
        background: linear-gradient(135deg, #6c63ff, #3f32ff);
        color: white;
      }
    </style>





    <!-- order form -->

    <div class="card shadow-lg p-4 rounded-4 bg-custome border-0 mt-4">
      <h3 class="text-center mb-4 fw-bold text-light border-bottom border-light pb-2 mx-auto" style="max-width: 320px;">
        <i class="bi bi-bag-check-fill me-2"></i> Place New Order
      </h3>


      <div class="mb-3" style="position: relative;">
        <label for="serviceSearch" class="form-label fw-bold text-light">
          <i class="fas fa-search me-2"></i> Search Service
        </label>

        <div class="input-group shadow-sm">
          <span class="input-group-text bg-white border-0 rounded-start">
            <i class="bi bi-search text-primary fs-5"></i>
          </span>
          <input type="text" id="serviceSearch" class="form-control border-0 shadow-sm py-2"
            placeholder="Type to search services..." autocomplete="off">
        </div>

        <div id="searchResult"></div>
      </div>



      <!-- 🧾 Order Form -->
      <form method="POST" action="api/submit_order.php" id="orderForm" onsubmit="disableButton(this)">
        <div class="row g-3">

          <!-- Category -->
          <div class="col-md-6">
            <label for="app" class="form-label text-light fw-semibold">Select Category</label>
            <select name="app" id="app" class="form-select shadow-sm select2" required>
              <option value="">-- Choose Category --</option>
              <?php foreach ($categories as $category): ?>
                <option value="<?= $category['id'] ?>"><?= ucfirst($category['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <!-- Service -->
          <div class="col-md-6">
            <label for="service_id" class="form-label text-light fw-semibold">Select Service</label>
            <select name="service_id" id="service_id" class="form-select shadow-sm select2" required>
              <option value="">-- Choose Service --</option>
            </select>
          </div>

          <!-- Description -->
          <div class="col-12" id="descriptionBox" style="display:none;">
            <div class="p-3 border border-light rounded bg-opacity-25 bg-dark">
              <label class="form-label text-warning fw-semibold">
                <i class="bi bi-info-circle-fill me-1"></i> Service Description
              </label>
              <p id="service_description" class="mb-0 text-light small"></p>
            </div>
          </div>

          <!-- Quantity -->
          <div class="col-md-6">
            <label for="quantity" class="form-label text-light fw-semibold">Quantity</label>
            <input type="number" name="quantity" id="quantity"
              class="form-control shadow-sm" placeholder="Enter quantity" min="1" required>
            <small id="qty-range" class="text-light opacity-75"></small>
          </div>

          <!-- Link -->
          <div class="col-md-6">
            <label for="link" class="form-label text-light fw-semibold">Link</label>
            <input type="text" name="link" class="form-control shadow-sm"
              placeholder="https://example.com" required>
          </div>

          <!-- Comments -->
          <div class="col-md-6" id="commentBox" style="display:none;">
            <label for="comments" class="form-label text-light fw-semibold">Comments</label>
            <textarea name="comments" id="comments" class="form-control shadow-sm"
              rows="3" placeholder="Add your comments..."></textarea>
          </div>

          <!-- Total Price -->
          <div class="col-md-6">
            <label for="price" class="form-label text-light fw-semibold">Total Price ~ <?= $currency_symbol ?></label>
            
            
            <input  name="price" id="price" type="hidden" >
              
              
              <input type="text" name="converted_price_user_currency" id="converted_price_user_currency" 
              class="form-control shadow-sm bg-light fw-bold"
              placeholder="<?= $user_currency ?> 0.00" readonly>
          </div>

          <!-- Submit -->
          <div class="col-12 mt-3">
            <button type="submit" id="submitBtn"
              class="btn w-100 py-2 fs-5 fw-bold text-white custom-order-btn">
              <i class="bi bi-cart-check-fill me-2"></i> Submit Order
            </button>
          </div>
        </div>
      </form>
    </div>





  </div>






  <?php include 'script/index_page_script.php'; ?>

  <?php include 'public/include/pop_up.php'; ?>

  <?php include 'public/include/whatsapp.php'; ?>
  <?php include 'public/include/footer.php'; ?>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

<style>
  .bg-custome {
    background: linear-gradient(135deg, #6c63ff, #3f3fff);
  }

  /* 🧾 Input and select hover effect */
  .form-control:focus,
  .form-select:focus {
    border-color: #00ffcc;
    box-shadow: 0 0 0 0.25rem rgba(0, 255, 200, 0.25);
  }

  /* 💎 Submit button */
  .custom-order-btn {
    background: linear-gradient(135deg, #28a745, #1e7e34);
    border: none;
    border-radius: 12px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
  }

  .custom-order-btn:hover {
    background: linear-gradient(135deg, #1e7e34, #28a745);
    transform: translateY(-2px);
  }
</style>

</html>