<?php

if (!function_exists('convertFromtoLKR')) {
function convertFromtoLKR($lkr_amount, $to_currency)
{
  global $connect;  // FIX

    $to_currency = strtoupper(trim($to_currency));

    // If target = LKR → return same amount
    if ($to_currency == "LKR") {
        return $lkr_amount;
    }

    // Get LKR → USD rate
    $sql1 = "SELECT rate_to_usd FROM currency_rates WHERE currency_code = 'LKR' LIMIT 1";
    $res1 = mysqli_query($connect, $sql1);

    if (!$res1 || mysqli_num_rows($res1) == 0) {
        return $lkr_amount;
    }

    $row1 = mysqli_fetch_assoc($res1);
    $lkr_to_usd = (float)$row1['rate_to_usd'];

    // STEP 1: LKR → USD
    $usd_amount = $lkr_amount * $lkr_to_usd;

    // STEP 2: USD → target currency
    $sql2 = "SELECT rate_to_usd FROM currency_rates WHERE currency_code = '$to_currency' LIMIT 1";
    $res2 = mysqli_query($connect, $sql2);

    if (!$res2 || mysqli_num_rows($res2) == 0) {
        return $usd_amount; // fallback return USD
    }

    $row2 = mysqli_fetch_assoc($res2);
    $currency_to_usd = (float)$row2['rate_to_usd'];

    // USD → target currency
    $final_amount = $usd_amount / $currency_to_usd;

    return $final_amount;
}
}
