<?php

include '../config/db.php';
include '../public/session.php';
include 'api_class.php';

$name = $_SESSION['name'];
$service_id = intval($_POST['service_id']);
$link = trim($_POST['link']);
$price = floatval($_POST['price']);
$comments = isset($_POST['comments']) ? trim($_POST['comments']) : "";

$using_comments = !empty($comments);


// Get  sarvice name

$service_name = mysqli_query($connect, "SELECT service_name FROM services  WHERE id=$service_id");
$service_name = mysqli_fetch_assoc($service_name);

// get provider_id
$provider_data = mysqli_query($connect, "SELECT provider_id FROM services WHERE id=$service_id");
$provider_data = mysqli_fetch_assoc($provider_data);
$provider_id = $provider_data['provider_id'];  // need to get provider_id


// 🔎 Get service
$service_q = mysqli_query($connect, "SELECT * FROM services WHERE id=$service_id AND status='active'");
$service = mysqli_fetch_assoc($service_q);
if (!$service) {
    $_SESSION['error'] = " Invalid or inactive service.";
    header("Location: ../index");
    exit;
}

$api_service_id = $service['api_order_id'];
if (!$api_service_id) {
    $_SESSION['error'] = " API not configured.";
    header("Location: ../index");
    exit;
}

// 🔎 Get balance
$user_q = mysqli_query($connect, "SELECT balance FROM users2 WHERE username='$name'");
$user = mysqli_fetch_assoc($user_q);
$balance = $user['balance'];

// 👇 Quantity & comments check
if ($using_comments) {
    $comment_lines = array_filter(array_map('trim', explode("\n", $comments)));
    $comments = implode("\n", $comment_lines);
    $quantity = count($comment_lines);

    if ($quantity === 0) {
        $_SESSION['error'] = " Please enter valid comments.";
        header("Location: ../index");
        exit;
    }
} else {
    $quantity = isset($_POST['quantity']) ? intval($_POST['quantity']) : 0;
    if ($quantity <= 0) {
        $_SESSION['error'] = " Invalid quantity.";
        header("Location: ../index");
        exit;
    }
}

// 💰 Price check
if ($price > $balance) {
    $_SESSION['error'] = " Insufficient balance.";
    header("Location: ../index");
    exit;
}
$new_balance = $balance - $price;
mysqli_query($connect, "UPDATE users2 SET balance=$new_balance WHERE username='$name'");
// ✅ Step 1: Order insert first with 'initiated' status
$insert_q = mysqli_query($connect, "INSERT INTO orders (username, service_id, quantity, link, price, status, sarvice_name)
    VALUES ('$name', $service_id, $quantity, '$link', $price, 'initiated' , '$service_name[service_name]')");
$order_db_id = mysqli_insert_id($connect);

if (!$insert_q) {
    $_SESSION['error'] = " Failed to place order.";
    header("Location: ../index");
    exit;
}

// ✅ Session message for user (can show before API)
$_SESSION['success_order'] = "✅ Order Placed Successfully!\n"
    . "🔗 Link: $link\n"
    . "📦 Quantity: $quantity\n"
    . "💰 Price: $price\n"
    . "🛠️ Service: {$service_name['service_name']}\n"
    . "🆔 Order ID: $order_db_id";


// ✅ Immediately redirect user
header("Location: ../index");

// ✅ Force flush to send response to user immediately
ignore_user_abort(true); // Continue if user closes browser
ob_start();
echo "Redirecting...";
header('Connection: close');
header('Content-Length: ' . ob_get_length());
ob_end_flush();
flush();

// 🌐 Step 2: API Call
$provider_q = mysqli_query($connect, "SELECT api_key, api_url FROM providers WHERE id = $provider_id");
$provider = mysqli_fetch_assoc($provider_q);
$api_key = $provider['api_key'];
$api_url = $provider['api_url'];

$api = new Api($api_key, $api_url);


$data = [
    'service' => $api_service_id,
    'link' => $link,
    'quantity' => $quantity
];
if ($using_comments) {
    $data['comments'] = $comments;
}

$api_response = $api->order($data);

// ✅ Step 3: Check API Response
if (isset($api_response->order) && is_numeric($api_response->order)) {
    $api_order_id = $api_response->order;

    // 👉 JSON encode the full response to save in DB
    $full_response = mysqli_real_escape_string($connect, json_encode($api_response));

    // ✅ Update DB with api_order_id, status, and api_response
    mysqli_query($connect, "
        UPDATE orders 
        SET api_order_id='$api_order_id', status='pending', api_response='$full_response' 
        WHERE id=$order_db_id
    ");

    // 💰 Deduct balance (if you add here later)

} else {
    // 👉 API failed, also store the failed response for debugging
    $failed_response = mysqli_real_escape_string($connect, json_encode($api_response));

    // ❌ Update status and store failed response
    mysqli_query($connect, "
        UPDATE orders 
        SET status='failed', api_response='$failed_response' 
        WHERE id=$order_db_id
    ");
}



exit;
