<?php
include '../config/db.php';
include 'api_class.php';


session_start();

// Step 1: Get selected orders only if POST has selected_ids
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['selected_ids'])) {
    $selected_ids = array_map('intval', $_POST['selected_ids']);
    $ids_str = implode(",", $selected_ids);

    // slct selected get status based cheak
    $failed_orders_q = mysqli_query($connect, "
        SELECT orders.*, services.api_order_id, services.provider_id 
        FROM orders 
        JOIN services ON orders.service_id = services.id 
        WHERE orders.id IN ($ids_str) 
        AND (orders.status = 'failed' OR orders.status = 'initiated')
    ");



    // slct all get 
    //$failed_orders_q = mysqli_query($connect, "
    //SELECT orders.*, services.api_order_id, services.provider_id 
    //FROM orders 
    // JOIN services ON orders.service_id = services.id 
    //WHERE orders.id IN ($ids_str)


} else {
    // fallback: all failed/initiated orders
    $failed_orders_q = mysqli_query($connect, "
        SELECT orders.*, services.api_order_id, services.provider_id 
        FROM orders 
        JOIN services ON orders.service_id = services.id 
        WHERE orders.status = 'failed' OR orders.status = 'initiated'
    ");
}


if (mysqli_num_rows($failed_orders_q) == 0) {
    $_SESSION['error'] = "❌ No failed orders found.";
    header("Location: ../admin/all_orders");
    exit;
}

while ($order = mysqli_fetch_assoc($failed_orders_q)) {
    $service_id = intval($order['service_id']);
    $link = $order['link'];
    $quantity = intval($order['quantity']);
    $order_db_id = intval($order['id']);
    $api_service_id = intval($order['api_order_id']);
    $provider_id = intval($order['provider_id']);

    if (!$api_service_id || !$provider_id) {
        continue; // skip if not configured
    }

    // ✅ Get provider API credentials
    $provider_q = mysqli_query($connect, "SELECT api_key, api_url FROM providers WHERE id = $provider_id");
    $provider = mysqli_fetch_assoc($provider_q);

    if (!$provider || empty($provider['api_key']) || empty($provider['api_url'])) {
        continue; // skip if missing
    }

    $api = new Api($api_key, $api_url);


    // Prepare data
    $data = [
        'service' => $api_service_id,
        'link' => $link,
        'quantity' => $quantity
    ];

    // API Call
    $api_response = $api->order($data);
    $response_json = mysqli_real_escape_string($connect, json_encode($api_response));

    if (isset($api_response->order) && is_numeric($api_response->order)) {
        $api_order_id = $api_response->order;
        mysqli_query($connect, "
            UPDATE orders 
            SET api_order_id = '$api_order_id', status = 'pending', api_response = '$response_json' 
            WHERE id = $order_db_id
        ");
    } else {
        mysqli_query($connect, "
            UPDATE orders 
            SET status = 'failed', api_response = '$response_json' 
            WHERE id = $order_db_id
        ");
    }
}

$_SESSION['success'] = "✅ All failed/initiated orders re-sent to respective provider APIs.";
header("Location: ../admin/all_orders");
exit;
