<?php

include '../config/db.php';
include '../public/session.php'; // Check login session

// ✅ Check: api_order_id exists
if (!isset($_GET['api_order_id']) || empty($_GET['api_order_id'])) {
    $_SESSION['msg'] = "❌ Invalid Refill Request.";
    header("Location: ../orders");
    exit;
}

$api_order_id = mysqli_real_escape_string($connect, $_GET['api_order_id']);

// ✅ Step 1: Get service_id from orders table
$order_q = mysqli_query($connect, "SELECT service_id FROM orders WHERE api_order_id = '$api_order_id' LIMIT 1");
$order = mysqli_fetch_assoc($order_q);
if (!$order) {
    $_SESSION['msg'] = "❌ Order not found.";
    header("Location: ../orders");
    exit;
}

$service_id = $order['service_id'];

// ✅ Step 2: Get provider_id from services table
$service_q = mysqli_query($connect, "SELECT provider_id FROM services WHERE id = $service_id LIMIT 1");
$service = mysqli_fetch_assoc($service_q);
if (!$service || !$service['provider_id']) {
    $_SESSION['msg'] = "❌ Provider not found for this service.";
    header("Location: ../orders");
    exit;
}

$provider_id = $service['provider_id'];

// ✅ Step 3: Get api_key & api_url from providers table
$provider_q = mysqli_query($connect, "SELECT api_key, api_url FROM providers WHERE id = $provider_id LIMIT 1");
$provider = mysqli_fetch_assoc($provider_q);
if (!$provider) {
    $_SESSION['msg'] = "❌ API credentials not found.";
    header("Location: ../orders");
    exit;
}

$api_key = $provider['api_key'];
$api_url = $provider['api_url'];

// ✅ API Class
// class Api
// {
//     public $api_url;
//     public $api_key;

//     public function __construct($key, $url)
//     {
//         $this->api_key = $key;
//         $this->api_url = $url;
//     }

//     public function refill($order_id)
//     {
//         $post = [
//             'key' => $this->api_key,
//             'action' => 'refill',
//             'order' => $order_id
//         ];
//         return json_decode($this->connect($post));
//     }

//     private function connect($post)
//     {
//         $_post = [];
//         foreach ($post as $name => $value) {
//             $_post[] = $name . '=' . urlencode($value);
//         }

//         $ch = curl_init($this->api_url);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
//         curl_setopt($ch, CURLOPT_POST, 1);
//         curl_setopt($ch, CURLOPT_HEADER, 0);
//         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
//         curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
//         curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, join('&', $_post));
//         curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0');
//         $result = curl_exec($ch);
//         curl_close($ch);
//         return $result;
//     }
// }

// smm api
include 'api_class.php';

// ✅ API Call
$api = new Api($api_key, $api_url);
$response = $api->refill($api_order_id);

// ✅ Result Check
if (isset($response->refill)) {
    $_SESSION['msg'] = "✅ Refill sent successfully!";
} elseif (isset($response->error)) {
    $_SESSION['msg'] = "❌ Refill failed: " . $response->error;
} else {
    $_SESSION['msg'] = "⚠️ Unknown response received from API.";
}

// ✅ Redirect
header("Location: ../orders");
exit;
