<?php
// sesen
include '../public/session.php';
// db
include '../config/db.php';

// api class smm
include 'api_class.php';
// time
date_default_timezone_set("Asia/Colombo");

//  API Class
// class Api
// {
//     public $api_url;
//     public $api_key;

//     public function __construct($api_key = '', $api_url = '')
//     {
//         $this->api_key = $api_key;
//         $this->api_url = $api_url;
//     }

//     public function order($params)
//     {
//         $params['key'] = $this->api_key;
//         $params['action'] = 'add';
//         return json_decode($this->connect($params));
//     }

//     private function connect($post)
//     {
//         $_post = [];
//         foreach ($post as $name => $value) {
//             $_post[] = $name . '=' . urlencode($value);
//         }

//         $ch = curl_init($this->api_url);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_POST, true);
//         curl_setopt($ch, CURLOPT_POSTFIELDS, join('&', $_post));
//         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
//         $result = curl_exec($ch);
//         curl_close($ch);
//         return $result;
//     }
// }

//user get
$user_id = $_SESSION['id'];
$user_q = mysqli_query($connect, "SELECT * FROM users2 WHERE id = $user_id");
$user = mysqli_fetch_assoc($user_q);
$balance = $user['balance'];
$name = $user['username'];
$commission = $user['comisen_parsentag'];


// Step 1: get commission percentage from users2
// $com_query = $connect->prepare("SELECT comisen_parsentag FROM users2 WHERE id = ?");
// $com_query->bind_param("i", $user_id);
// $com_query->execute();
// $com_result = $com_query->get_result();
// $commission = 0;

// if ($row = $com_result->fetch_assoc()) {
//     $commission = floatval($row['comisen_parsentag']);
// }

// mt aryyy
$errors = [];
$success = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (empty($_POST['mass_order'])) {
        $_SESSION['error'] = "Please enter mass order data.";
        header("Location: ../mass_order");
        exit;
    }

    // chak mass ordr formet
    $mass_orders = explode("\n", trim($_POST['mass_order']));
    $total_price = 0;
    $orders = [];

    foreach ($mass_orders as $line) {
        $line = trim($line);
        if ($line === '') continue;

        $parts = explode('|', $line);
        if (count($parts) !== 3) {
            $_SESSION['error'] = " Invalid format in line: $line. Use format: service_id|quantity|link";
            header("Location: ../mass_order");
            exit;
        }

        // post data aryy store
        [$service_id, $quantity, $link] = array_map('trim', $parts);

        // inpu data cheak
        if (!is_numeric($service_id) || !is_numeric($quantity) || $quantity <= 0) {
            $_SESSION['error'] = " Invalid data in line: $line";
            header("Location: ../mass_order");
            exit;
        }

        //  Get service  and custome price cutom quantity 
        $service_q = mysqli_query($connect, "SELECT s.*, cp.costome_price, cq.min_quantity AS cq_min, cq.max_quantity AS cq_max 
            FROM services s
            LEFT JOIN custom_prices cp ON s.id = cp.service_id AND cp.user_id = $user_id
            LEFT JOIN custom_quantity cq ON s.id = cq.service_id AND cq.user_id = $user_id
            WHERE s.id = $service_id AND s.status = 'active'");
        $service = mysqli_fetch_assoc($service_q);

        // if service not found
        if (!$service) {
            $_SESSION['error'] = " Service ID $service_id not found.";
            header("Location: ../mass_order");
            exit;
        }


        // 2. Check if category is hidden for this user
        $category_id = intval($service['category_id']);
        $hide_check_q = mysqli_query($connect, "
    SELECT * FROM hide_category 
    WHERE user_id = $user_id AND category_id = $category_id AND status = 1
");
        if (mysqli_num_rows($hide_check_q) > 0) {
            // User has hidden this category
            $_SESSION['error'] = " Category ID $category_id is hidden for this user.";
            header("Location: ../mass_order");
            exit;
        }

        // cheak quantity custome and normal
        $min = $service['cq_min'] ?? $service['min_quantity'];
        $max = $service['cq_max'] ?? $service['max_quantity'];
        $price_per_1000 = $service['costome_price'] ?? $service['price'];

        // if quantity not in range
        if ($quantity < $min || $quantity > $max) {
            $_SESSION['error'] = " Quantity $quantity not in range ($min - $max) for service $service_id.";
            header("Location: ../mass_order");
            exit;
        }

        // calculate price
        $final_price_per_1000 = $price_per_1000 - ($price_per_1000 * $commission / 100);

        $price = ($final_price_per_1000 / 1000) * $quantity;
        $total_price += $price;

        // store data
        $orders[] = [
            'service' => $service,
            'quantity' => $quantity,
            'link' => $link,
            'price' => $price
        ];
    }

    // check balance
    if ($total_price > $balance) {
        $_SESSION['error'] = " Insufficient balance. Need $total_price, You have $balance.";
        header("Location: ../mass_order");
        exit;
    }

    // order place
    $order_ids = [];

    // place order and update balance and status
    foreach ($orders as $ord) {
        $service = $ord['service'];
        $service_id = $service['id'];
        $service_name = $service['service_name'];
        $provider_id = $service['provider_id'];
        $api_service_id = $service['api_order_id'];
        $quantity = $ord['quantity'];
        $link = $ord['link'];
        $price = $ord['price'];

        // Deduct balance
        mysqli_query($connect, "UPDATE users2 SET balance = balance - $price WHERE id = $user_id");

        // Insert order
        mysqli_query($connect, "INSERT INTO orders (username, service_id, quantity, link, price, status, sarvice_name, created_at) 
            VALUES ('$name', $service_id, $quantity, '$link', $price, 'initiated', '$service_name', NOW())");
        $order_id = mysqli_insert_id($connect);

        // Success message
        $success[] = " Order ID $order_id placed.";

        // Store order data array
        $order_ids[] = [
            'id' => $order_id,
            'api_service_id' => $api_service_id,
            'link' => $link,
            'quantity' => $quantity,
            'provider_id' => $provider_id
        ];
    }

    //  Store success message before redirect
    $_SESSION['success'] = implode("<br>", $success);

    //  Redirect user immediately
    header("Location: ../mass_order");
    ignore_user_abort(true);
    ob_start();
    echo "Processing...";
    header("Connection: close");
    header("Content-Length: " . ob_get_length());
    ob_end_flush();
    flush();

    //  Continue background API calls after user redirect
    foreach ($order_ids as $ord) {
        $order_id = $ord['id'];
        $api_service_id = $ord['api_service_id'];
        $link = $ord['link'];
        $quantity = $ord['quantity'];
        $provider_id = $ord['provider_id'];

        // Get provider
        $provider_q = mysqli_query($connect, "SELECT api_key, api_url FROM providers WHERE id = $provider_id");
        $provider = mysqli_fetch_assoc($provider_q);

        if (!$provider) continue;

        // API call
        $api = new Api($provider['api_key'], $provider['api_url']);
        $data = ['service' => $api_service_id, 'link' => $link, 'quantity' => $quantity];

        // API call
        $response = $api->order($data);
        $json_response = mysqli_real_escape_string($connect, json_encode($response));

        // Update DB
        if (isset($response->order) && is_numeric($response->order)) {
            $api_order_id = $response->order;
            // Update DB success
            mysqli_query($connect, "UPDATE orders SET api_order_id='$api_order_id', status='pending', api_response='$json_response' WHERE id=$order_id");
        } else {
            // Update DB failed
            mysqli_query($connect, "UPDATE orders SET status='failed', api_response='$json_response' WHERE id=$order_id");
        }
    }

    exit;
}
