<?php
include '../config/db.php';
include 'session.php';

// Delete logic
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);

    // Step 1: Get image path from database
    $getQuery = "SELECT payment_image FROM payment_request WHERE id = $id";
    $getResult = mysqli_query($connect, $getQuery);

    if ($getResult && mysqli_num_rows($getResult) > 0) {
        $row = mysqli_fetch_assoc($getResult);
        $imagePath = $row['payment_image'];

        // Step 2: Delete the image file from folder if exists
        $fullPath = "../" . $imagePath; // ← one step up added here
        if (!empty($imagePath) && file_exists($fullPath)) {
            unlink($fullPath); // Delete file from one folder above
        }

        // Step 3: Delete record from database
        $deleteQuery = "DELETE FROM payment_request WHERE id = $id";
        mysqli_query($connect, $deleteQuery);

        $_SESSION['success'] = "✅ Payment request & image deleted successfully.";
    } else {
        $_SESSION['error'] = "❌ Record not found.";
    }

    header("Location: view_payment_requests");
    exit;
}



// Fetch all payment requests
$query = "SELECT * FROM payment_request ORDER BY id DESC";
$result = mysqli_query($connect, $query);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <title>View Payment Requests</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta charset="UTF-8">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <?php include 'include/header.php'; ?>

    <div class="container mt-5">
        <h3 class="mb-4 fw-bold text-center text-primary">💳 All Payment Requests</h3>

        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?php echo $_SESSION['success'];
                                                unset($_SESSION['success']); ?></div>
        <?php endif; ?>

        <div class="table-responsive shadow rounded">
            <table class="table table-bordered table-hover text-center align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Email</th>
                        <th>WhatsApp</th>
                        <th>Method</th>
                        <th>Image</th>
                        <th>Created At</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td><?php echo $row['id']; ?></td>
                            <td><?php echo htmlspecialchars($row['username']); ?></td>
                            <td><?php echo htmlspecialchars($row['email']); ?></td>
                            <td><?php echo htmlspecialchars($row['whatsapp_number']); ?></td>
                            <td><?php echo htmlspecialchars($row['payment_method']); ?></td>
                            <td>
                                <?php if (!empty($row['payment_image'])): ?>
                                    <a href="<?php echo $row['payment_image']; ?>" target="_blank">
                                        <img src="../<?php echo $row['payment_image']; ?>" width="80" height="60" class="rounded border">
                                    </a>
                                <?php else: ?>
                                    <span class="text-muted">No image</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo $row['created_at']; ?></td>
                            <td>
                                <a href="?delete=<?php echo $row['id']; ?>" onclick="return confirm('Are you sure to delete?')" class="btn btn-sm btn-danger">
                                    🗑️ Delete
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
<script>
    // Optional: Add any JavaScript functionality if needed