<?php include 'session.php'; ?>
<?php
include '../config/db.php';

// Fetch existing setting (only 1 row expected)
$result = $connect->query("SELECT * FROM setting LIMIT 1");
$data = $result->fetch_assoc();






// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $whatsapp = $_POST['whatsapp'];
    $sitename = $_POST['sitename'];
    $email = $_POST['email'];
    $image = $_POST['image'];
    $header_img = $_POST['header_img'];
    $header_name = $_POST['header_name'];
    $main_name = $_POST['main_name'];
    $api_key = $_POST['api_key'];
    $background_color = $_POST['background'];
    $user_conformasen = $_POST['user_conformasen'];
    $api_url = $_POST['api_url'];
    $extraprofit = $_POST['extraprofit'];
   $google_login = isset($_POST['google_login']) ? 1 : 0; // ✅ checkbox
    $google_client_id = $_POST['google_client_id'];
    $google_secret_key = $_POST['google_secret_key'];
    $integration = $_POST['integration'] ?? null;


    if ($data) {
        $stmt = $connect->prepare("UPDATE setting SET whatsapp_number=?, sitename=?, admin_email=?, site_image=?, header_img=?, header_name=?, main_name=?, api_key=?, background=?, user_conformasen=?, api_url=?,extraprofit=?,google_login=?,google_client_id=?,google_secret_key=?,integration=? WHERE id=?");
        $stmt->bind_param("sssssssssisiisssi", $whatsapp, $sitename, $email, $image, $header_img, $header_name, $main_name, $api_key, $background_color, $user_conformasen, $api_url, $extraprofit, $google_login, $google_client_id, $google_secret_key,$integration, $data['id']);
        $stmt->execute();
        $message = "Updated Successfully";
    } else {
        $stmt = $connect->prepare("INSERT INTO setting (whatsapp_number, sitename, admin_email, site_image, header_img, header_name, main_name, api_key, background, user_conformasen, api_url,extraprofit) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssssssssi", $whatsapp, $sitename, $email, $image, $header_img, $header_name, $main_name, $api_key, $background_color, $user_conformasen, $api_url, $extraprofit);
        $stmt->execute();
        $message = "Inserted Successfully";
    }

    header("Location: setting?msg=" . urlencode($message));
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Site Setting</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">
    <?php include 'include/header.php'; ?>



    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="card border-0 shadow-lg">
                    <div class="card-body p-4">






                        <h3 class="card-title mb-4 text-center">Site Setting</h3>

                        <?php if (isset($_GET['msg'])): ?>
                            <div class="alert alert-success text-center"><?= htmlspecialchars($_GET['msg']) ?></div>
                        <?php endif; ?>

                        <form method="post">
                            <div class="mb-3">
                                <label class="form-label">Contact Floating Button text</label>
                                <textarea name="whatsapp" class="form-control text-start" rows="3" required><?= htmlspecialchars($data['whatsapp_number'] ?? '') ?></textarea>
                            </div>
                            
                            
                            <div class="mb-3">
    <label class="form-label">Integration (Code)</label>
    <textarea name="integration" class="form-control" rows="5"><?= htmlspecialchars($data['integration'] ?? '') ?></textarea>
</div>



                            <div class="mb-3">
                                <label class="form-label">Site Name</label>
                                <input type="text" name="sitename" class="form-control" value="<?= htmlspecialchars($data['sitename'] ?? '') ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Admin Email</label>
                                <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($data['admin_email'] ?? '') ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Site Image URL</label>
                                <input type="text" name="image" class="form-control" value="<?= htmlspecialchars($data['site_image'] ?? '') ?>">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Site Header Image URL</label>
                                <input type="text" name="header_img" class="form-control" value="<?= htmlspecialchars($data['header_img'] ?? '') ?>">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Site Header Name</label>
                                <input type="text" name="header_name" class="form-control" value="<?= htmlspecialchars($data['header_name'] ?? '') ?>">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Site Name</label>
                                <input type="text" name="main_name" class="form-control" value="<?= htmlspecialchars($data['main_name'] ?? '') ?>">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Extraprofit %</label>
                                <input type="number" name="extraprofit" class="form-control" value="<?= htmlspecialchars($data['extraprofit'] ?? '50') ?>">
                            </div>



                            <div class="mb-3">
                                <label class="form-label">User Conformasen</label>
                                <select name="user_conformasen" class="form-select">
                                    <option value="1" <?= (isset($data['user_conformasen']) && $data['user_conformasen'] == 1) ? 'selected' : '' ?>>Yes</option>
                                    <option value="0" <?= (isset($data['user_conformasen']) && $data['user_conformasen'] == 0) ? 'selected' : '' ?>>No</option>
                                </select>
                            </div>

                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="google_login" id="google_login" <?= (!empty($data['google_login']) && $data['google_login'] == 1) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="google_login">Enable Google Login</label>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Google Client ID</label>
                                <input type="text" name="google_client_id" class="form-control" value="<?= htmlspecialchars($data['google_client_id'] ?? '') ?>">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Google Secret Key</label>
                                <input type="text" name="google_secret_key" class="form-control" value="<?= htmlspecialchars($data['google_secret_key'] ?? '') ?>">
                            </div>


                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Save Setting</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>



</body>

</html>