<?php
require('../config/db.php'); // DB connection
include 'session.php';


$statusMsg = "";
$currentMessage = "";

// Fetch old message from DB
$result = mysqli_query($connect, "SELECT message FROM popup_messages LIMIT 1");
if ($row = mysqli_fetch_assoc($result)) {
  $currentMessage = $row['message'];
}

if (isset($_POST['submit'])) {
  $message = $_POST['message'];

  // Delete old messages
  mysqli_query($connect, "DELETE FROM popup_messages");

  // Insert new message
  $stmt = mysqli_prepare($connect, "INSERT INTO popup_messages (message) VALUES (?)");
  mysqli_stmt_bind_param($stmt, "s", $message);
  mysqli_stmt_execute($stmt);
  mysqli_stmt_close($stmt);

  $statusMsg = "✅ Message updated successfully!";
  $currentMessage = $message; // Update variable
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title>Update Popup Message</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Head section -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.css" rel="stylesheet" />

</head>

<body class="bg-light">
 <?php include 'include/header.php'; ?>

  <div class="container mt-5">
    <div class="form-box bg-white p-4 rounded shadow-sm">
      <h3 class="mb-4 text-primary text-center">✏️ Update Popup Message</h3>

      <?php if ($statusMsg): ?>
        <div class="alert alert-success"><?= $statusMsg ?></div>
      <?php endif; ?>

      <!-- Body -->
      <form method="post">
        <div class="mb-3">
          <label for="message" class="form-label fw-semibold">Popup Message (with formatting):</label>
          <textarea id="summernote" name="message"><?= htmlspecialchars($currentMessage) ?></textarea>
        </div>
        <div class="text-end">
          <button type="submit" name="submit" class="btn btn-success">Update Message</button>
        </div>
      </form>
    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <!-- Footer Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.js"></script>
  <script>
    $(document).ready(function() {
      $('#summernote').summernote({
        placeholder: 'Type your styled popup message...',
        tabsize: 2,
        height: 250,
        toolbar: [
          ['style', ['style']],
          ['font', ['bold', 'underline', 'italic', 'clear']],
          ['color', ['color']],
          ['fontsize', ['fontsize']],
          ['para', ['ul', 'ol', 'paragraph']],
          ['insert', ['link']],
          ['view', ['codeview']]
        ]
      });
    });
  </script>
</body>

</html>