<?php
include '../../config/db.php';
header('Content-Type: application/json');

$order_id = isset($_POST['order_id']) ? intval($_POST['order_id']) : 0;

if($order_id > 0){
    $stmt = $connect->prepare("SELECT service_id FROM orders WHERE id = ?");
    $stmt->bind_param("i", $order_id);
    $stmt->execute();
    $stmt->bind_result($service_id);
    if($stmt->fetch()){
        $stmt->close();

        $stmt2 = $connect->prepare("
            SELECT p.id, p.provider_name, p.api_url 
            FROM services s 
            INNER JOIN providers p ON s.provider_id = p.id
            WHERE s.id = ?
        ");
        $stmt2->bind_param("i", $service_id);
        $stmt2->execute();
        $result = $stmt2->get_result();
        if($provider = $result->fetch_assoc()){
            echo json_encode(['status' => 'success', 'provider' => $provider]);
            exit;
        } else {
            echo json_encode(['status'=>'error','message'=>'Provider not found']);
            exit;
        }
    } else {
        echo json_encode(['status'=>'error','message'=>'Order not found']);
        exit;
    }
} else {
    echo json_encode(['status'=>'error','message'=>'Invalid order ID']);
}
?>
