<!-- db & sesen -->
<?php include 'session.php'; ?>
<?php include '../config/db.php'; ?>

<?php

// privider sesen cheak
if (!isset($_SESSION['selected_provider_id'])) {
    header("Location: select_provider");
    exit();
}

// sesen provider id get
$provider_id = $_SESSION['selected_provider_id'];

// get provider data
$stmt = $connect->prepare("SELECT api_key, api_url, cransi_type FROM providers WHERE id = ?");
$stmt->bind_param("i", $provider_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows == 0) {
    die("Invalid Provider ID");
}
$row_provider = $result->fetch_assoc();

$api_key = $row_provider['api_key'];
$api_url = $row_provider['api_url'];
$currency_type = $row_provider['cransi_type'];

$import_services = [];

// data json get
if (!empty($_POST['import_data_json'])) {
    $import_services = json_decode($_POST['import_data_json'], true);
}


// category get
$categories = [];
$category_result = $connect->query("SELECT id, category_name FROM category ORDER BY category_name ASC");

if ($category_result && $category_result->num_rows > 0) {
    while ($row = $category_result->fetch_assoc()) {
        $categories[$row['id']] = $row['category_name'];
    }
}




?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imported Services Preview</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <!-- hader -->
    <?php include 'include/header.php'; ?>
    <div class="container mt-4">


        <!-- exra % input box -->
        <div class="mb-3 row align-items-center">
            <label for="globalExtraPercent" class="col-sm-3 col-form-label fw-bold">Extra Price % to Add for All:</label>
            <div class="col-sm-3">

                <input type="number" id="globalExtraPercent" class="form-control" step="0.01" min="0" max="100" value="0" />
            </div>
        </div>


        <h2 class="mb-4 fw-bold text-success"> Selected Services Preview</h2>

        <?php if (!empty($import_services)): ?>
            <form id="importForm">




                <input type="hidden" id="importJsonData"
                    value='<?= json_encode($import_services, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>'>
                <input type="hidden" name="extra_percent" id="hiddenExtraPercent" value="0">


                <!-- Tableக்கு மேலே category select -->
                <div class="mb-3 row align-items-center">
                    <label for="globalCategory" class="col-sm-3 col-form-label fw-bold">Select Category for All:</label>
                    <div class="col-sm-3">
                        <select id="globalCategory" class="form-select">
                            <option value="__default__">-- Default Category (Api category) --</option>
                            <?php foreach ($categories as $catId => $catName): ?>
                                <option value="<?= htmlspecialchars($catName) ?>"><?= htmlspecialchars($catName) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>



                <div class="table-responsive">
                    <table class="table table-bordered table-hover align-middle">
                        <thead class="table-dark text-center">
                            <tr>
                                <th>Service ID</th>
                                <th>Category</th>
                                <th>Name</th>
                                <th>Type</th>
                                <th>Rate LKR</th>
                                <th>Min Qty</th>
                                <th>Max Qty</th>
                                <th>Refill</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($import_services as $index => $service):



                            ?>


                                <tr>
                                    <td>
                                        <input type="text" name="import_data_json[<?= $index ?>][service_id]" class="form-control text-center" value="<?= htmlspecialchars($service['service_id']) ?>" readonly>
                                    </td>
                                    <td>
                                        <input type="text"
                                            name="import_data_json[<?= $index ?>][category]"
                                            class="form-control category-input"
                                            value="<?= htmlspecialchars($service['category']) ?>">
                                        <!-- original backup -->
                                        <input type="hidden" class="original-category" value="<?= htmlspecialchars($service['category']) ?>">
                                    </td>


                                    <td>
                                        <input type="text" name="import_data_json[<?= $index ?>][name]" class="form-control" value="<?= htmlspecialchars($service['name']) ?>">
                                    </td>
                                    <td>
                                        <input type="text" name="import_data_json[<?= $index ?>][type]" class="form-control text-center" value="<?= htmlspecialchars($service['type']) ?>">
                                    </td>
                                    <td>
                                        <input type="number" step="0.000001" name="import_data_json[<?= $index ?>][rate]" class="form-control text-end rate-input"
                                            value="<?= htmlspecialchars($service['rate']) ?>"
                                            data-original-rate="<?= htmlspecialchars($service['rate']) ?>" />

                                    </td>

                                    <td>
                                        <input type="number" name="import_data_json[<?= $index ?>][min]" class="form-control text-center" value="<?= htmlspecialchars($service['min']) ?>">
                                    </td>
                                    <td>
                                        <input type="number" name="import_data_json[<?= $index ?>][max]" class="form-control text-center" value="<?= htmlspecialchars($service['max']) ?>">
                                    </td>
                                    <td>
                                        <select name="import_data_json[<?= $index ?>][refill]" class="form-select text-center">
                                            <option value="1" <?= $service['refill'] ? 'selected' : '' ?>>Yes</option>
                                            <option value="0" <?= !$service['refill'] ? 'selected' : '' ?>>No</option>
                                        </select>
                                    </td>
                                    <td>
                                        <textarea name="import_data_json[<?= $index ?>][desc]" class="form-control" rows="2"><?= htmlspecialchars($service['desc']) ?></textarea>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>

                    </table>
                </div>

                <div class="text-end">
                    <button type="submit" class="btn btn-success mt-3 mb-5"> Confirm & Import to DB</button>
                </div>
            </form>
        <?php else: ?>
            <div class="alert alert-warning"> No services selected for preview or import.</div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // hidden input exra % send back end
        document.getElementById('globalExtraPercent').addEventListener('input', function() {
            const extraPercent = parseFloat(this.value) || 0;

            // update hidden input for backend
            document.getElementById('hiddenExtraPercent').value = extraPercent;

            document.querySelectorAll('.rate-input').forEach(rateInput => {
                const originalRate = parseFloat(rateInput.getAttribute('data-original-rate')) || 0;
                const newRate = originalRate + (originalRate * extraPercent / 100);
                rateInput.value = newRate.toFixed(6);
            });
        });
    </script>
    <script>
        // category change
        document.getElementById('globalCategory').addEventListener('change', function() {
            const selectedCat = this.value;

            document.querySelectorAll('.category-input').forEach((input, idx) => {
                const originalCat = document.querySelectorAll('.original-category')[idx].value;

                if (selectedCat === "__default__") {
                    // default original category
                    input.value = originalCat;
                } else {
                    // selected category
                    input.value = selectedCat;
                }
            });
        });
    </script>



    <script>
        document.getElementById("importForm").addEventListener("submit", async function(e) {
            e.preventDefault();

            //  force update all input values to DOM
            document.activeElement.blur();
            await new Promise(resolve => setTimeout(resolve, 50));


            const btn = this.querySelector('button[type="submit"]');
            btn.disabled = true;
            btn.textContent = "Importing... Please wait";

            //  Read all updated values directly from the table
            const rows = document.querySelectorAll("tbody tr");
            let importData = [];

            rows.forEach(row => {
                const service = {
                    service_id: row.querySelector('input[name*="[service_id]"]').value.trim(),
                    category: row.querySelector('input[name*="[category]"]').value.trim(),
                    name: row.querySelector('input[name*="[name]"]').value.trim(),
                    type: row.querySelector('input[name*="[type]"]').value.trim(),
                    rate: parseFloat(row.querySelector('input[name*="[rate]"]').value) || 0,
                    min: parseInt(row.querySelector('input[name*="[min]"]').value) || 0,
                    max: parseInt(row.querySelector('input[name*="[max]"]').value) || 0,
                    refill: parseInt(row.querySelector('select[name*="[refill]"]').value),
                    desc: row.querySelector('textarea[name*="[desc]"]').value.trim()
                };
                importData.push(service);
            });


            const extraPercent = parseFloat(document.getElementById('hiddenExtraPercent').value) || 0;
            const batchSize = 30;
            let totalInserted = 0;

            // Progress bar
            const progressContainer = document.createElement("div");
            progressContainer.classList.add("progress", "my-4");
            progressContainer.innerHTML = `
        <div class="progress-bar progress-bar-striped progress-bar-animated bg-success"
             id="importProgress" style="width:0%">0%</div>`;
            this.parentElement.insertBefore(progressContainer, this.nextSibling);
            const progressBar = document.getElementById("importProgress");

            //  Batch Sending
            for (let i = 0; i < importData.length; i += batchSize) {
                const batch = importData.slice(i, i + batchSize);

                try {
                    const res = await fetch("final_import.php", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json"
                        },
                        body: JSON.stringify({
                            batch_data: batch,
                            extra_percent: extraPercent
                        })
                    });

                    const result = await res.json();

                    if (result.status === "success") {
                        totalInserted += result.inserted;
                    }
                } catch (err) {
                }

                const percent = Math.min(((i + batchSize) / importData.length) * 100, 100).toFixed(1);
                progressBar.style.width = percent + "%";
                progressBar.textContent = percent + "%";
            }

            progressBar.classList.remove("progress-bar-animated");
            btn.textContent = ` Done! ${totalInserted} Services Imported`;
        });

    </script>


</body>

</html>