<?php
include 'session.php';
include '../config/db.php';

// Handle deletion
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['action'] === 'delete') {
    $id = (int)$_POST['id'];
    $stmt = $connect->prepare("DELETE FROM hide_category WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}

// Fetch data to show table
$data = $connect->query("
    SELECT hc.id, u.username AS user, c.category_name AS category
    FROM hide_category hc
    JOIN users2 u ON hc.user_id = u.id
    JOIN category c ON hc.category_id = c.id
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Hide Category Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <meta name="viewport" content="width=device-width, initial-scale=1">
</head>

<body>
<?php include 'include/header.php'; ?>

<div class="container mt-4">
    <h2 class="mb-4 fw-bold text-danger">🙈 Hidden Categories Manager</h2>

    <a href="hide_category_set.php" class="btn btn-danger mb-3">➕ Hide New Category</a>

    <div class="table-responsive" id="hideCategoryTable">
        <input type="text" id="searchInput" class="form-control mb-3" placeholder="🔍 Search by User or Category">

        <table class="table table-bordered table-hover align-middle">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Category</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $data->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['id']) ?></td>
                        <td><?= htmlspecialchars($row['user']) ?></td>
                        <td><?= htmlspecialchars($row['category']) ?></td>
                        <td>
                            <form method="post" class="d-inline" onsubmit="return confirm('Are you sure to unhide this category?')">
                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                <input type="hidden" name="action" value="delete">
                                <button class="btn btn-danger btn-sm">🗑 Unhide</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    // Search Function
    $(document).ready(function () {
        $('#searchInput').on('input', function () {
            var value = $(this).val().toLowerCase();
            $("#hideCategoryTable tbody tr").filter(function () {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
            });
        });
    });
</script>
</body>
</html>
