<?php
include 'session.php';
include '../config/db.php';

// Fetch users and services for selects
$users = $connect->query("SELECT id, username FROM users2");
$services = $connect->query("SELECT id, service_name FROM services");

// Handle form actions
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $action = $_POST['action'];
    $user_id = isset($_POST['user_id']) ? (int)$_POST['user_id'] : 0;
    $service_id = isset($_POST['service_id']) ? (int)$_POST['service_id'] : 0;
    $price = $_POST['costome_price'] ?? '';
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;

    if ($action === "add") {
        $stmt = $connect->prepare("INSERT INTO custom_prices (user_id, service_id, costome_price) VALUES (?, ?, ?)");
        $stmt->bind_param("iis", $user_id, $service_id, $price);
        $stmt->execute();
    } elseif ($action === "edit") {
        $stmt = $connect->prepare("UPDATE custom_prices SET costome_price=? WHERE id=?");
        $stmt->bind_param("si", $price, $id);
        $stmt->execute();
    } elseif ($action === "delete") {
        $stmt = $connect->prepare("DELETE FROM custom_prices WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
    }

    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}

// Fetch data for table
$data = $connect->query("
    SELECT cp.id, u.username AS user, s.service_name AS service, cp.costome_price 
    FROM custom_prices cp
    JOIN users2 u ON cp.user_id = u.id
    JOIN services s ON cp.service_id = s.id
");
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>Custom Price Manager</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

</head>

<body>
    <?php include 'include/header.php'; ?>





    <div class="container mt-4">
        <h2 class="mb-4 fw-bold text-primary">Custom Price Manager</h2>

<a href="set_custom_price" class="btn btn-success mb-3" > Set Custom Price</a>

        <!-- Table -->
        <div class="table-responsive" id="userBalanceTable">
                  <input type="text" id="searchInput" class="form-control mb-3" placeholder="🔍 Search by Name or Number">

            <table class="table table-bordered table-hover align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Service</th>
                        <th>Custom Price</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $data->fetch_assoc()): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['id']) ?></td>
                            <td><?= htmlspecialchars($row['user']) ?></td>
                            <td><?= htmlspecialchars($row['service']) ?></td>
                            <td><?= htmlspecialchars($row['costome_price']) ?></td>
                            <td>
                                <button
                                    class="btn btn-primary btn-sm editBtn"
                                    data-bs-toggle="modal"
                                    data-bs-target="#editModal"
                                    data-id="<?= $row['id'] ?>"
                                    data-price="<?= htmlspecialchars($row['costome_price']) ?>">Edit</button>

                                <form method="post" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this?')">
                                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                    <input type="hidden" name="action" value="delete">
                                    <button class="btn btn-danger btn-sm">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>










    <!-- Edit Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <form method="post" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Custom Price</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="editId" value="" />
                    <input type="hidden" name="action" value="edit" />

                    <div class="mb-3">
                        <label for="editPrice" class="form-label">Price</label>
                        <input type="text" id="editPrice" name="costome_price" class="form-control" required />
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>







    <script>
        // Edit button fill modal inputs
        document.querySelectorAll('.editBtn').forEach(btn => {
            btn.addEventListener('click', function() {
                const id = this.getAttribute('data-id');
                const price = this.getAttribute('data-price');

                document.getElementById('editId').value = id;
                document.getElementById('editPrice').value = price;
            });
        });
    </script>

 <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    // Search function

    $(document).ready(function() {
      // Search function
      $('#searchInput').on('input', function() {
        var value = $(this).val().toLowerCase();
        $("#userBalanceTable tbody tr").filter(function() {
          $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
      });
    });
  </script>

</body>

</html>