<?php



include 'session.php';
include '../config/db.php';



// Delete selected records
if (isset($_POST['delete_selected_categories']) && !empty($_POST['selected_ids'])) {
    $ids = $_POST['selected_ids'];

    // Clean the input to avoid SQL Injection
    $ids = array_map('intval', $ids);

    $placeholders = implode(',', array_fill(0, count($ids), '?'));

    $types = str_repeat('i', count($ids));
    $stmt = $connect->prepare("DELETE FROM category WHERE id IN ($placeholders)");
    $stmt->bind_param($types, ...$ids);
    $stmt->execute();

    $_SESSION['success'] = count($ids) . ' category(s) deleted successfully!';
    header("Location: " . $_SERVER['PHP_SELF']);
    exit();
}



// Add
if (isset($_POST['add'])) {
    $name = $_POST['category_name'];
    $order_id = $_POST['order_id'];
    $in_order = $_POST['in_order'];

    $check = $connect->prepare("SELECT id FROM category WHERE category_name = ?");
    $check->bind_param("s", $name);
    $check->execute();
    $check->store_result();

    if ($check->num_rows > 0) {
        $_SESSION['error'] = "❌ Category '$name' already exists!";
    } else {
        $stmt = $connect->prepare("INSERT INTO category (category_name, order_id, in_order) VALUES (?, ?, ?)");
        $stmt->bind_param("ssi", $name, $order_id, $in_order);
        $stmt->execute();
        $_SESSION['success'] = "✅ Category '$name' added successfully!";
    }
    header("Location: category");
    exit;
}

// Update
if (isset($_POST['update'])) {
    $id = $_POST['id'];
    $name = trim($_POST['category_name']);
    $order_id = $_POST['order_id'];
    $in_order = $_POST['in_order'];

    $check = $connect->prepare("SELECT id FROM category WHERE category_name = ? AND id != ?");
    $check->bind_param("si", $name, $id);
    $check->execute();
    $check->store_result();

    if ($check->num_rows > 0) {
        $_SESSION['error'] = "❌ Category '$name' already exists!";
        header("Location: category");
        exit;
    }

    $stmt = $connect->prepare("UPDATE category SET category_name=?, order_id=?, in_order=? WHERE id=?");
    $stmt->bind_param("ssii", $name, $order_id, $in_order, $id);
    $stmt->execute();
    header("Location: category");
    exit;
}

// Delete
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $connect->prepare("DELETE FROM category WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    header("Location: category");
    exit;
}

// in_order management manual
if (isset($_POST['move']) && isset($_POST['id'])) {
    $id = $_POST['id'];
    $direction = $_POST['move'];

    // current category fetch
    $result = $connect->prepare("SELECT id, in_order FROM category WHERE id=?");
    $result->bind_param("i", $id);
    $result->execute();
    $data = $result->get_result()->fetch_assoc();
    $current_order = $data['in_order'];

    if ($direction === 'up') {
        $stmt = $connect->prepare("SELECT id, in_order FROM category WHERE in_order < ? ORDER BY in_order DESC LIMIT 1");
    } else {
        $stmt = $connect->prepare("SELECT id, in_order FROM category WHERE in_order > ? ORDER BY in_order ASC LIMIT 1");
    }

    $stmt->bind_param("i", $current_order);
    $stmt->execute();
    $swap = $stmt->get_result()->fetch_assoc();

    if ($swap) {
        // swap in_order values
        $stmt1 = $connect->prepare("UPDATE category SET in_order=? WHERE id=?");
        $stmt1->bind_param("ii", $swap['in_order'], $id);
        $stmt1->execute();

        $stmt2 = $connect->prepare("UPDATE category SET in_order=? WHERE id=?");
        $stmt2->bind_param("ii", $current_order, $swap['id']);
        $stmt2->execute();
    }

    header("Location: category");
    exit;
}


// Fetch
$categories = $connect->query("
    SELECT * FROM category 
    ORDER BY CAST(in_order AS UNSIGNED) ASC
");

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Category Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Sortable.js Dragan Drop -->
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Bootstrap Icons CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

</head>

<body class="bg-light">
    <?php include 'include/header.php'; ?>
    <div class="container my-4">
        <h2 class="mb-4 text-center">🗂️ Category Management</h2>
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger"><?= $_SESSION['error'];
                                            unset($_SESSION['error']); ?></div>
        <?php endif; ?>
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?= $_SESSION['success'];
                                                unset($_SESSION['success']); ?></div>
        <?php endif; ?>

        <!-- Add Form -->
        <form method="POST" class="card p-4 mb-4 shadow-sm">
            <h5 class="mb-3">Add New Category</h5>
            <div class="row g-3">
                <div class="col-md-4 col-12">
                    <input type="text" name="category_name" class="form-control" placeholder="Category Name" required>
                </div>

                <div class="col-md-2 col-6">
                    <input type="number" name="in_order" class="form-control" placeholder="In Order" value="10" required>
                </div>
                <div class="col-md-2 col-12">
                    <button name="add" class="btn btn-success w-100">Add</button>
                </div>
            </div>
        </form>



        <!-- Button trigger modal -->
        <button type="button" class="btn btn-primary rounded-pill px-4 fw-bold mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalCenter">
            <i class="bi bi-sliders2-vertical me-2"></i> More Controls
        </button>

        <!-- Modal -->
        <div class="modal fade" id="exampleModalCenter" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content rounded-4 shadow">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title" id="exampleModalCenterTitle">
                            <i class="bi bi-tools me-2"></i> Advanced Actions
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center p-4">

                        <!-- 🔘 Button dlt un usde ctacrys -->
                        <form method="post" class="mb-4" action="more/delete_mt_category.php" onsubmit="return confirm('⚠️ Are you sure? This will delete all categories that are not used in services!');">
                            <button type="submit" name="cleanup" class="btn btn-danger">
                                Clean Unused Categories
                            </button>
                        </form>
                    </div>
                    <div class="modal-footer justify-content-center">
                        <button type="button" class="btn btn-outline-secondary rounded-pill" data-bs-dismiss="modal">
                            <i class="bi bi-x-circle me-2"></i> Close
                        </button>
                    </div>
                </div>
            </div>
        </div>








        <!-- Category Table -->
        <div class="card p-3 shadow-sm">
            <h5 class="mb-3">📋 Existing Categories</h5>
            <div class="table-responsive">

                <form method="POST" action="" onsubmit="return confirm('Are you sure to delete selected Categories ?')">

                    <button type="submit" class="btn btn-danger mb-2" name="delete_selected_categories">Delete Selected Categories</button>



                    <table class="table table-bordered table-hover align-middle text-center">
                        <thead class="table-dark">
                            <tr>
                                <th>
                                    <input type="checkbox" id="selectAll">
                                </th>
                                <th class="drag-handle">☰</th>
                                <th>ID</th>
                                <th>Category Name</th>

                                <th>In Order</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="sortableCategory">
                            <?php $modals = '';
                            while ($row = $categories->fetch_assoc()): ?>
                                <tr>
                                    <td class="text-center"><input type="checkbox" name="selected_ids[]" value="<?= $row['id'] ?>"></td>

                                    <td class="drag-handle">☰</td>

                                    <td><?= $row['id'] ?></td>
                                    <td><?= $row['category_name'] ?></td>

                                    <td><?= $row['in_order'] ?></td>
                                    <td>
                                        <div class="d-flex justify-content-center gap-1">
                                            <form method="POST" style="display:inline;">
                                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                                <input type="hidden" name="move" value="up">
                                                <button type="submit" class="btn btn-warning btn-sm">↑</button>
                                            </form>
                                            <form method="POST" style="display:inline;">
                                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                                <input type="hidden" name="move" value="down">
                                                <button type="submit" class="btn btn-warning btn-sm">↓</button>
                                            </form>
                                            <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#edit<?= $row['id'] ?>">Edit</button>
                                            <a href="?delete=<?= $row['id'] ?>" onclick="return confirm('Delete this category?')" class="btn btn-danger btn-sm">Delete</a>
                                        </div>
                                    </td>

                                </tr>

                                <!-- Edit Modal -->
                                <?php ob_start(); ?>
                                <div class="modal fade" id="edit<?= $row['id'] ?>" tabindex="-1">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <form method="POST" class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Edit Category</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">
                                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                                <div class="mb-3">
                                                    <label class="form-label">Category Name</label>
                                                    <input type="text" name="category_name" class="form-control" value="<?= $row['category_name'] ?>" required>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label">In Order</label>
                                                    <input type="number" name="in_order" class="form-control" value="<?= $row['in_order'] ?>" required>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="submit" name="update" class="btn btn-primary">Update</button>
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <?php $modals .= ob_get_clean(); ?>
                            <?php endwhile; ?>
                        </tbody>
                    </table>

                </form>
            </div>
        </div>

        <!-- All Edit Modals -->
        <?= $modals ?>
    </div>
    <script>
        // Dragarn Drop function
        const el = document.getElementById('sortableCategory');
        new Sortable(el, {
            animation: 150,
            handle: '.drag-handle', // Use the drag-handle class to Only allow dragging via ☰ icon
            onEnd: function(evt) {
                const rows = el.querySelectorAll('tr');
                const orderData = [];

                rows.forEach((row, index) => {
                    const id = row.querySelector('input[name="id"]')?.value || row.cells[0].innerText;
                    orderData.push({
                        id: parseInt(id),
                        order: index + 1
                    });
                });

                fetch('more/category_order_update.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(orderData)
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            console.log('✅ Order updated!');
                        } else {
                            alert('❌ Failed to update order');
                        }
                    });
            }
        });




        // Checkbox Select All
        document.getElementById('selectAll').onclick = function() {
            const checkboxes = document.querySelectorAll('input[name="selected_ids[]"]');
            for (let checkbox of checkboxes) {
                checkbox.checked = this.checked;
            }
        };
    </script>


    <style>
        .drag-handle {
            cursor: move;
            font-size: 18px;
        }
    </style>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>