<?php
require("../config/db.php");

// API-லிருந்து POST data வாங்குறது
$username = $_POST['username'] ?? '';
$amount = $_POST['amount'] ?? '';

if ($username == '' || !is_numeric($amount)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid username or amount'
    ]);
    exit;
}

// Step 1: Username இருக்கா check பண்ணுறது
$query = "SELECT balance, refer, custome_ref FROM users2 WHERE username = ?";
$stmt = mysqli_prepare($connect, $query);
mysqli_stmt_bind_param($stmt, 's', $username);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $currentBalance = $row['balance'];
    $referBy = $row['refer'];
    $custome_ref = $row['custome_ref'];
    $newBalance = $currentBalance + $amount;

    // Step 2: Balance update பண்ணுறது
    $updateQuery = "UPDATE users2 SET balance = ? WHERE username = ?";
    $updateStmt = mysqli_prepare($connect, $updateQuery);
    mysqli_stmt_bind_param($updateStmt, 'ds', $newBalance, $username);

    if (mysqli_stmt_execute($updateStmt)) {
        // Step 3: History-ல insert பண்ணுறது
        $currentDate = date('Y-m-d H:i:s');
        $action = 'Add';

        $historyQuery = "INSERT INTO balance_history (username, date, amount, action) VALUES (?, ?, ?, ?)";
        $historyStmt = mysqli_prepare($connect, $historyQuery);
        mysqli_stmt_bind_param($historyStmt, 'ssds', $username, $currentDate, $amount, $action);
        mysqli_stmt_execute($historyStmt); // optional: check success/failure



        // referral commission

        $username_refer = null;

        // Get referral info from referel table (1 row)





        $sql_comm = "SELECT referel_comisen, refrel_status FROM referel LIMIT 1";
        $stmt_comm = mysqli_prepare($connect, $sql_comm);
        mysqli_stmt_execute($stmt_comm);
        $result_comm = mysqli_stmt_get_result($stmt_comm);

        if ($row_comm = mysqli_fetch_assoc($result_comm)) {
            if ($row_comm['refrel_status'] == 1 && $row_comm['referel_comisen'] > 0) {



               if ($custome_ref <= 1) {
                    $commissionPercent = $row_comm['referel_comisen'];
                } else {
                    $commissionPercent = $custome_ref;
                }



                $commissionAmount = ($commissionPercent / 100) * $amount;

                // Get referrer's current balance & username
                $sql_balance = "SELECT balance, username FROM users2 WHERE refer = ?";
                $stmt_bal = mysqli_prepare($connect, $sql_balance);
                mysqli_stmt_bind_param($stmt_bal, "s", $referBy);
                mysqli_stmt_execute($stmt_bal);
                $result_bal = mysqli_stmt_get_result($stmt_bal);

                if ($row_bal = mysqli_fetch_assoc($result_bal)) {
                    $currentBalance = $row_bal['balance'];
                    $username_refer = $row_bal['username'];

                    $newBalance = $currentBalance + $commissionAmount;

                    // Update referrer's balance
                    $sql_update = "UPDATE users2 SET balance = ? WHERE refer = ?";
                    $stmt_update = mysqli_prepare($connect, $sql_update);
                    mysqli_stmt_bind_param($stmt_update, "ds", $newBalance, $referBy);
                    mysqli_stmt_execute($stmt_update);


                    // Insert commission record in referral_commissions
                    $date = date('Y-m-d H:i:s');
                    $sql_hist = "INSERT INTO referral_commissions (refer_username, referred_username, amount) VALUES (?, ?, ?)";
                    $stmt_hist = mysqli_prepare($connect, $sql_hist);
                    mysqli_stmt_bind_param($stmt_hist, "ssd", $username_refer, $username, $commissionAmount);
                    mysqli_stmt_execute($stmt_hist);
                }
            }
        }

        echo json_encode([
            'status' => 'success',
            'message' => 'Balance updated & history recorded',
            'refer' => $username_refer
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to update balance'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Username not found'
    ]);
}
